/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.stream.core.internal.ds;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.event.stream.core.EventStreamListener;
import org.wso2.carbon.event.stream.core.EventStreamService;
import org.wso2.carbon.event.stream.core.internal.CarbonEventStreamService;
import org.wso2.carbon.event.stream.core.internal.EventStreamRuntime;
import org.wso2.carbon.event.stream.core.internal.ds.EventStreamServiceValueHolder;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="eventStreamService.component", immediate=true)
public class EventStreamServiceDS {
    private static final Log log = LogFactory.getLog(EventStreamServiceDS.class);

    @Activate
    protected void activate(ComponentContext context) {
        try {
            EventStreamServiceValueHolder.registerEventStreamRuntime(new EventStreamRuntime());
            CarbonEventStreamService carbonEventStreamService = new CarbonEventStreamService();
            EventStreamServiceValueHolder.setCarbonEventStreamService(carbonEventStreamService);
            context.getBundleContext().registerService(EventStreamService.class.getName(), (Object)carbonEventStreamService, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Successfully deployed EventStreamService");
            }
        }
        catch (Throwable e) {
            log.error((Object)("Could not create EventStreamService : " + e.getMessage()), e);
        }
    }

    @Reference(name="config.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        EventStreamServiceValueHolder.registerConfigurationContextService(configurationContextService);
        if (EventStreamServiceValueHolder.getCarbonEventStreamService() != null) {
            EventStreamServiceValueHolder.getCarbonEventStreamService().addPendingStreams();
        }
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configurationContextService) {
        EventStreamServiceValueHolder.registerConfigurationContextService(null);
    }

    @Reference(name="eventStreamListener.service", service=EventStreamListener.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetEventStreamListener")
    protected void setEventStreamListener(EventStreamListener eventStreamListener) {
        EventStreamServiceValueHolder.registerEventStreamListener(eventStreamListener);
    }

    protected void unsetEventStreamListener(EventStreamListener eventStreamListener) {
        EventStreamServiceValueHolder.unregisterEventStreamListener(eventStreamListener);
    }
}

