/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.stream.core.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.commons.utils.DataBridgeCommonsUtils;
import org.wso2.carbon.event.stream.core.EventProducer;
import org.wso2.carbon.event.stream.core.SiddhiEventConsumer;
import org.wso2.carbon.event.stream.core.WSO2EventConsumer;
import org.wso2.carbon.event.stream.core.WSO2EventListConsumer;
import org.wso2.carbon.event.stream.core.exception.EventStreamConfigurationException;
import org.wso2.carbon.event.stream.core.internal.EventJunction;
import org.wso2.carbon.event.stream.core.internal.ds.EventStreamServiceValueHolder;

public class EventStreamRuntime {
    private static final Log log = LogFactory.getLog(EventStreamRuntime.class);
    private Map<Integer, Map<String, EventJunction>> tenantSpecificEventJunctions = new HashMap<Integer, Map<String, EventJunction>>();

    public void deleteStreamJunction(String streamId) throws EventStreamConfigurationException {
        Map<String, EventJunction> eventJunctionMap;
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        StreamDefinition streamDefinition = EventStreamServiceValueHolder.getCarbonEventStreamService().getStreamDefinition(DataBridgeCommonsUtils.getStreamNameFromStreamId((String)streamId), DataBridgeCommonsUtils.getStreamVersionFromStreamId((String)streamId));
        if (streamDefinition == null && (eventJunctionMap = this.tenantSpecificEventJunctions.get(tenantId)) != null) {
            eventJunctionMap.remove(streamId);
        }
    }

    private EventJunction getOrConstructEventJunction(String streamId) throws EventStreamConfigurationException {
        EventJunction eventJunction;
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        Map<String, EventJunction> eventJunctionMap = this.tenantSpecificEventJunctions.get(tenantId);
        if (eventJunctionMap == null) {
            eventJunctionMap = new ConcurrentHashMap<String, EventJunction>();
            this.tenantSpecificEventJunctions.put(tenantId, eventJunctionMap);
        }
        if ((eventJunction = eventJunctionMap.get(streamId)) == null) {
            StreamDefinition streamDefinition = null;
            try {
                streamDefinition = EventStreamServiceValueHolder.getCarbonEventStreamService().getStreamDefinition(streamId);
            }
            catch (Exception e) {
                throw new EventStreamConfigurationException("Cannot retrieve Stream " + streamId + " for tenant " + tenantId);
            }
            if (streamDefinition == null) {
                throw new EventStreamConfigurationException("Stream " + streamId + " is not configured to tenant " + tenantId);
            }
            eventJunction = new EventJunction(streamDefinition);
            eventJunctionMap.put(streamDefinition.getStreamId(), eventJunction);
        }
        return eventJunction;
    }

    public void publish(String streamId, Event event) {
        Map<String, EventJunction> eventJunctionMap;
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (tenantId != -1234) {
            String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain(true);
            TenantAxisUtils.getTenantConfigurationContext((String)tenantDomain, (ConfigurationContext)EventStreamServiceValueHolder.getConfigurationContextService().getServerConfigContext());
        }
        if ((eventJunctionMap = this.tenantSpecificEventJunctions.get(tenantId)) != null && eventJunctionMap.containsKey(streamId)) {
            EventJunction eventJunction = eventJunctionMap.get(streamId);
            eventJunction.sendEvent(event);
        } else {
            log.debug((Object)("Event " + event.toString() + " dropped since no junction found for the streamId " + streamId));
        }
    }

    public void subscribe(SiddhiEventConsumer siddhiEventConsumer) throws EventStreamConfigurationException {
        EventJunction eventJunction = this.getOrConstructEventJunction(siddhiEventConsumer.getStreamId());
        eventJunction.addConsumer(siddhiEventConsumer);
    }

    public void subscribe(EventProducer eventProducer) throws EventStreamConfigurationException {
        EventJunction eventJunction = this.getOrConstructEventJunction(eventProducer.getStreamId());
        eventJunction.addProducer(eventProducer);
    }

    public void subscribe(WSO2EventConsumer wso2EventConsumer) throws EventStreamConfigurationException {
        EventJunction eventJunction = this.getOrConstructEventJunction(wso2EventConsumer.getStreamId());
        eventJunction.addConsumer(wso2EventConsumer);
    }

    public void subscribe(WSO2EventListConsumer wso2EventListConsumer) throws EventStreamConfigurationException {
        EventJunction eventJunction = this.getOrConstructEventJunction(wso2EventListConsumer.getStreamId());
        eventJunction.addConsumer(wso2EventListConsumer);
    }

    public void unsubscribe(SiddhiEventConsumer siddhiEventConsumer) {
        EventJunction eventJunction;
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        Map<String, EventJunction> eventJunctionMap = this.tenantSpecificEventJunctions.get(tenantId);
        if (eventJunctionMap != null && (eventJunction = eventJunctionMap.get(siddhiEventConsumer.getStreamId())) != null) {
            eventJunction.removeConsumer(siddhiEventConsumer);
        }
    }

    public void unsubscribe(EventProducer eventProducer) {
        EventJunction eventJunction;
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        Map<String, EventJunction> eventJunctionMap = this.tenantSpecificEventJunctions.get(tenantId);
        if (eventJunctionMap != null && (eventJunction = eventJunctionMap.get(eventProducer.getStreamId())) != null) {
            eventJunction.removeProducer(eventProducer);
        }
    }

    public void unsubscribe(WSO2EventConsumer wso2EventConsumer) {
        EventJunction eventJunction;
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        Map<String, EventJunction> eventJunctionMap = this.tenantSpecificEventJunctions.get(tenantId);
        if (eventJunctionMap != null && (eventJunction = eventJunctionMap.get(wso2EventConsumer.getStreamId())) != null) {
            eventJunction.removeConsumer(wso2EventConsumer);
        }
    }

    public void unsubscribe(WSO2EventListConsumer wso2EventListConsumer) {
        EventJunction eventJunction;
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        Map<String, EventJunction> eventJunctionMap = this.tenantSpecificEventJunctions.get(tenantId);
        if (eventJunctionMap != null && (eventJunction = eventJunctionMap.get(wso2EventListConsumer.getStreamId())) != null) {
            eventJunction.removeConsumer(wso2EventListConsumer);
        }
    }
}

