/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.stream.core.internal;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.event.stream.core.EventProducer;
import org.wso2.carbon.event.stream.core.EventProducerCallback;
import org.wso2.carbon.event.stream.core.SiddhiEventConsumer;
import org.wso2.carbon.event.stream.core.WSO2EventConsumer;
import org.wso2.carbon.event.stream.core.WSO2EventListConsumer;
import org.wso2.carbon.event.stream.core.internal.util.EventConverter;

public class EventJunction
implements EventProducerCallback {
    private static final Log log = LogFactory.getLog(EventJunction.class);
    private StreamDefinition streamDefinition;
    private boolean metaFlag = false;
    private boolean correlationFlag = false;
    private boolean payloadFlag = false;
    private int attributesCount;
    private CopyOnWriteArrayList<EventProducer> producers;
    private CopyOnWriteArrayList<SiddhiEventConsumer> siddhiEventConsumers;
    private CopyOnWriteArrayList<WSO2EventConsumer> wso2EventConsumers;
    private CopyOnWriteArrayList<WSO2EventListConsumer> wso2EventListConsumers;

    public EventJunction(StreamDefinition streamDefinition) {
        this.streamDefinition = streamDefinition;
        this.producers = new CopyOnWriteArrayList();
        this.siddhiEventConsumers = new CopyOnWriteArrayList();
        this.wso2EventConsumers = new CopyOnWriteArrayList();
        this.wso2EventListConsumers = new CopyOnWriteArrayList();
        this.populateEventTemplate(streamDefinition);
    }

    public void addConsumer(SiddhiEventConsumer consumer) {
        if (!this.siddhiEventConsumers.contains(consumer)) {
            log.info((Object)("Consumer added to the junction. Stream:" + this.getStreamDefinition().getStreamId()));
            this.siddhiEventConsumers.add(consumer);
        } else {
            log.error((Object)("Consumer already exist in the junction: " + this.streamDefinition.getStreamId()));
        }
    }

    public boolean removeConsumer(SiddhiEventConsumer consumer) {
        return this.siddhiEventConsumers.remove(consumer);
    }

    public void addConsumer(WSO2EventConsumer consumer) {
        if (!this.wso2EventConsumers.contains(consumer)) {
            log.info((Object)("WSO2EventConsumer added to the junction. Stream:" + this.getStreamDefinition().getStreamId()));
            consumer.onAddDefinition(this.streamDefinition);
            this.wso2EventConsumers.add(consumer);
        } else {
            log.error((Object)("WSO2EventConsumer already exist in the junction: " + this.streamDefinition.getStreamId()));
        }
    }

    public void addConsumer(WSO2EventListConsumer consumer) {
        if (!this.wso2EventListConsumers.contains(consumer)) {
            log.info((Object)("WSO2EventConsumer added to the junction. Stream:" + this.getStreamDefinition().getStreamId()));
            consumer.onAddDefinition(this.streamDefinition);
            this.wso2EventListConsumers.add(consumer);
        } else {
            log.error((Object)("WSO2EventConsumer already exist in the junction: " + this.streamDefinition.getStreamId()));
        }
    }

    public boolean removeConsumer(WSO2EventConsumer consumer) {
        boolean isRemoved = this.wso2EventConsumers.remove(consumer);
        consumer.onRemoveDefinition(this.streamDefinition);
        return isRemoved;
    }

    public boolean removeConsumer(WSO2EventListConsumer consumer) {
        boolean isRemoved = this.wso2EventListConsumers.remove(consumer);
        consumer.onRemoveDefinition(this.streamDefinition);
        return isRemoved;
    }

    public void addProducer(EventProducer listener) {
        if (!this.producers.contains(listener)) {
            log.info((Object)("Producer added to the junction. Stream:" + this.getStreamDefinition().getStreamId()));
            listener.setCallBack(this);
            this.producers.add(listener);
        } else {
            log.error((Object)("Producer already exist in the junction: " + this.streamDefinition.getStreamId()));
        }
    }

    public boolean removeProducer(EventProducer producer) {
        boolean isRemoved = this.producers.remove(producer);
        if (isRemoved) {
            producer.setCallBack(null);
        }
        return isRemoved;
    }

    public StreamDefinition getStreamDefinition() {
        return this.streamDefinition;
    }

    @Override
    public void sendEvent(Event event) {
        if (!this.siddhiEventConsumers.isEmpty()) {
            org.wso2.siddhi.core.event.Event convertedEvent = EventConverter.convertToEvent(event, this.metaFlag, this.correlationFlag, this.payloadFlag, this.attributesCount);
            for (SiddhiEventConsumer consumer : this.siddhiEventConsumers) {
                try {
                    consumer.consumeEvent(convertedEvent);
                }
                catch (Exception e) {
                    log.error((Object)("Error while dispatching events: " + e.getMessage()), (Throwable)e);
                }
            }
        }
        if (!this.wso2EventConsumers.isEmpty()) {
            for (WSO2EventConsumer wSO2EventConsumer : this.wso2EventConsumers) {
                try {
                    wSO2EventConsumer.onEvent(event);
                }
                catch (Exception e) {
                    log.error((Object)("Error while dispatching events: " + e.getMessage()), (Throwable)e);
                }
            }
        }
        if (!this.wso2EventListConsumers.isEmpty()) {
            for (WSO2EventListConsumer wSO2EventListConsumer : this.wso2EventListConsumers) {
                try {
                    wSO2EventListConsumer.onEvent(event);
                }
                catch (Exception e) {
                    log.error((Object)("Error while dispatching events: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    @Override
    public void sendEvents(List<Event> events) {
        for (Event event : events) {
            if (!this.siddhiEventConsumers.isEmpty()) {
                org.wso2.siddhi.core.event.Event convertedEvent = EventConverter.convertToEvent(event, this.metaFlag, this.correlationFlag, this.payloadFlag, this.attributesCount);
                for (SiddhiEventConsumer consumer : this.siddhiEventConsumers) {
                    try {
                        consumer.consumeEvent(convertedEvent);
                    }
                    catch (Exception e) {
                        log.error((Object)("Error while dispatching events: " + e.getMessage()), (Throwable)e);
                    }
                }
            }
            if (this.wso2EventConsumers.isEmpty()) continue;
            for (WSO2EventConsumer consumer : this.wso2EventConsumers) {
                try {
                    consumer.onEvent(event);
                }
                catch (Exception e) {
                    log.error((Object)("Error while dispatching events: " + e.getMessage()), (Throwable)e);
                }
            }
        }
        if (!this.wso2EventListConsumers.isEmpty()) {
            for (WSO2EventListConsumer eventListConsumer : this.wso2EventListConsumers) {
                try {
                    eventListConsumer.onEventList(events);
                }
                catch (Exception e) {
                    log.error((Object)("Error while dispatching events: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    private void populateEventTemplate(StreamDefinition definition) {
        int attributesCount = 0;
        if (definition.getMetaData() != null) {
            attributesCount += definition.getMetaData().size();
            this.metaFlag = true;
        }
        if (definition.getCorrelationData() != null) {
            attributesCount += definition.getCorrelationData().size();
            this.correlationFlag = true;
        }
        if (definition.getPayloadData() != null) {
            attributesCount += definition.getPayloadData().size();
            this.payloadFlag = true;
        }
        this.attributesCount = attributesCount;
    }
}

