/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.stream.core.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.commons.utils.DataBridgeCommonsUtils;
import org.wso2.carbon.event.stream.core.EventProducer;
import org.wso2.carbon.event.stream.core.EventStreamConfiguration;
import org.wso2.carbon.event.stream.core.EventStreamListener;
import org.wso2.carbon.event.stream.core.EventStreamService;
import org.wso2.carbon.event.stream.core.SiddhiEventConsumer;
import org.wso2.carbon.event.stream.core.WSO2EventConsumer;
import org.wso2.carbon.event.stream.core.WSO2EventListConsumer;
import org.wso2.carbon.event.stream.core.exception.EventStreamConfigurationException;
import org.wso2.carbon.event.stream.core.exception.StreamDefinitionAlreadyDefinedException;
import org.wso2.carbon.event.stream.core.internal.ds.EventStreamServiceValueHolder;
import org.wso2.carbon.event.stream.core.internal.util.SampleEventGenerator;
import org.wso2.carbon.event.stream.core.internal.util.helper.EventStreamConfigurationFileSystemInvoker;

public class CarbonEventStreamService
implements EventStreamService {
    private static final Log log = LogFactory.getLog(CarbonEventStreamService.class);
    private final List<StreamDefinition> pendingStreams = new ArrayList<StreamDefinition>();
    private Map<Integer, ConcurrentHashMap<String, EventStreamConfiguration>> tenantSpecificEventStreamConfigs = new ConcurrentHashMap<Integer, ConcurrentHashMap<String, EventStreamConfiguration>>();

    public void removeEventStreamConfigurationFromMap(String fileName) throws EventStreamConfigurationException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        Map eventStreamConfigs = this.tenantSpecificEventStreamConfigs.get(tenantId);
        String streamId = null;
        if (eventStreamConfigs != null) {
            for (EventStreamConfiguration eventStreamConfiguration : eventStreamConfigs.values()) {
                if (!eventStreamConfiguration.getFileName().equals(fileName)) continue;
                streamId = eventStreamConfiguration.getStreamDefinition().getStreamId();
                break;
            }
        }
        if (streamId != null) {
            eventStreamConfigs.remove(streamId);
            for (EventStreamListener eventStreamListener : EventStreamServiceValueHolder.getEventStreamListenerList()) {
                eventStreamListener.removedEventStream(tenantId, DataBridgeCommonsUtils.getStreamNameFromStreamId((String)streamId), DataBridgeCommonsUtils.getStreamVersionFromStreamId((String)streamId));
            }
            EventStreamServiceValueHolder.getEventStreamRuntime().deleteStreamJunction(streamId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPendingStreams() {
        List<StreamDefinition> list = this.pendingStreams;
        synchronized (list) {
            for (StreamDefinition stream : this.pendingStreams) {
                try {
                    this.addEventStreamDefinition(stream);
                }
                catch (EventStreamConfigurationException e) {
                    log.error((Object)("Error occurred when adding stream " + stream.getName()), (Throwable)e);
                }
            }
            this.pendingStreams.clear();
        }
    }

    @Override
    public StreamDefinition getStreamDefinition(String name, String version) throws EventStreamConfigurationException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        Map eventStreamConfigs = this.tenantSpecificEventStreamConfigs.get(tenantId);
        if (eventStreamConfigs != null && eventStreamConfigs.containsKey(name + ":" + version)) {
            return ((EventStreamConfiguration)eventStreamConfigs.get(name + ":" + version)).getStreamDefinition();
        }
        return null;
    }

    @Override
    public StreamDefinition getStreamDefinition(String streamId) throws EventStreamConfigurationException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        Map eventStreamConfigs = this.tenantSpecificEventStreamConfigs.get(tenantId);
        if (eventStreamConfigs != null && eventStreamConfigs.containsKey(streamId)) {
            return ((EventStreamConfiguration)eventStreamConfigs.get(streamId)).getStreamDefinition();
        }
        return null;
    }

    @Override
    public EventStreamConfiguration getEventStreamConfiguration(String streamId) {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        Map eventStreamConfigs = this.tenantSpecificEventStreamConfigs.get(tenantId);
        if (eventStreamConfigs != null && eventStreamConfigs.containsKey(streamId)) {
            return (EventStreamConfiguration)eventStreamConfigs.get(streamId);
        }
        return null;
    }

    @Override
    public List<StreamDefinition> getAllStreamDefinitions() throws EventStreamConfigurationException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        Map eventStreamConfigs = this.tenantSpecificEventStreamConfigs.get(tenantId);
        ArrayList<StreamDefinition> list = new ArrayList<StreamDefinition>();
        if (eventStreamConfigs == null) {
            return list;
        }
        for (EventStreamConfiguration eventStreamConfiguration : eventStreamConfigs.values()) {
            list.add(eventStreamConfiguration.getStreamDefinition());
        }
        return list;
    }

    @Override
    public List<EventStreamConfiguration> getAllEventStreamConfigurations() throws EventStreamConfigurationException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        Map eventStreamConfigs = this.tenantSpecificEventStreamConfigs.get(tenantId);
        if (eventStreamConfigs == null) {
            return new ArrayList<EventStreamConfiguration>();
        }
        return new ArrayList<EventStreamConfiguration>(eventStreamConfigs.values());
    }

    @Override
    public void addEventStreamConfig(EventStreamConfiguration eventStreamConfiguration) throws EventStreamConfigurationException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        ConcurrentHashMap<String, EventStreamConfiguration> eventStreamConfigs = this.tenantSpecificEventStreamConfigs.get(tenantId);
        if (eventStreamConfigs == null) {
            eventStreamConfigs = new ConcurrentHashMap();
            this.tenantSpecificEventStreamConfigs.put(tenantId, eventStreamConfigs);
        }
        eventStreamConfigs.put(eventStreamConfiguration.getStreamDefinition().getStreamId(), eventStreamConfiguration);
        for (EventStreamListener eventStreamListener : EventStreamServiceValueHolder.getEventStreamListenerList()) {
            eventStreamListener.addedEventStream(tenantId, eventStreamConfiguration.getStreamDefinition().getName(), eventStreamConfiguration.getStreamDefinition().getVersion());
        }
    }

    public void validateEventStreamDefinition(StreamDefinition streamDefinition) throws EventStreamConfigurationException {
        int j;
        String checkName;
        int i;
        if (streamDefinition.getMetaData() != null && streamDefinition.getMetaData().size() != 0) {
            for (i = 0; i < streamDefinition.getMetaData().size(); ++i) {
                checkName = ((Attribute)streamDefinition.getMetaData().get(i)).getName();
                for (j = i + 1; j < streamDefinition.getMetaData().size(); ++j) {
                    if (!checkName.equals(((Attribute)streamDefinition.getMetaData().get(j)).getName())) continue;
                    throw new EventStreamConfigurationException("Cannot have same name '" + checkName + "' for multiple meta data attributes, give different names");
                }
            }
        }
        if (streamDefinition.getCorrelationData() != null && streamDefinition.getCorrelationData().size() != 0) {
            for (i = 0; i < streamDefinition.getCorrelationData().size(); ++i) {
                checkName = ((Attribute)streamDefinition.getCorrelationData().get(i)).getName();
                for (j = i + 1; j < streamDefinition.getCorrelationData().size(); ++j) {
                    if (!checkName.equals(((Attribute)streamDefinition.getCorrelationData().get(j)).getName())) continue;
                    throw new EventStreamConfigurationException("Cannot have same name '" + checkName + "' for multiple correlation data attributes, give different names");
                }
            }
        }
        if (streamDefinition.getPayloadData() != null && streamDefinition.getPayloadData().size() != 0) {
            for (i = 0; i < streamDefinition.getPayloadData().size(); ++i) {
                checkName = ((Attribute)streamDefinition.getPayloadData().get(i)).getName();
                for (j = i + 1; j < streamDefinition.getPayloadData().size(); ++j) {
                    if (!checkName.equals(((Attribute)streamDefinition.getPayloadData().get(j)).getName())) continue;
                    throw new EventStreamConfigurationException("Cannot have same name '" + checkName + "' for multiple payload data attributes, give different names");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEventStreamDefinition(StreamDefinition streamDefinition) throws EventStreamConfigurationException {
        if (EventStreamServiceValueHolder.getConfigurationContextService() != null) {
            AxisConfiguration axisConfig = this.getAxisConfiguration();
            String directoryPath = new File(axisConfig.getRepository().getPath()).getAbsolutePath() + File.separator + "eventstreams";
            File directory = new File(directoryPath);
            if (!directory.exists() && !directory.mkdir()) {
                throw new EventStreamConfigurationException("Cannot create directory to add tenant specific Event Stream : " + streamDefinition.getStreamId());
            }
            String filePath = directoryPath + File.separator + streamDefinition.getName() + "_" + streamDefinition.getVersion() + ".json";
            StreamDefinition streamDefinitionOld = this.getStreamDefinition(streamDefinition.getStreamId());
            if (streamDefinitionOld != null) {
                if (!streamDefinitionOld.equals((Object)streamDefinition)) {
                    throw new StreamDefinitionAlreadyDefinedException("Different stream definition with same stream id " + streamDefinition.getStreamId() + " already exist " + streamDefinitionOld.toString() + ", cannot add stream definition " + streamDefinition.toString());
                }
                return;
            }
            this.validateEventStreamDefinition(streamDefinition);
            EventStreamConfigurationFileSystemInvoker.save(streamDefinition, filePath, axisConfig);
        } else {
            List<StreamDefinition> list = this.pendingStreams;
            synchronized (list) {
                if (EventStreamServiceValueHolder.getConfigurationContextService() != null) {
                    this.addEventStreamDefinition(streamDefinition);
                } else {
                    this.pendingStreams.add(streamDefinition);
                }
            }
        }
    }

    private AxisConfiguration getAxisConfiguration() {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        AxisConfiguration axisConfig = tenantId == -1234 ? EventStreamServiceValueHolder.getConfigurationContextService().getServerConfigContext().getAxisConfiguration() : TenantAxisUtils.getTenantAxisConfiguration((String)PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain(), (ConfigurationContext)EventStreamServiceValueHolder.getConfigurationContextService().getServerConfigContext());
        return axisConfig;
    }

    public void removeEventStreamDefinition(String streamId) throws EventStreamConfigurationException {
        String name = null;
        String version = null;
        if (streamId != null && streamId.contains(":")) {
            name = streamId.split(":")[0];
            version = streamId.split(":")[1];
        }
        this.removeEventStreamDefinition(name, version);
    }

    @Override
    public void removeEventStreamDefinition(String streamName, String streamVersion) throws EventStreamConfigurationException {
        AxisConfiguration axisConfig = this.getAxisConfiguration();
        EventStreamConfigurationFileSystemInvoker.delete(streamName + "_" + streamVersion + ".json", axisConfig);
        log.info((Object)("Stream definition - " + streamName + ":" + streamVersion + " removed successfully"));
    }

    @Override
    public List<String> getStreamIds() throws EventStreamConfigurationException {
        List<StreamDefinition> eventStreamConfigs = this.getAllStreamDefinitions();
        ArrayList<String> streamDefinitionsIds = new ArrayList<String>(eventStreamConfigs.size());
        for (StreamDefinition streamDefinition : eventStreamConfigs) {
            streamDefinitionsIds.add(streamDefinition.getStreamId());
        }
        return streamDefinitionsIds;
    }

    @Override
    public String generateSampleEvent(String streamId, String eventType) throws EventStreamConfigurationException {
        StreamDefinition streamDefinition = this.getStreamDefinition(streamId);
        if (eventType.equals("xml")) {
            return SampleEventGenerator.generateXMLEvent(streamDefinition);
        }
        if (eventType.equals("json")) {
            return SampleEventGenerator.generateJSONEvent(streamDefinition);
        }
        if (eventType.equals("text")) {
            return SampleEventGenerator.generateTextEvent(streamDefinition);
        }
        return null;
    }

    @Override
    public void subscribe(SiddhiEventConsumer siddhiEventConsumer) throws EventStreamConfigurationException {
        EventStreamServiceValueHolder.getEventStreamRuntime().subscribe(siddhiEventConsumer);
    }

    @Override
    public void subscribe(EventProducer eventProducer) throws EventStreamConfigurationException {
        EventStreamServiceValueHolder.getEventStreamRuntime().subscribe(eventProducer);
    }

    @Override
    public void subscribe(WSO2EventConsumer wso2EventConsumer) throws EventStreamConfigurationException {
        EventStreamServiceValueHolder.getEventStreamRuntime().subscribe(wso2EventConsumer);
    }

    @Override
    public void subscribe(WSO2EventListConsumer wso2EventListConsumer) throws EventStreamConfigurationException {
        EventStreamServiceValueHolder.getEventStreamRuntime().subscribe(wso2EventListConsumer);
    }

    @Override
    public void unsubscribe(SiddhiEventConsumer siddhiEventConsumer) {
        EventStreamServiceValueHolder.getEventStreamRuntime().unsubscribe(siddhiEventConsumer);
    }

    @Override
    public void unsubscribe(EventProducer eventProducer) {
        EventStreamServiceValueHolder.getEventStreamRuntime().unsubscribe(eventProducer);
    }

    @Override
    public void unsubscribe(WSO2EventConsumer wso2EventConsumer) {
        EventStreamServiceValueHolder.getEventStreamRuntime().unsubscribe(wso2EventConsumer);
    }

    @Override
    public void unsubscribe(WSO2EventListConsumer wso2EventConsumer) {
        EventStreamServiceValueHolder.getEventStreamRuntime().unsubscribe(wso2EventConsumer);
    }

    @Override
    public void publish(Event event) {
        EventStreamServiceValueHolder.getEventStreamRuntime().publish(event.getStreamId(), event);
    }

    public boolean isEventStreamFileExists(String eventStreamFileName) {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        Map eventStreamConfigs = this.tenantSpecificEventStreamConfigs.get(tenantId);
        if (eventStreamConfigs != null) {
            for (EventStreamConfiguration eventStreamConfiguration : eventStreamConfigs.values()) {
                if (!eventStreamConfiguration.getFileName().equals(eventStreamFileName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isMatchForStreamDefinition(StreamDefinition streamDefinition, StreamDefinition existingStreamDefinition) {
        if (streamDefinition == null || existingStreamDefinition == null) {
            throw new IllegalArgumentException("Stream definitions passed in cannot be null!");
        }
        List existingStreamMetaData = existingStreamDefinition.getMetaData();
        List incomingStreamMetaData = streamDefinition.getMetaData();
        if (existingStreamMetaData != null && incomingStreamMetaData != null) {
            if (incomingStreamMetaData.size() != existingStreamMetaData.size()) {
                return false;
            }
            for (int i = 0; i < existingStreamMetaData.size(); ++i) {
                Attribute attribute = (Attribute)existingStreamMetaData.get(i);
                if (incomingStreamMetaData.get(i) != null && ((Attribute)incomingStreamMetaData.get(i)).equals((Object)attribute)) continue;
                return false;
            }
        }
        List existingStreamCorrelationData = existingStreamDefinition.getCorrelationData();
        List incomingStreamCorrelationData = streamDefinition.getCorrelationData();
        if (existingStreamCorrelationData != null && incomingStreamCorrelationData != null) {
            if (incomingStreamCorrelationData.size() != existingStreamCorrelationData.size()) {
                return false;
            }
            for (int i = 0; i < existingStreamCorrelationData.size(); ++i) {
                Attribute attribute = (Attribute)existingStreamCorrelationData.get(i);
                if (incomingStreamCorrelationData.get(i) != null && ((Attribute)incomingStreamCorrelationData.get(i)).equals((Object)attribute)) continue;
                return false;
            }
        }
        List existingStreamPayloadData = existingStreamDefinition.getPayloadData();
        List incomingStreamPayloadData = streamDefinition.getPayloadData();
        if (existingStreamPayloadData != null && incomingStreamPayloadData != null) {
            if (incomingStreamPayloadData.size() != existingStreamPayloadData.size()) {
                return false;
            }
            for (int i = 0; i < existingStreamPayloadData.size(); ++i) {
                Attribute attribute = (Attribute)existingStreamPayloadData.get(i);
                if (incomingStreamPayloadData.get(i) != null && ((Attribute)incomingStreamPayloadData.get(i)).equals((Object)attribute)) continue;
                return false;
            }
        }
        return true;
    }
}

