/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.stream.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.AbstractDeployer;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.databridge.commons.utils.EventDefinitionConverterUtils;
import org.wso2.carbon.event.application.deployer.EventProcessingDeployer;
import org.wso2.carbon.event.stream.core.EventStreamConfiguration;
import org.wso2.carbon.event.stream.core.exception.EventStreamConfigurationException;
import org.wso2.carbon.event.stream.core.internal.CarbonEventStreamService;
import org.wso2.carbon.event.stream.core.internal.ds.EventStreamServiceValueHolder;

public class EventStreamDeployer
extends AbstractDeployer
implements EventProcessingDeployer {
    private static Log log = LogFactory.getLog(EventStreamDeployer.class);
    private ConfigurationContext configurationContext;
    private Set<String> deployedEventStreamFilePaths = Collections.newSetFromMap(new ConcurrentHashMap());
    private Set<String> unDeployedEventStreamFilePaths = Collections.newSetFromMap(new ConcurrentHashMap());

    public void init(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        try {
            String path = deploymentFileData.getAbsolutePath();
            if (!this.deployedEventStreamFilePaths.contains(path)) {
                this.processDeployment(deploymentFileData);
            } else {
                log.debug((Object)("Event stream file is already deployed :" + path));
                this.deployedEventStreamFilePaths.remove(path);
            }
        }
        catch (Throwable t) {
            log.error((Object)("Can't deploy the event stream : " + deploymentFileData.getName()), t);
            throw new DeploymentException("Can't deploy the event stream : " + deploymentFileData.getName(), t);
        }
    }

    public void setDirectory(String s) {
    }

    public void setExtension(String s) {
    }

    public void undeploy(String filePath) throws DeploymentException {
        try {
            if (!this.unDeployedEventStreamFilePaths.contains(filePath)) {
                this.processUndeployment(filePath);
            } else {
                log.debug((Object)("Event stream file is already undeployed :" + filePath));
                this.unDeployedEventStreamFilePaths.remove(filePath);
            }
        }
        catch (Throwable t) {
            log.error((Object)("Can't undeploy the event stream: " + filePath), t);
            throw new DeploymentException("Can't undeploy the event stream: " + filePath, t);
        }
    }

    public synchronized void processDeployment(DeploymentFileData deploymentFileData) throws EventStreamConfigurationException {
        CarbonEventStreamService carbonEventStreamService = EventStreamServiceValueHolder.getCarbonEventStreamService();
        File eventStreamFile = deploymentFileData.getFile();
        boolean isEditable = !eventStreamFile.getAbsolutePath().contains(File.separator + "carbonapps" + File.separator);
        try {
            String content = new Scanner(new File(eventStreamFile.getAbsolutePath())).useDelimiter("\\Z").next();
            StreamDefinition streamDefinition = EventDefinitionConverterUtils.convertFromJson((String)content);
            StreamDefinition existingStreamDefinition = carbonEventStreamService.getStreamDefinition(streamDefinition.getStreamId());
            if (existingStreamDefinition != null) {
                throw new EventStreamConfigurationException("Event stream already exists for stream id: " + streamDefinition.getStreamId());
            }
            if (!carbonEventStreamService.isEventStreamFileExists(eventStreamFile.getName())) {
                EventStreamConfiguration eventStreamConfiguration = new EventStreamConfiguration();
                eventStreamConfiguration.setStreamDefinition(streamDefinition);
                eventStreamConfiguration.setEditable(isEditable);
                eventStreamConfiguration.setFileName(eventStreamFile.getName());
                carbonEventStreamService.addEventStreamConfig(eventStreamConfiguration);
                log.info((Object)("Stream definition is deployed successfully  : " + streamDefinition.getStreamId()));
            } else {
                log.info((Object)("Event stream definition for the same configuration file " + eventStreamFile.getName() + " already exists"));
            }
        }
        catch (MalformedStreamDefinitionException e) {
            throw new EventStreamConfigurationException("Error in constructing Stream Definition Object from JSON " + e.getMessage(), e);
        }
        catch (FileNotFoundException e) {
            throw new EventStreamConfigurationException("Stream Definition file not found " + eventStreamFile.getAbsolutePath() + "," + e.getMessage(), e);
        }
    }

    public synchronized void processUndeployment(String filePath) throws EventStreamConfigurationException {
        String fileName = new File(filePath).getName();
        log.info((Object)("Stream Definition was undeployed successfully : " + fileName));
        CarbonEventStreamService carbonEventStreamService = EventStreamServiceValueHolder.getCarbonEventStreamService();
        carbonEventStreamService.removeEventStreamConfigurationFromMap(fileName);
    }

    public Set<String> getDeployedEventStreamFilePaths() {
        return this.deployedEventStreamFilePaths;
    }

    public Set<String> getUnDeployedEventStreamFilePaths() {
        return this.unDeployedEventStreamFilePaths;
    }

    public void executeManualDeployment(String filePath) throws EventStreamConfigurationException {
        this.processDeployment(new DeploymentFileData(new File(filePath)));
    }

    public void executeManualUndeployment(String filePath) throws EventStreamConfigurationException {
        this.processUndeployment(new File(filePath).getName());
    }
}

