/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.jndi.internal.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Optional;
import java.util.stream.Stream;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.jndi.internal.util.LambdaExceptionUtils;

public class JNDIUtils {
    private static final Logger logger = LoggerFactory.getLogger(JNDIUtils.class);

    public static Optional<InitialContextFactory> getContextFactory(Optional<InitialContextFactoryBuilder> builderOptional, Hashtable<?, ?> environment) {
        return builderOptional.map(builder -> {
            try {
                return builder.createInitialContextFactory(environment);
            }
            catch (NamingException ignored) {
                logger.debug(ignored.getMessage(), (Throwable)ignored);
                return null;
            }
        });
    }

    public static Optional<Context> getInitialContextFromBuilder(BundleContext bundleContext, Collection<ServiceReference<InitialContextFactoryBuilder>> serviceRefCollection, Hashtable<?, ?> environment) throws NamingException {
        return serviceRefCollection.stream().map(serviceReference -> JNDIUtils.getService(bundleContext, serviceReference)).map(builderOptional -> JNDIUtils.getContextFactory(builderOptional, environment)).flatMap(factoryOptional -> factoryOptional.map(Stream::of).orElseGet(Stream::empty)).map(LambdaExceptionUtils.rethrowFunction(factory -> factory.getInitialContext(environment))).findFirst();
    }

    public static Optional<Context> getInitialContextFromFactory(BundleContext bundleContext, Collection<ServiceReference<InitialContextFactory>> serviceRefCollection, Hashtable<?, ?> environment) throws NamingException {
        return serviceRefCollection.stream().map(serviceReference -> JNDIUtils.getService(bundleContext, serviceReference)).flatMap(factoryOptional -> factoryOptional.map(Stream::of).orElseGet(Stream::empty)).map(LambdaExceptionUtils.rethrowFunction(contextFactory -> contextFactory.getInitialContext(environment))).filter(context -> context != null).findFirst();
    }

    public static <S> Collection<ServiceReference<S>> getServiceReferences(BundleContext bundleContext, Class<S> clazz, String filter) {
        try {
            return bundleContext.getServiceReferences(clazz, filter);
        }
        catch (InvalidSyntaxException ignored) {
            logger.error("Filter syntax is invalid: " + filter, (Throwable)ignored);
            return Collections.emptyList();
        }
    }

    public static <S> Optional<S> getService(BundleContext bundleContext, ServiceReference<S> serviceReference) {
        return Optional.ofNullable(bundleContext.getService(serviceReference));
    }
}

