/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.jndi.internal.osgi;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.spi.ObjectFactory;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.jndi.internal.util.JNDIUtils;
import org.wso2.carbon.jndi.internal.util.LambdaExceptionUtils;

public class WrapperContext
implements Context {
    private static final Logger logger = LoggerFactory.getLogger(WrapperContext.class);
    private BundleContext bundleContext;
    private Optional<Context> backingContext;
    private Map<String, Context> backingURLContextMap = new HashMap<String, Context>();
    protected final Hashtable<?, ?> env;
    public static final String PREFIX = "java:";

    public WrapperContext(BundleContext bundleContext, Optional<Context> deletedContext, Hashtable<?, ?> env) {
        this.bundleContext = bundleContext;
        this.backingContext = deletedContext;
        this.env = (Hashtable)env.clone();
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        if (logger.isDebugEnabled()) {
            logger.debug("Call to method 'lookup' with a Name of '" + name + "'");
        }
        return this.getBackingContext(name).lookup(this.parseName(name));
    }

    @Override
    public Object lookup(String name) throws NamingException {
        if (logger.isDebugEnabled()) {
            logger.debug("Call to method 'lookup' with a String of '" + name + "'");
        }
        return this.getBackingContext(name).lookup(this.parseName(name));
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.getBackingContext(name).bind(this.parseName(name), obj);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.getBackingContext(name).bind(this.parseName(name), obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.getBackingContext(name).rebind(this.parseName(name), obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.getBackingContext(name).rebind(this.parseName(name), obj);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.getBackingContext(name).unbind(this.parseName(name));
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.getBackingContext(name).unbind(this.parseName(name));
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        this.getBackingContext(oldName).rename(this.parseName(oldName), this.parseName(newName));
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.getBackingContext(oldName).rename(this.parseName(oldName), this.parseName(newName));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        if (logger.isDebugEnabled()) {
            logger.debug("Call to method 'list' with a Name of '" + name + "'");
        }
        return this.getBackingContext(name).list(this.parseName(name));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        if (logger.isDebugEnabled()) {
            logger.debug("Call to method 'list' with a String of '" + name + "'");
        }
        return this.getBackingContext(name).list(this.parseName(name));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        if (logger.isDebugEnabled()) {
            logger.debug("Call to method 'listBindings' with a Name of '" + name + "'");
        }
        return this.getBackingContext(name).listBindings(this.parseName(name));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        if (logger.isDebugEnabled()) {
            logger.debug("Call to method 'listBindings' with a String of '" + name + "'");
        }
        return this.getBackingContext(name).listBindings(this.parseName(name));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.getBackingContext(name).destroySubcontext(this.parseName(name));
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.getBackingContext(name).destroySubcontext(this.parseName(name));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.getBackingContext(name).createSubcontext(this.parseName(name));
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.getBackingContext(name).createSubcontext(this.parseName(name));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        if (logger.isDebugEnabled()) {
            logger.debug("Call to method 'lookupLink' with a Name of '" + name + "'");
        }
        return this.getBackingContext(name).lookupLink(this.parseName(name));
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        if (logger.isDebugEnabled()) {
            logger.debug("Call to method 'lookupLink' with a String of '" + name + "'");
        }
        return this.getBackingContext(name).lookupLink(this.parseName(name));
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.getBackingContext(name).getNameParser(this.parseName(name));
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.getBackingContext(name).getNameParser(this.parseName(name));
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        Name prefixClone = (Name)prefix.clone();
        return prefixClone.addAll(name);
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return prefix + "/" + name;
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.getDefaultBackingContext().addToEnvironment(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.getDefaultBackingContext().removeFromEnvironment(propName);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return this.getDefaultBackingContext().getEnvironment();
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return PREFIX;
    }

    protected String parseName(String name) throws NamingException {
        return name;
    }

    protected Name parseName(Name name) throws NamingException {
        return name;
    }

    protected Context getBackingContext(String name) throws NamingException {
        return name.contains(":") ? this.getBackingURLContext(name) : this.getDefaultBackingContext();
    }

    protected Context getBackingContext(Name name) throws NamingException {
        return this.getBackingContext(name.toString());
    }

    private Context getBackingURLContext(String name) throws NamingException {
        String scheme = name.substring(0, name.indexOf(":")).trim();
        Context urlContext = this.backingURLContextMap.get(scheme);
        if (urlContext != null) {
            return urlContext;
        }
        urlContext = JNDIUtils.getServiceReferences(this.bundleContext, ObjectFactory.class, "(osgi.jndi.url.scheme=" + scheme + ")").stream().map(serviceRef -> JNDIUtils.getService(this.bundleContext, serviceRef)).flatMap(objectFactoryOptional -> objectFactoryOptional.map(Stream::of).orElseGet(Stream::empty)).map(LambdaExceptionUtils.rethrowFunction(objectFactory -> objectFactory.getObjectInstance(null, null, null, this.env))).filter(object -> object instanceof Context).map(object -> (Context)object).findFirst().orElseGet(LambdaExceptionUtils.rethrowSupplier(this::getDefaultBackingContext));
        this.backingURLContextMap.put(scheme, urlContext);
        return urlContext;
    }

    private Context getDefaultBackingContext() throws NamingException {
        this.backingContext.orElseThrow(NoInitialContextException::new);
        return this.backingContext.get();
    }
}

