/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.jndi.internal.osgi;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.jndi.internal.osgi.OSGiServiceBindingsEnumeration;
import org.wso2.carbon.jndi.internal.osgi.OSGiServiceNamingEnumeration;
import org.wso2.carbon.jndi.internal.osgi.OSGiURL;
import org.wso2.carbon.jndi.internal.util.NameParserImpl;
import org.wso2.carbon.jndi.internal.util.StringManager;

public class OSGiURLContext
implements Context {
    private static final Logger logger = LoggerFactory.getLogger(OSGiURLContext.class);
    protected Hashtable<String, Object> env;
    protected static final StringManager SM = StringManager.getManager("org.wso2.carbon.jndi.internal");
    protected BundleContext callerContext;
    protected static final String SERVICE_PATH = "service";
    protected static final String FRAMEWORK_PATH = "framework";
    protected static final String BUNDLE_CONTEXT = "bundleContext";
    protected NameParser parser;

    public OSGiURLContext(BundleContext callerContext, Hashtable<String, Object> environment) throws NamingException {
        this.callerContext = callerContext;
        this.parser = new NameParserImpl();
        this.env = new Hashtable();
        if (environment != null) {
            Enumeration<String> envEntries = environment.keys();
            while (envEntries.hasMoreElements()) {
                String entryName = envEntries.nextElement();
                this.addToEnvironment(entryName, environment.get(entryName));
            }
        }
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        OSGiURL osgiURL = new OSGiURL(name);
        String protocol = osgiURL.getFirstComponent();
        String serviceName = osgiURL.getServiceName();
        if (FRAMEWORK_PATH.equals(this.getSubContext(protocol)) && BUNDLE_CONTEXT.equals(serviceName)) {
            return this.callerContext;
        }
        Object lookupResult = SERVICE_PATH.equals(this.getSubContext(protocol)) ? this.findService(this.callerContext, osgiURL) : null;
        if (lookupResult == null) {
            throw new NameNotFoundException(name.toString());
        }
        return lookupResult;
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.lookup(this.parser.parse(name));
    }

    protected Object findService(BundleContext ctx, OSGiURL lookupName) throws NamingException {
        Object result;
        String serviceName = lookupName.getServiceName();
        String filter = lookupName.getFilter();
        try {
            result = this.getService(ctx, serviceName, filter);
            if (logger.isDebugEnabled()) {
                logger.debug("Successfully completed service registry lookup for name : " + lookupName);
            }
        }
        catch (NameNotFoundException e) {
            String jndiServiceName = lookupName.getJNDIServiceName();
            filter = "(osgi.jndi.service.name=" + jndiServiceName + ")";
            if (logger.isDebugEnabled()) {
                logger.debug("No service found for name : " + lookupName + ". Retrying service registry lookup with jndi-service-name : " + jndiServiceName);
            }
            result = this.getService(ctx, null, filter);
        }
        return result;
    }

    private Object getService(BundleContext bundleContext, String serviceName, String filter) throws NamingException {
        try {
            ServiceReference[] serviceReferences = bundleContext.getServiceReferences(serviceName, filter);
            if (serviceReferences != null) {
                for (ServiceReference reference : serviceReferences) {
                    Object serviceObject = bundleContext.getService(reference);
                    if (serviceObject == null) continue;
                    return serviceObject;
                }
                throw new NameNotFoundException(SM.getString("osgiUrlContext.noService"));
            }
            throw new NameNotFoundException(SM.getString("osgiUrlContext.noServiceReference", serviceName));
        }
        catch (InvalidSyntaxException e) {
            throw new NameNotFoundException(SM.getString("osgiUrlContext.noServiceForFilter", filter));
        }
    }

    protected String getSubContext(String scheme) {
        int index = scheme.indexOf(":");
        String result = index > 0 ? scheme.substring(index + 1) : null;
        return result;
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        throw new OperationNotSupportedException(SM.getString("osgiUrlContext.operationNotSupported"));
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        throw new OperationNotSupportedException(SM.getString("osgiUrlContext.operationNotSupported"));
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        throw new OperationNotSupportedException(SM.getString("osgiUrlContext.operationNotSupported"));
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        throw new OperationNotSupportedException(SM.getString("osgiUrlContext.operationNotSupported"));
    }

    @Override
    public void unbind(Name name) throws NamingException {
        throw new OperationNotSupportedException(SM.getString("osgiUrlContext.operationNotSupported"));
    }

    @Override
    public void unbind(String name) throws NamingException {
        throw new OperationNotSupportedException(SM.getString("osgiUrlContext.operationNotSupported"));
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        throw new OperationNotSupportedException(SM.getString("osgiUrlContext.operationNotSupported"));
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        throw new OperationNotSupportedException(SM.getString("osgiUrlContext.operationNotSupported"));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException(SM.getString("osgiUrlContext.operationNotSupported"));
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException(SM.getString("osgiUrlContext.operationNotSupported"));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException(SM.getString("osgiUrlContext.operationNotSupported"));
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException(SM.getString("osgiUrlContext.operationNotSupported"));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        throw new OperationNotSupportedException(SM.getString("osgiUrlContext.operationNotSupported"));
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        throw new OperationNotSupportedException(SM.getString("osgiUrlContext.operationNotSupported"));
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.parser;
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.parser;
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.env.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.env.remove(propName);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        Hashtable<String, Object> environment = new Hashtable<String, Object>();
        environment.putAll(this.env);
        return environment;
    }

    @Override
    public void close() throws NamingException {
        this.env.clear();
        this.parser = null;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException(SM.getString("osgiUrlContext.operationNotSupported"));
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        return this.parser.parse(prefix + "/" + name);
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return prefix + "/" + name;
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        OSGiURL osgiURL = new OSGiURL(name);
        List<ServiceReference> serviceReferences = this.getServiceReferences(osgiURL);
        return new OSGiServiceNamingEnumeration(this.callerContext, serviceReferences);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        OSGiURL osgiURL = new OSGiURL(name);
        List<ServiceReference> serviceReferences = this.getServiceReferences(osgiURL);
        return new OSGiServiceBindingsEnumeration(this.callerContext, serviceReferences);
    }

    private List<ServiceReference> getServiceReferences(OSGiURL osgiURL) throws NamingException {
        ServiceReference[] refs;
        String serviceName = osgiURL.getServiceName();
        String filter = osgiURL.getFilter();
        try {
            refs = this.callerContext.getServiceReferences(serviceName, filter);
            if (refs == null) {
                refs = this.getServiceReferencesForJNDIServiceName(osgiURL);
            }
        }
        catch (InvalidSyntaxException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("No service found for service : " + serviceName + ". Retrying service registry lookup with jndi-service-name.");
            }
            refs = this.getServiceReferencesForJNDIServiceName(osgiURL);
        }
        return Arrays.asList(refs);
    }

    private ServiceReference[] getServiceReferencesForJNDIServiceName(OSGiURL osgiURL) throws NamingException {
        ServiceReference[] refs;
        String jndiServiceName = osgiURL.getJNDIServiceName();
        try {
            refs = this.callerContext.getServiceReferences((String)null, "(osgi.jndi.service.name=" + jndiServiceName + ")");
            if (refs == null) {
                throw new NameNotFoundException(SM.getString("osgiUrlContext.noRegisteredService", osgiURL.toString()));
            }
        }
        catch (InvalidSyntaxException e) {
            throw new NamingException(SM.getString("osgiUrlContext.noServiceForFilter", e.getFilter()));
        }
        return refs;
    }
}

