/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.jndi.internal.osgi;

import java.util.Enumeration;
import java.util.Optional;
import java.util.function.Predicate;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.OperationNotSupportedException;
import org.wso2.carbon.jndi.internal.util.StringManager;

public class OSGiURL
extends CompositeName {
    private static final long serialVersionUID = 7079733784681646165L;
    protected static final StringManager SM = StringManager.getManager("org.wso2.carbon.jndi.internal");

    public OSGiURL(String url) throws InvalidNameException, OperationNotSupportedException {
        super(url);
        if (!this.isValid()) {
            throw new InvalidNameException(SM.getString("osgiUrl.invalidURL", url));
        }
    }

    public OSGiURL(Name name) throws InvalidNameException, OperationNotSupportedException {
        this(name.toString());
    }

    public boolean containsQuery() {
        return this.size() > 1;
    }

    public boolean containsFilter() {
        return this.size() == 3;
    }

    public String getJNDIServiceName() {
        String serviceName = this.toString();
        return serviceName.substring(this.getFirstComponent().length() + 1);
    }

    public String getServiceName() {
        int secondComponentIndex = 1;
        return this.containsQuery() ? this.get(secondComponentIndex) : null;
    }

    public String getFilter() {
        int thirdComponentIndex = 2;
        return this.containsFilter() ? this.get(thirdComponentIndex) : null;
    }

    public String getFirstComponent() {
        int firstComponentIndex = 0;
        return this.get(firstComponentIndex);
    }

    private boolean isValid() throws OperationNotSupportedException {
        boolean isValid = false;
        Enumeration<String> nameComponents = this.getAll();
        if (nameComponents.hasMoreElements()) {
            Predicate<String> osgiServiceFilter = servicePathSubContext -> "osgi:service".equals(servicePathSubContext) && this.size() > 1;
            Predicate<String> osgiFrameworkFilter = frameworkPathSubContext -> "osgi:framework".equals(frameworkPathSubContext) && nameComponents.hasMoreElements() && "bundleContext".equals(nameComponents.nextElement());
            Predicate<String> orFilter = osgiFrameworkFilter.or(osgiServiceFilter);
            Optional<String> subContextOptional = Optional.ofNullable(nameComponents.nextElement());
            isValid = subContextOptional.filter(orFilter).isPresent();
            if (!isValid && subContextOptional.filter("osgi:servicelist"::equals).isPresent()) {
                throw new OperationNotSupportedException(SM.getString("osgiUrl.unsupportedURL", this.toString()));
            }
        }
        return isValid;
    }
}

