/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.jndi.internal.osgi;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class OSGiServiceBindingsEnumeration
implements NamingEnumeration<Binding> {
    private BundleContext bundleContext;
    private int currentIndex = 0;
    private List<Binding> bindings;
    private List<ServiceReference> references;

    public OSGiServiceBindingsEnumeration(BundleContext bundleContext, List<ServiceReference> refs) {
        this.bundleContext = bundleContext;
        this.bindings = this.buildBindings(refs);
        this.references = refs;
    }

    private List<Binding> buildBindings(List<ServiceReference> serviceReferencesList) {
        Predicate<ServiceReference> filterNotNullReferences = reference -> this.bundleContext.getService(reference) != null;
        return serviceReferencesList.stream().filter(filterNotNullReferences).map(this::buildBindings).collect(Collectors.toList());
    }

    private Binding buildBindings(ServiceReference serviceReference) {
        return new Binding(String.valueOf(serviceReference.getProperty("service.id")), this.bundleContext.getService(serviceReference).getClass().getName(), this.bundleContext.getService(serviceReference));
    }

    @Override
    public Binding next() throws NamingException {
        return this.nextElement();
    }

    @Override
    public boolean hasMore() throws NamingException {
        return this.hasMoreElements();
    }

    @Override
    public void close() throws NamingException {
        this.references.forEach(arg_0 -> ((BundleContext)this.bundleContext).ungetService(arg_0));
    }

    @Override
    public boolean hasMoreElements() {
        return this.currentIndex < this.bindings.size();
    }

    @Override
    public Binding nextElement() {
        return this.bindings.get(this.currentIndex++);
    }
}

