/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.jndi.internal.impl;

import java.util.List;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.wso2.carbon.jndi.internal.impl.NamingEntry;

public class NamingContextBindingsEnumeration
implements NamingEnumeration<Binding> {
    private int currentIndex = 0;
    private List<NamingEntry> namingEntries;
    private final Context context;

    public NamingContextBindingsEnumeration(List<NamingEntry> entries, Context context) {
        this.namingEntries = entries;
        this.context = context;
    }

    @Override
    public Binding next() throws NamingException {
        return this.nextElementInternal();
    }

    @Override
    public boolean hasMore() throws NamingException {
        return this.hasMoreElements();
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public boolean hasMoreElements() {
        return this.currentIndex < this.namingEntries.size();
    }

    @Override
    public Binding nextElement() {
        try {
            return this.nextElementInternal();
        }
        catch (NamingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private Binding nextElementInternal() throws NamingException {
        Object value;
        NamingEntry entry = this.namingEntries.get(this.currentIndex++);
        if (entry.type == 2 || entry.type == 1) {
            try {
                value = this.context.lookup(new CompositeName(entry.name));
            }
            catch (NamingException e) {
                throw e;
            }
            catch (Exception e) {
                NamingException namingException = new NamingException(e.getMessage());
                namingException.initCause(e);
                throw namingException;
            }
        } else {
            value = entry.value;
        }
        return new Binding(entry.name, value.getClass().getName(), value, true);
    }
}

