/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.jndi.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ObjectFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.service.jndi.JNDIContextManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.jndi.internal.InMemoryInitialContextFactory;
import org.wso2.carbon.jndi.internal.java.JavaURLContextFactory;
import org.wso2.carbon.jndi.internal.osgi.JNDIContextManagerServiceFactory;
import org.wso2.carbon.jndi.internal.osgi.OSGiURLContextServiceFactory;
import org.wso2.carbon.jndi.internal.osgi.builder.DefaultContextFactoryBuilder;
import org.wso2.carbon.jndi.internal.osgi.builder.DefaultObjectFactoryBuilder;

public class JNDIActivator
implements BundleActivator {
    private static final Logger logger = LoggerFactory.getLogger(JNDIActivator.class);

    public void start(BundleContext bundleContext) throws Exception {
        try {
            NamingManager.setInitialContextFactoryBuilder(new DefaultContextFactoryBuilder());
            NamingManager.setObjectFactoryBuilder(new DefaultObjectFactoryBuilder());
            Hashtable<String, String> propertyMap = new Hashtable<String, String>();
            ((Dictionary)propertyMap).put("osgi.jndi.url.scheme", "java");
            bundleContext.registerService(ObjectFactory.class, (Object)new JavaURLContextFactory(), propertyMap);
            Hashtable<String, String> osgiPropertyMap = new Hashtable<String, String>();
            ((Dictionary)osgiPropertyMap).put("osgi.jndi.url.scheme", "osgi");
            bundleContext.registerService(ObjectFactory.class.getName(), (Object)new OSGiURLContextServiceFactory(), osgiPropertyMap);
            bundleContext.registerService(InitialContextFactory.class, (Object)new InMemoryInitialContextFactory(), null);
            logger.debug("Registering JNDIContextManager OSGi service.");
            bundleContext.registerService(JNDIContextManager.class, (ServiceFactory)new JNDIContextManagerServiceFactory(), null);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
    }
}

