/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.input.adapter.filetail.internal.listener;

import org.apache.commons.io.input.Tailer;
import org.apache.commons.io.input.TailerListenerAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterListener;

public class FileTailerListener
extends TailerListenerAdapter {
    private String fileName;
    boolean isFileFound = true;
    private InputEventAdapterListener inputEventAdapterListener;
    private static final Log log = LogFactory.getLog(FileTailerListener.class);
    private int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();

    public FileTailerListener(String fileName, InputEventAdapterListener inputEventAdapterListener) {
        this.fileName = fileName;
        this.inputEventAdapterListener = inputEventAdapterListener;
    }

    public void init(Tailer tailer) {
        super.init(tailer);
    }

    public void handle(String line) {
        super.handle(line);
        if (line == null || line.isEmpty()) {
            return;
        }
        this.isFileFound = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Event received in File Event Adapter - " + line));
        }
        PrivilegedCarbonContext.startTenantFlow();
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(this.tenantId);
        this.inputEventAdapterListener.onEvent((Object)(line + "\n"));
        PrivilegedCarbonContext.endTenantFlow();
    }

    public void fileNotFound() {
        if (this.isFileFound) {
            this.isFileFound = false;
            log.warn((Object)(" fileName: " + this.fileName + " not found, will retry continuously."));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("File  " + this.fileName + " not found"));
        }
        super.fileNotFound();
    }

    public void handle(Exception ex) {
        log.error((Object)"Exception occurred : ", (Throwable)ex);
        super.handle(ex);
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }
}

