/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.input.adapter.filetail;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapter;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterConfiguration;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterFactory;
import org.wso2.carbon.event.input.adapter.core.Property;
import org.wso2.carbon.event.input.adapter.filetail.FileTailEventAdapter;

public class FileTailEventAdapterFactory
extends InputEventAdapterFactory {
    private ResourceBundle resourceBundle = ResourceBundle.getBundle("org.wso2.carbon.event.input.adapter.filetail.i18n.Resources", Locale.getDefault());

    public String getType() {
        return "file-tail";
    }

    public List<String> getSupportedMessageFormats() {
        ArrayList<String> supportInputMessageTypes = new ArrayList<String>();
        supportInputMessageTypes.add("text");
        return supportInputMessageTypes;
    }

    public List<Property> getPropertyList() {
        ArrayList<Property> propertyList = new ArrayList<Property>();
        Property filePath = new Property("filepath");
        filePath.setDisplayName(this.resourceBundle.getString("filepath"));
        filePath.setRequired(true);
        filePath.setHint(this.resourceBundle.getString("filepathHint"));
        propertyList.add(filePath);
        Property delayInMillis = new Property("delayInMillis");
        delayInMillis.setDisplayName(this.resourceBundle.getString("delayInMillis"));
        delayInMillis.setHint(this.resourceBundle.getString("delayInMillis.hint"));
        propertyList.add(delayInMillis);
        Property startFromEndProperty = new Property("startFromEnd");
        startFromEndProperty.setRequired(true);
        startFromEndProperty.setDisplayName(this.resourceBundle.getString("startFromEnd"));
        startFromEndProperty.setOptions(new String[]{"true", "false"});
        startFromEndProperty.setDefaultValue("true");
        startFromEndProperty.setHint(this.resourceBundle.getString("startFromEnd.hint"));
        propertyList.add(startFromEndProperty);
        return propertyList;
    }

    public String getUsageTips() {
        return this.resourceBundle.getString("file.usage.tips");
    }

    public InputEventAdapter createEventAdapter(InputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        return new FileTailEventAdapter(eventAdapterConfiguration, globalProperties);
    }
}

