/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.input.adapter.filetail;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.io.input.Tailer;
import org.apache.commons.io.input.TailerListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapter;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterConfiguration;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterListener;
import org.wso2.carbon.event.input.adapter.core.exception.InputEventAdapterException;
import org.wso2.carbon.event.input.adapter.core.exception.TestConnectionNotSupportedException;
import org.wso2.carbon.event.input.adapter.filetail.internal.listener.FileTailerListener;
import org.wso2.carbon.event.input.adapter.filetail.internal.util.FileTailerManager;

public class FileTailEventAdapter
implements InputEventAdapter {
    private final InputEventAdapterConfiguration eventAdapterConfiguration;
    private final Map<String, String> globalProperties;
    private InputEventAdapterListener eventAdapterListener;
    private final String id = UUID.randomUUID().toString();
    private static final Log log = LogFactory.getLog(FileTailEventAdapter.class);
    private FileTailerManager fileTailerManager;
    private ExecutorService singleThreadedExecutor;

    public FileTailEventAdapter(InputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        this.eventAdapterConfiguration = eventAdapterConfiguration;
        this.globalProperties = globalProperties;
        this.singleThreadedExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("Thread pool- component - FileTailEventAdapter.singleThreadedExecutor;adapterName - " + this.eventAdapterConfiguration.getName()).build());
    }

    public void init(InputEventAdapterListener eventAdapterListener) throws InputEventAdapterException {
        this.validateInputEventAdapterConfigurations();
        this.eventAdapterListener = eventAdapterListener;
    }

    public void testConnect() throws TestConnectionNotSupportedException {
        throw new TestConnectionNotSupportedException("not-supported");
    }

    public void connect() {
        this.createFileAdapterListener();
    }

    public void disconnect() {
        if (this.fileTailerManager != null) {
            this.fileTailerManager.getTailer().stop();
        }
    }

    public void destroy() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileTailEventAdapter)) {
            return false;
        }
        FileTailEventAdapter that = (FileTailEventAdapter)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    private void createFileAdapterListener() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("New subscriber added for " + this.eventAdapterConfiguration.getName()));
        }
        String delayInMillisProperty = (String)this.eventAdapterConfiguration.getProperties().get("delayInMillis");
        int delayInMillis = 1000;
        if (delayInMillisProperty != null && !delayInMillisProperty.trim().isEmpty()) {
            delayInMillis = Integer.parseInt(delayInMillisProperty);
        }
        boolean startFromEnd = false;
        String startFromEndProperty = (String)this.eventAdapterConfiguration.getProperties().get("startFromEnd");
        if (startFromEndProperty != null && !startFromEndProperty.trim().isEmpty()) {
            startFromEnd = Boolean.parseBoolean(startFromEndProperty);
        }
        String filePath = (String)this.eventAdapterConfiguration.getProperties().get("filepath");
        FileTailerListener listener = new FileTailerListener(new File(filePath).getName(), this.eventAdapterListener);
        Tailer tailer = new Tailer(new File(filePath), (TailerListener)listener, (long)delayInMillis, startFromEnd);
        this.fileTailerManager = new FileTailerManager(tailer, listener);
        this.singleThreadedExecutor.execute((Runnable)tailer);
    }

    public boolean isEventDuplicatedInCluster() {
        return Boolean.parseBoolean(this.globalProperties.get("events.duplicated.in.cluster"));
    }

    public boolean isPolling() {
        return true;
    }

    private void validateInputEventAdapterConfigurations() throws InputEventAdapterException {
        String delayInMillisProperty = (String)this.eventAdapterConfiguration.getProperties().get("delayInMillis");
        try {
            if (delayInMillisProperty != null) {
                Integer.parseInt(delayInMillisProperty);
            }
        }
        catch (NumberFormatException e) {
            throw new InputEventAdapterException("Invalid value set for property Delay: " + delayInMillisProperty, (Throwable)e);
        }
    }
}

