/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.event.admin;

import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.andes.event.admin.Subscription;
import org.wso2.carbon.andes.event.admin.exception.EventAdminException;
import org.wso2.carbon.andes.event.admin.internal.EventAdminHolder;
import org.wso2.carbon.andes.event.core.EventBroker;
import org.wso2.carbon.andes.event.core.Message;
import org.wso2.carbon.andes.event.core.TopicManagerService;
import org.wso2.carbon.andes.event.core.TopicNode;
import org.wso2.carbon.andes.event.core.TopicRolePermission;
import org.wso2.carbon.andes.event.core.exception.EventBrokerException;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.AbstractAdmin;

public class AndesEventAdminService
extends AbstractAdmin {
    private static Log log = LogFactory.getLog(AndesEventAdminService.class);

    public TopicNode getAllTopics() throws EventAdminException {
        EventBroker eventBroker = EventAdminHolder.getInstance().getEventBroker();
        try {
            return eventBroker.getTopicManagerService().getTopicTree();
        }
        catch (EventBrokerException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new EventAdminException(errorMessage, e);
        }
    }

    public TopicNode getPaginatedTopicTree(String topicPath, int startIndex, int numberOfTopicsPerRound) throws EventAdminException {
        EventBroker eventBroker = EventAdminHolder.getInstance().getEventBroker();
        try {
            return eventBroker.getTopicManagerService().getPaginatedTopicTree(topicPath, startIndex, numberOfTopicsPerRound);
        }
        catch (EventBrokerException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new EventAdminException(errorMessage, e);
        }
    }

    public TopicRolePermission[] getTopicRolePermissions(String topic) throws EventAdminException {
        topic = this.setNameToLowerCase(topic);
        EventBroker eventBroker = EventAdminHolder.getInstance().getEventBroker();
        try {
            return eventBroker.getTopicManagerService().getTopicRolePermission(topic);
        }
        catch (EventBrokerException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new EventAdminException(errorMessage, e);
        }
    }

    public void addTopic(String topic) throws EventAdminException {
        topic = this.setNameToLowerCase(topic);
        EventBroker eventBroker = EventAdminHolder.getInstance().getEventBroker();
        try {
            if (eventBroker.getTopicManagerService().isTopicExists(topic)) {
                throw new EventAdminException("Topic with name : " + topic + " already exists!");
            }
            eventBroker.getTopicManagerService().addTopic(topic);
        }
        catch (EventBrokerException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new EventAdminException(errorMessage, e);
        }
    }

    public void updatePermission(String topic, TopicRolePermission[] topicRolePermissions) throws EventAdminException {
        topic = this.setNameToLowerCase(topic);
        EventBroker eventBroker = EventAdminHolder.getInstance().getEventBroker();
        try {
            eventBroker.getTopicManagerService().updatePermissions(topic, topicRolePermissions);
        }
        catch (EventBrokerException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new EventAdminException(errorMessage, e);
        }
    }

    public Subscription[] getAllWSSubscriptionsForTopic(String topic, int startingIndex, int maxSubscriptionCount) throws EventAdminException {
        topic = this.setNameToLowerCase(topic);
        EventBroker eventBroker = EventAdminHolder.getInstance().getEventBroker();
        try {
            TopicManagerService topicManager = eventBroker.getTopicManagerService();
            org.wso2.carbon.andes.event.core.subscription.Subscription[] subscriptions = topicManager.getSubscriptions(topic, true);
            int resultSetSize = maxSubscriptionCount;
            if (subscriptions.length - startingIndex < maxSubscriptionCount) {
                resultSetSize = subscriptions.length - startingIndex;
            }
            Subscription[] subscriptionsDTO = new Subscription[resultSetSize];
            int index = 0;
            int subscriptionIndex = 0;
            for (org.wso2.carbon.andes.event.core.subscription.Subscription backEndSubscription : subscriptions) {
                if (startingIndex == index || startingIndex < index) {
                    subscriptionsDTO[subscriptionIndex] = this.adaptSubscription(backEndSubscription);
                    if (++subscriptionIndex == maxSubscriptionCount) break;
                }
                ++index;
            }
            return subscriptionsDTO;
        }
        catch (EventBrokerException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new EventAdminException(errorMessage, e);
        }
    }

    public Subscription[] getWsSubscriptionsForTopic(String topic) throws EventAdminException {
        topic = this.setNameToLowerCase(topic);
        EventBroker eventBroker = EventAdminHolder.getInstance().getEventBroker();
        try {
            return this.adaptSubscriptions(eventBroker.getTopicManagerService().getSubscriptions(topic, true));
        }
        catch (EventBrokerException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new EventAdminException(errorMessage, e);
        }
    }

    public int getAllWSSubscriptionCountForTopic(String topic) throws EventAdminException {
        topic = this.setNameToLowerCase(topic);
        EventBroker eventBroker = EventAdminHolder.getInstance().getEventBroker();
        try {
            return eventBroker.getTopicManagerService().getSubscriptions(topic, true).length;
        }
        catch (EventBrokerException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new EventAdminException(errorMessage, e);
        }
    }

    public Subscription[] getJMSSubscriptionsForTopic(String topic) throws EventAdminException {
        topic = this.setNameToLowerCase(topic);
        EventBroker eventBroker = EventAdminHolder.getInstance().getEventBroker();
        try {
            return this.adaptSubscriptions(eventBroker.getTopicManagerService().getJMSSubscriptions(topic));
        }
        catch (EventBrokerException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new EventAdminException(errorMessage, e);
        }
    }

    public String[] getUserRoles() throws EventAdminException {
        EventBroker eventBroker = EventAdminHolder.getInstance().getEventBroker();
        try {
            return eventBroker.getTopicManagerService().getBackendRoles();
        }
        catch (EventBrokerException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new EventAdminException(errorMessage, e);
        }
    }

    public void publishToTopic(String content, String topicName) throws EventAdminException {
        topicName = this.setNameToLowerCase(topicName);
        EventBroker eventBroker = EventAdminHolder.getInstance().getEventBroker();
        try {
            if (this.checkCurrentUserHasPublishTopicPermission(topicName)) {
                if (!eventBroker.getTopicManagerService().isTopicExists(topicName)) {
                    throw new EventAdminException("Topic with name : " + topicName + " not exists!");
                }
            } else {
                throw new EventAdminException("Permission denied.");
            }
            Message message = new Message();
            message.setMessage(content);
            eventBroker.publish(message, topicName);
        }
        catch (EventBrokerException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new EventAdminException(errorMessage, e);
        }
    }

    public boolean checkCurrentUserHasAddTopicPermission() throws EventAdminException {
        return this.checkUserHasAddTopicPermission(CarbonContext.getThreadLocalCarbonContext().getUsername());
    }

    public boolean checkUserHasAddTopicPermission(String username) throws EventAdminException {
        EventBroker eventBroker = EventAdminHolder.getInstance().getEventBroker();
        try {
            return eventBroker.getTopicManagerService().checkUserHasAddTopicPermission(username);
        }
        catch (EventBrokerException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new EventAdminException(errorMessage, e);
        }
    }

    public boolean checkCurrentUserHasDeleteTopicPermission() throws EventAdminException {
        return this.checkUserHasDeleteTopicPermission(CarbonContext.getThreadLocalCarbonContext().getUsername());
    }

    public boolean checkUserHasDeleteTopicPermission(String username) throws EventAdminException {
        EventBroker eventBroker = EventAdminHolder.getInstance().getEventBroker();
        try {
            return eventBroker.getTopicManagerService().checkUserHasDeleteTopicPermission(username);
        }
        catch (EventBrokerException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new EventAdminException(errorMessage, e);
        }
    }

    public boolean checkCurrentUserHasDetailsTopicPermission() throws EventAdminException {
        return this.checkUserHasDetailsTopicPermission(CarbonContext.getThreadLocalCarbonContext().getUsername());
    }

    public boolean checkUserHasDetailsTopicPermission(String username) throws EventAdminException {
        EventBroker eventBroker = EventAdminHolder.getInstance().getEventBroker();
        try {
            return eventBroker.getTopicManagerService().checkUserHasDetailsTopicPermission(username);
        }
        catch (EventBrokerException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new EventAdminException(errorMessage, e);
        }
    }

    public boolean checkCurrentUserHasPublishTopicPermission(String topicName) throws EventAdminException {
        topicName = this.setNameToLowerCase(topicName);
        return this.checkUserHasPublishTopicPermission(topicName, CarbonContext.getThreadLocalCarbonContext().getUsername());
    }

    public boolean checkUserHasPublishTopicPermission(String topicName, String username) throws EventAdminException {
        topicName = this.setNameToLowerCase(topicName);
        EventBroker eventBroker = EventAdminHolder.getInstance().getEventBroker();
        try {
            return eventBroker.getTopicManagerService().checkUserHasPublishTopicPermission(topicName, username);
        }
        catch (EventBrokerException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new EventAdminException(errorMessage, e);
        }
    }

    public boolean removeTopic(String topic) throws EventAdminException {
        topic = this.setNameToLowerCase(topic);
        EventBroker eventBroker = EventAdminHolder.getInstance().getEventBroker();
        try {
            return eventBroker.getTopicManagerService().removeTopic(topic);
        }
        catch (EventBrokerException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new EventAdminException(errorMessage, e);
        }
    }

    private Subscription[] adaptSubscriptions(org.wso2.carbon.andes.event.core.subscription.Subscription[] subscriptions) {
        Subscription[] adminSubscriptions = new Subscription[subscriptions.length];
        Calendar calendar = Calendar.getInstance();
        int index = 0;
        for (org.wso2.carbon.andes.event.core.subscription.Subscription coreSubscription : subscriptions) {
            calendar.setTime(coreSubscription.getCreatedTime());
            Subscription adminSubscription = new Subscription();
            adminSubscription.setCreatedTime(calendar);
            adminSubscription.setEventDispatcher(coreSubscription.getEventDispatcher());
            adminSubscription.setEventDispatcherName(coreSubscription.getEventDispatcherName());
            adminSubscription.setEventFilter(coreSubscription.getEventFilter());
            adminSubscription.setEventSinkURL(coreSubscription.getEventSinkURL());
            adminSubscription.setExpires(coreSubscription.getExpires());
            adminSubscription.setId(coreSubscription.getId());
            adminSubscription.setOwner(coreSubscription.getOwner());
            adminSubscription.setTopicName(coreSubscription.getTopicName());
            adminSubscription.setMode(coreSubscription.getMode());
            adminSubscriptions[index] = adminSubscription;
            ++index;
        }
        return adminSubscriptions;
    }

    private Subscription adaptSubscription(org.wso2.carbon.andes.event.core.subscription.Subscription coreSubscription) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(coreSubscription.getCreatedTime());
        Subscription adminSubscription = new Subscription();
        adminSubscription.setCreatedTime(calendar);
        adminSubscription.setEventDispatcher(coreSubscription.getEventDispatcher());
        adminSubscription.setEventDispatcherName(coreSubscription.getEventDispatcherName());
        adminSubscription.setEventFilter(coreSubscription.getEventFilter());
        adminSubscription.setEventSinkURL(coreSubscription.getEventSinkURL());
        adminSubscription.setExpires(coreSubscription.getExpires());
        adminSubscription.setId(coreSubscription.getId());
        adminSubscription.setOwner(coreSubscription.getOwner());
        adminSubscription.setTopicName(coreSubscription.getTopicName());
        adminSubscription.setMode(coreSubscription.getMode());
        return adminSubscription;
    }

    private String setNameToLowerCase(String queue) {
        return queue.toLowerCase();
    }
}

