/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.publisher.admin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterConfiguration;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterSchema;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterService;
import org.wso2.carbon.event.output.adapter.core.Property;
import org.wso2.carbon.event.output.adapter.core.exception.OutputEventAdapterException;
import org.wso2.carbon.event.output.adapter.core.exception.TestConnectionNotSupportedException;
import org.wso2.carbon.event.publisher.admin.BasicOutputAdapterPropertyDto;
import org.wso2.carbon.event.publisher.admin.DetailOutputAdapterPropertyDto;
import org.wso2.carbon.event.publisher.admin.EventMappingPropertyDto;
import org.wso2.carbon.event.publisher.admin.EventPublisherConfigurationDto;
import org.wso2.carbon.event.publisher.admin.EventPublisherConfigurationFileDto;
import org.wso2.carbon.event.publisher.admin.EventPublisherConfigurationInfoDto;
import org.wso2.carbon.event.publisher.admin.JSONOutputMappingDto;
import org.wso2.carbon.event.publisher.admin.MapOutputMappingDto;
import org.wso2.carbon.event.publisher.admin.OutputAdapterConfigurationDto;
import org.wso2.carbon.event.publisher.admin.TextOutputMappingDto;
import org.wso2.carbon.event.publisher.admin.WSO2EventOutputMappingDto;
import org.wso2.carbon.event.publisher.admin.XMLOutputMappingDto;
import org.wso2.carbon.event.publisher.admin.internal.PropertyAttributeTypeConstants;
import org.wso2.carbon.event.publisher.admin.internal.ds.EventPublisherAdminServiceValueHolder;
import org.wso2.carbon.event.publisher.core.EventPublisherService;
import org.wso2.carbon.event.publisher.core.config.EventOutputProperty;
import org.wso2.carbon.event.publisher.core.config.EventPublisherConfiguration;
import org.wso2.carbon.event.publisher.core.config.EventPublisherConfigurationFile;
import org.wso2.carbon.event.publisher.core.config.OutputMapping;
import org.wso2.carbon.event.publisher.core.config.mapping.JSONOutputMapping;
import org.wso2.carbon.event.publisher.core.config.mapping.MapOutputMapping;
import org.wso2.carbon.event.publisher.core.config.mapping.TextOutputMapping;
import org.wso2.carbon.event.publisher.core.config.mapping.WSO2EventOutputMapping;
import org.wso2.carbon.event.publisher.core.config.mapping.XMLOutputMapping;
import org.wso2.carbon.event.publisher.core.exception.EventPublisherConfigurationException;

public class EventPublisherAdminService
extends AbstractAdmin {
    private static Log log = LogFactory.getLog(EventPublisherAdminService.class);

    public EventPublisherConfigurationInfoDto[] getAllActiveEventPublisherConfigurations() throws AxisFault {
        try {
            EventPublisherService eventPublisherService = EventPublisherAdminServiceValueHolder.getEventPublisherService();
            List eventPublisherConfigurationList = eventPublisherService.getAllActiveEventPublisherConfigurations();
            if (eventPublisherConfigurationList != null) {
                EventPublisherConfigurationInfoDto[] eventPublisherConfigurationInfoDtoArray = new EventPublisherConfigurationInfoDto[eventPublisherConfigurationList.size()];
                for (int index = 0; index < eventPublisherConfigurationInfoDtoArray.length; ++index) {
                    EventPublisherConfiguration eventPublisherConfiguration = (EventPublisherConfiguration)eventPublisherConfigurationList.get(index);
                    String eventPublisherName = eventPublisherConfiguration.getEventPublisherName();
                    String mappingType = eventPublisherConfiguration.getOutputMapping().getMappingType();
                    String outputEventAdapterType = eventPublisherConfiguration.getToAdapterConfiguration().getType();
                    String streamNameWithVersion = eventPublisherConfiguration.getFromStreamName() + ":" + eventPublisherConfiguration.getFromStreamVersion();
                    eventPublisherConfigurationInfoDtoArray[index] = new EventPublisherConfigurationInfoDto();
                    eventPublisherConfigurationInfoDtoArray[index].setEventPublisherName(eventPublisherName);
                    eventPublisherConfigurationInfoDtoArray[index].setMessageFormat(mappingType);
                    eventPublisherConfigurationInfoDtoArray[index].setOutputAdapterType(outputEventAdapterType);
                    eventPublisherConfigurationInfoDtoArray[index].setInputStreamId(streamNameWithVersion);
                    eventPublisherConfigurationInfoDtoArray[index].setEnableStats(eventPublisherConfiguration.isStatisticsEnabled());
                    eventPublisherConfigurationInfoDtoArray[index].setEnableTracing(eventPublisherConfiguration.isTracingEnabled());
                    eventPublisherConfigurationInfoDtoArray[index].setEditable(eventPublisherConfiguration.isEditable());
                    eventPublisherConfigurationInfoDtoArray[index].setEnableProcessing(eventPublisherConfiguration.isProcessingEnabled());
                }
                Arrays.sort(eventPublisherConfigurationInfoDtoArray, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        return ((EventPublisherConfigurationInfoDto)o1).getEventPublisherName().compareTo(((EventPublisherConfigurationInfoDto)o2).getEventPublisherName());
                    }
                });
                return eventPublisherConfigurationInfoDtoArray;
            }
            return new EventPublisherConfigurationInfoDto[0];
        }
        catch (EventPublisherConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage());
        }
    }

    public EventPublisherConfigurationInfoDto[] getAllStreamSpecificActiveEventPublisherConfigurations(String streamId) throws AxisFault {
        try {
            EventPublisherService eventPublisherService = EventPublisherAdminServiceValueHolder.getEventPublisherService();
            List eventPublisherConfigurationList = eventPublisherService.getAllActiveEventPublisherConfigurations(streamId);
            if (eventPublisherConfigurationList != null) {
                EventPublisherConfigurationInfoDto[] eventPublisherConfigurationInfoDtoArray = new EventPublisherConfigurationInfoDto[eventPublisherConfigurationList.size()];
                for (int index = 0; index < eventPublisherConfigurationInfoDtoArray.length; ++index) {
                    EventPublisherConfiguration eventPublisherConfiguration = (EventPublisherConfiguration)eventPublisherConfigurationList.get(index);
                    String eventPublisherName = eventPublisherConfiguration.getEventPublisherName();
                    String mappingType = eventPublisherConfiguration.getOutputMapping().getMappingType();
                    String outputEventAdapterType = eventPublisherConfiguration.getToAdapterConfiguration().getType();
                    eventPublisherConfigurationInfoDtoArray[index] = new EventPublisherConfigurationInfoDto();
                    eventPublisherConfigurationInfoDtoArray[index].setEventPublisherName(eventPublisherName);
                    eventPublisherConfigurationInfoDtoArray[index].setMessageFormat(mappingType);
                    eventPublisherConfigurationInfoDtoArray[index].setOutputAdapterType(outputEventAdapterType);
                    eventPublisherConfigurationInfoDtoArray[index].setEnableStats(eventPublisherConfiguration.isStatisticsEnabled());
                    eventPublisherConfigurationInfoDtoArray[index].setEnableTracing(eventPublisherConfiguration.isTracingEnabled());
                    eventPublisherConfigurationInfoDtoArray[index].setEditable(eventPublisherConfiguration.isEditable());
                    eventPublisherConfigurationInfoDtoArray[index].setEnableProcessing(eventPublisherConfiguration.isProcessingEnabled());
                }
                Arrays.sort(eventPublisherConfigurationInfoDtoArray, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        return ((EventPublisherConfigurationInfoDto)o1).getEventPublisherName().compareTo(((EventPublisherConfigurationInfoDto)o2).getEventPublisherName());
                    }
                });
                return eventPublisherConfigurationInfoDtoArray;
            }
            return new EventPublisherConfigurationInfoDto[0];
        }
        catch (EventPublisherConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage());
        }
    }

    public EventPublisherConfigurationFileDto[] getAllInactiveEventPublisherConfigurations() throws AxisFault {
        EventPublisherService eventPublisherService = EventPublisherAdminServiceValueHolder.getEventPublisherService();
        List eventPublisherConfigurationFileList = eventPublisherService.getAllInactiveEventPublisherConfigurations();
        if (eventPublisherConfigurationFileList != null) {
            EventPublisherConfigurationFileDto[] eventPublisherFileDtoArray = new EventPublisherConfigurationFileDto[eventPublisherConfigurationFileList.size()];
            for (int index = 0; index < eventPublisherFileDtoArray.length; ++index) {
                EventPublisherConfigurationFile eventPublisherConfigurationFile = (EventPublisherConfigurationFile)eventPublisherConfigurationFileList.get(index);
                String fileName = eventPublisherConfigurationFile.getFileName();
                String eventPublisherName = eventPublisherConfigurationFile.getEventPublisherName();
                String statusMsg = eventPublisherConfigurationFile.getDeploymentStatusMessage();
                if (eventPublisherConfigurationFile.getDependency() != null) {
                    statusMsg = statusMsg + " [Dependency: " + eventPublisherConfigurationFile.getDependency() + "]";
                }
                eventPublisherFileDtoArray[index] = new EventPublisherConfigurationFileDto(fileName, eventPublisherName, statusMsg);
            }
            Arrays.sort(eventPublisherFileDtoArray, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((EventPublisherConfigurationFileDto)o1).getFileName().compareTo(((EventPublisherConfigurationFileDto)o2).getFileName());
                }
            });
            return eventPublisherFileDtoArray;
        }
        return new EventPublisherConfigurationFileDto[0];
    }

    public EventPublisherConfigurationDto getActiveEventPublisherConfiguration(String eventPublisherName) throws AxisFault {
        EventPublisherService eventPublisherService = EventPublisherAdminServiceValueHolder.getEventPublisherService();
        try {
            EventPublisherConfiguration eventPublisherConfiguration = eventPublisherService.getActiveEventPublisherConfiguration(eventPublisherName);
            if (eventPublisherConfiguration != null) {
                EventPublisherConfigurationDto eventPublisherConfigurationDto = new EventPublisherConfigurationDto();
                eventPublisherConfigurationDto.setEventPublisherName(eventPublisherConfiguration.getEventPublisherName());
                String streamNameWithVersion = eventPublisherConfiguration.getFromStreamName() + ":" + eventPublisherConfiguration.getFromStreamVersion();
                eventPublisherConfigurationDto.setFromStreamNameWithVersion(streamNameWithVersion);
                eventPublisherConfigurationDto.setStreamDefinition(this.getStreamAttributes(eventPublisherService.getStreamDefinition(streamNameWithVersion)));
                OutputEventAdapterConfiguration toAdapterConfiguration = eventPublisherConfiguration.getToAdapterConfiguration();
                if (toAdapterConfiguration != null) {
                    OutputEventAdapterService outputEventAdapterService = EventPublisherAdminServiceValueHolder.getOutputEventAdapterService();
                    OutputEventAdapterSchema outputEventAdapterSchema = outputEventAdapterService.getOutputEventAdapterSchema(toAdapterConfiguration.getType());
                    OutputAdapterConfigurationDto toAdapterConfigurationDto = new OutputAdapterConfigurationDto();
                    toAdapterConfigurationDto.setEventAdapterType(toAdapterConfiguration.getType());
                    toAdapterConfigurationDto.setSupportedMessageFormats(outputEventAdapterSchema.getSupportedMessageFormats().toArray(new String[outputEventAdapterSchema.getSupportedMessageFormats().size()]));
                    toAdapterConfigurationDto.setUsageTips(outputEventAdapterSchema.getUsageTips());
                    HashMap<String, String> outputAdapterProperties = new HashMap<String, String>();
                    outputAdapterProperties.putAll(toAdapterConfiguration.getStaticProperties());
                    outputAdapterProperties.putAll(eventPublisherConfiguration.getToAdapterDynamicProperties());
                    DetailOutputAdapterPropertyDto[] detailOutputAdapterStaticPropertyDtos = this.getPropertyConfigurations(outputAdapterProperties, outputEventAdapterSchema.getStaticPropertyList());
                    DetailOutputAdapterPropertyDto[] detailOutputAdapterDynamicPropertyDtos = this.getPropertyConfigurations(outputAdapterProperties, outputEventAdapterSchema.getDynamicPropertyList());
                    toAdapterConfigurationDto.setOutputEventAdapterStaticProperties(detailOutputAdapterStaticPropertyDtos);
                    toAdapterConfigurationDto.setOutputEventAdapterDynamicProperties(detailOutputAdapterDynamicPropertyDtos);
                    eventPublisherConfigurationDto.setToAdapterConfigurationDto(toAdapterConfigurationDto);
                }
                if (eventPublisherConfiguration.getOutputMapping().getMappingType().equals("json")) {
                    JSONOutputMapping jsonOutputMapping = (JSONOutputMapping)eventPublisherConfiguration.getOutputMapping();
                    JSONOutputMappingDto jsonOutputMappingDto = new JSONOutputMappingDto();
                    jsonOutputMappingDto.setMappingText(jsonOutputMapping.getMappingText());
                    jsonOutputMappingDto.setRegistryResource(jsonOutputMapping.isRegistryResource());
                    jsonOutputMappingDto.setCacheTimeoutDuration(jsonOutputMapping.getCacheTimeoutDuration());
                    eventPublisherConfigurationDto.setJsonOutputMappingDto(jsonOutputMappingDto);
                    eventPublisherConfigurationDto.setCustomMappingEnabled(jsonOutputMapping.isCustomMappingEnabled());
                    eventPublisherConfigurationDto.setMessageFormat("json");
                } else if (eventPublisherConfiguration.getOutputMapping().getMappingType().equals("xml")) {
                    XMLOutputMapping xmlOutputMapping = (XMLOutputMapping)eventPublisherConfiguration.getOutputMapping();
                    XMLOutputMappingDto xmlOutputMappingDto = new XMLOutputMappingDto();
                    xmlOutputMappingDto.setMappingXMLText(xmlOutputMapping.getMappingXMLText());
                    xmlOutputMappingDto.setRegistryResource(xmlOutputMapping.isRegistryResource());
                    xmlOutputMappingDto.setCacheTimeoutDuration(xmlOutputMapping.getCacheTimeoutDuration());
                    eventPublisherConfigurationDto.setCustomMappingEnabled(xmlOutputMapping.isCustomMappingEnabled());
                    eventPublisherConfigurationDto.setXmlOutputMappingDto(xmlOutputMappingDto);
                    eventPublisherConfigurationDto.setMessageFormat("xml");
                } else if (eventPublisherConfiguration.getOutputMapping().getMappingType().equals("text")) {
                    TextOutputMapping textOutputMapping = (TextOutputMapping)eventPublisherConfiguration.getOutputMapping();
                    TextOutputMappingDto textOutputMappingDto = new TextOutputMappingDto();
                    textOutputMappingDto.setMappingText(textOutputMapping.getMappingText());
                    textOutputMappingDto.setRegistryResource(textOutputMapping.isRegistryResource());
                    textOutputMappingDto.setCacheTimeoutDuration(textOutputMapping.getCacheTimeoutDuration());
                    eventPublisherConfigurationDto.setTextOutputMappingDto(textOutputMappingDto);
                    eventPublisherConfigurationDto.setCustomMappingEnabled(textOutputMapping.isCustomMappingEnabled());
                    eventPublisherConfigurationDto.setMessageFormat("text");
                } else if (eventPublisherConfiguration.getOutputMapping().getMappingType().equals("map")) {
                    MapOutputMapping mapOutputMapping = (MapOutputMapping)eventPublisherConfiguration.getOutputMapping();
                    MapOutputMappingDto mapOutputMappingDto = new MapOutputMappingDto();
                    List outputPropertyList = mapOutputMapping.getOutputPropertyConfiguration();
                    if (outputPropertyList != null && outputPropertyList.size() > 0) {
                        EventMappingPropertyDto[] eventMappingPropertyDtos = new EventMappingPropertyDto[outputPropertyList.size()];
                        int index = 0;
                        for (EventOutputProperty eventOutputProperty : outputPropertyList) {
                            eventMappingPropertyDtos[index] = new EventMappingPropertyDto();
                            eventMappingPropertyDtos[index].setName(eventOutputProperty.getName());
                            eventMappingPropertyDtos[index].setValueOf(eventOutputProperty.getValueOf());
                            ++index;
                        }
                        mapOutputMappingDto.setEventMappingProperties(eventMappingPropertyDtos);
                    }
                    eventPublisherConfigurationDto.setMapOutputMappingDto(mapOutputMappingDto);
                    eventPublisherConfigurationDto.setCustomMappingEnabled(mapOutputMapping.isCustomMappingEnabled());
                    eventPublisherConfigurationDto.setMessageFormat("map");
                } else if (eventPublisherConfiguration.getOutputMapping().getMappingType().equals("wso2event")) {
                    WSO2EventOutputMapping wso2EventOutputMapping = (WSO2EventOutputMapping)eventPublisherConfiguration.getOutputMapping();
                    WSO2EventOutputMappingDto wso2EventOutputMappingDto = new WSO2EventOutputMappingDto();
                    List metaOutputPropertyList = wso2EventOutputMapping.getMetaWSO2EventOutputPropertyConfiguration();
                    List correlationOutputPropertyList = wso2EventOutputMapping.getCorrelationWSO2EventOutputPropertyConfiguration();
                    List payloadOutputPropertyList = wso2EventOutputMapping.getPayloadWSO2EventOutputPropertyConfiguration();
                    wso2EventOutputMappingDto.setMetaWSO2EventMappingProperties(this.getEventPropertyDtoArray(metaOutputPropertyList));
                    wso2EventOutputMappingDto.setCorrelationWSO2EventMappingProperties(this.getEventPropertyDtoArray(correlationOutputPropertyList));
                    wso2EventOutputMappingDto.setPayloadWSO2EventMappingProperties(this.getEventPropertyDtoArray(payloadOutputPropertyList));
                    wso2EventOutputMappingDto.setOutputStreamName(wso2EventOutputMapping.getToEventName());
                    wso2EventOutputMappingDto.setOutputStreamVersion(wso2EventOutputMapping.getToEventVersion());
                    eventPublisherConfigurationDto.setCustomMappingEnabled(wso2EventOutputMapping.isCustomMappingEnabled());
                    eventPublisherConfigurationDto.setWso2EventOutputMappingDto(wso2EventOutputMappingDto);
                    eventPublisherConfigurationDto.setMessageFormat("wso2event");
                }
                return eventPublisherConfigurationDto;
            }
        }
        catch (EventPublisherConfigurationException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            throw new AxisFault(ex.getMessage());
        }
        return null;
    }

    public String getActiveEventPublisherConfigurationContent(String eventPublisherName) throws AxisFault {
        EventPublisherService eventPublisherService = EventPublisherAdminServiceValueHolder.getEventPublisherService();
        try {
            return eventPublisherService.getActiveEventPublisherConfigurationContent(eventPublisherName);
        }
        catch (EventPublisherConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage());
        }
    }

    public String getInactiveEventPublisherConfigurationContent(String fileName) throws AxisFault {
        EventPublisherService eventPublisherService = EventPublisherAdminServiceValueHolder.getEventPublisherService();
        try {
            String eventPublisherConfigurationFile = eventPublisherService.getInactiveEventPublisherConfigurationContent(fileName);
            return eventPublisherConfigurationFile.trim();
        }
        catch (EventPublisherConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage());
        }
    }

    public boolean undeployActiveEventPublisherConfiguration(String eventPublisherName) throws AxisFault {
        EventPublisherService eventPublisherService = EventPublisherAdminServiceValueHolder.getEventPublisherService();
        try {
            eventPublisherService.undeployActiveEventPublisherConfiguration(eventPublisherName);
        }
        catch (EventPublisherConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage());
        }
        return true;
    }

    public boolean undeployInactiveEventPublisherConfiguration(String fileName) throws AxisFault {
        EventPublisherService eventPublisherService = EventPublisherAdminServiceValueHolder.getEventPublisherService();
        try {
            eventPublisherService.undeployInactiveEventPublisherConfiguration(fileName);
        }
        catch (EventPublisherConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage());
        }
        return true;
    }

    public boolean editActiveEventPublisherConfiguration(String eventPublisherConfiguration, String eventPublisherName) throws AxisFault {
        EventPublisherService eventPublisherService = EventPublisherAdminServiceValueHolder.getEventPublisherService();
        try {
            eventPublisherService.editActiveEventPublisherConfiguration(eventPublisherConfiguration, eventPublisherName);
        }
        catch (EventPublisherConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage());
        }
        return true;
    }

    public boolean editInactiveEventPublisherConfiguration(String eventPublisherConfiguration, String fileName) throws AxisFault {
        EventPublisherService eventPublisherService = EventPublisherAdminServiceValueHolder.getEventPublisherService();
        try {
            eventPublisherService.editInactiveEventPublisherConfiguration(eventPublisherConfiguration, fileName);
        }
        catch (EventPublisherConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage());
        }
        return true;
    }

    public boolean deployEventPublisherConfiguration(String eventPublisherConfigXml) throws AxisFault {
        try {
            EventPublisherService eventPublisherService = EventPublisherAdminServiceValueHolder.getEventPublisherService();
            eventPublisherService.deployEventPublisherConfiguration(eventPublisherConfigXml);
        }
        catch (EventPublisherConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage());
        }
        return true;
    }

    public boolean deployWSO2EventPublisherConfiguration(String eventPublisherName, String streamNameWithVersion, String eventAdapterType, EventMappingPropertyDto[] metaData, EventMappingPropertyDto[] correlationData, EventMappingPropertyDto[] payloadData, BasicOutputAdapterPropertyDto[] outputPropertyConfiguration, boolean mappingEnabled, String toStreamNameWithVersion) throws AxisFault {
        if (this.checkEventPublisherValidity(eventPublisherName)) {
            try {
                EventPublisherService eventPublisherService = EventPublisherAdminServiceValueHolder.getEventPublisherService();
                EventPublisherConfiguration eventPublisherConfiguration = new EventPublisherConfiguration();
                eventPublisherConfiguration.setProcessEnabled(true);
                eventPublisherConfiguration.setEventPublisherName(eventPublisherName);
                String[] fromStreamProperties = streamNameWithVersion.split(":");
                eventPublisherConfiguration.setFromStreamName(fromStreamProperties[0]);
                eventPublisherConfiguration.setFromStreamVersion(fromStreamProperties[1]);
                StreamDefinition streamDefinition = eventPublisherService.getStreamDefinition(streamNameWithVersion);
                this.constructOutputAdapterRelatedConfigs(eventPublisherName, eventAdapterType, outputPropertyConfiguration, eventPublisherConfiguration, "wso2event");
                WSO2EventOutputMapping wso2EventOutputMapping = new WSO2EventOutputMapping();
                wso2EventOutputMapping.setCustomMappingEnabled(mappingEnabled);
                ArrayList<String> outputEventAttributes = new ArrayList<String>();
                if (mappingEnabled) {
                    EventOutputProperty eventOutputProperty;
                    if (metaData != null && metaData.length != 0) {
                        for (EventMappingPropertyDto wso2EventOutputPropertyConfiguration : metaData) {
                            eventOutputProperty = new EventOutputProperty(wso2EventOutputPropertyConfiguration.getName(), wso2EventOutputPropertyConfiguration.getValueOf(), PropertyAttributeTypeConstants.STRING_ATTRIBUTE_TYPE_MAP.get(this.getPropertyAttributeDataType(wso2EventOutputPropertyConfiguration.getValueOf(), streamDefinition)));
                            wso2EventOutputMapping.addMetaWSO2EventOutputPropertyConfiguration(eventOutputProperty);
                            outputEventAttributes.add(wso2EventOutputPropertyConfiguration.getValueOf());
                        }
                    }
                    if (correlationData != null && correlationData.length != 0) {
                        for (EventMappingPropertyDto wso2EventOutputPropertyConfiguration : correlationData) {
                            eventOutputProperty = new EventOutputProperty(wso2EventOutputPropertyConfiguration.getName(), wso2EventOutputPropertyConfiguration.getValueOf(), PropertyAttributeTypeConstants.STRING_ATTRIBUTE_TYPE_MAP.get(this.getPropertyAttributeDataType(wso2EventOutputPropertyConfiguration.getValueOf(), streamDefinition)));
                            wso2EventOutputMapping.addCorrelationWSO2EventOutputPropertyConfiguration(eventOutputProperty);
                            outputEventAttributes.add(wso2EventOutputPropertyConfiguration.getValueOf());
                        }
                    }
                    if (payloadData != null && payloadData.length != 0) {
                        for (EventMappingPropertyDto wso2EventOutputPropertyConfiguration : payloadData) {
                            eventOutputProperty = new EventOutputProperty(wso2EventOutputPropertyConfiguration.getName(), wso2EventOutputPropertyConfiguration.getValueOf(), PropertyAttributeTypeConstants.STRING_ATTRIBUTE_TYPE_MAP.get(this.getPropertyAttributeDataType(wso2EventOutputPropertyConfiguration.getValueOf(), streamDefinition)));
                            wso2EventOutputMapping.addPayloadWSO2EventOutputPropertyConfiguration(eventOutputProperty);
                            outputEventAttributes.add(wso2EventOutputPropertyConfiguration.getValueOf());
                        }
                    }
                    String[] toStreamProperties = toStreamNameWithVersion.split(":");
                    wso2EventOutputMapping.setToEventName(toStreamProperties[0]);
                    wso2EventOutputMapping.setToEventVersion(toStreamProperties[1]);
                }
                eventPublisherConfiguration.setOutputMapping((OutputMapping)wso2EventOutputMapping);
                eventPublisherService.deployEventPublisherConfiguration(eventPublisherConfiguration);
            }
            catch (EventPublisherConfigurationException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new AxisFault(e.getMessage());
            }
        } else {
            throw new AxisFault(eventPublisherName + " is already registered for this tenant");
        }
        return true;
    }

    public boolean deployTextEventPublisherConfiguration(String eventPublisherName, String streamNameWithVersion, String eventAdapterType, String textData, BasicOutputAdapterPropertyDto[] outputPropertyConfiguration, String dataFrom, boolean mappingEnabled) throws AxisFault {
        return this.deployCacheableTextEventPublisherConfiguration(eventPublisherName, streamNameWithVersion, eventAdapterType, textData, outputPropertyConfiguration, dataFrom, 15L, mappingEnabled);
    }

    public boolean deployCacheableTextEventPublisherConfiguration(String eventPublisherName, String streamNameWithVersion, String eventAdapterType, String textData, BasicOutputAdapterPropertyDto[] outputPropertyConfiguration, String dataFrom, long cacheTimeoutDuration, boolean mappingEnabled) throws AxisFault {
        if (this.checkEventPublisherValidity(eventPublisherName)) {
            try {
                EventPublisherService eventPublisherService = EventPublisherAdminServiceValueHolder.getEventPublisherService();
                EventPublisherConfiguration eventPublisherConfiguration = new EventPublisherConfiguration();
                eventPublisherConfiguration.setProcessEnabled(true);
                eventPublisherConfiguration.setEventPublisherName(eventPublisherName);
                String[] fromStreamProperties = streamNameWithVersion.split(":");
                eventPublisherConfiguration.setFromStreamName(fromStreamProperties[0]);
                eventPublisherConfiguration.setFromStreamVersion(fromStreamProperties[1]);
                this.constructOutputAdapterRelatedConfigs(eventPublisherName, eventAdapterType, outputPropertyConfiguration, eventPublisherConfiguration, "text");
                TextOutputMapping textOutputMapping = new TextOutputMapping();
                textOutputMapping.setCustomMappingEnabled(mappingEnabled);
                textOutputMapping.setRegistryResource(this.validateRegistrySource(dataFrom));
                textOutputMapping.setMappingText(textData);
                textOutputMapping.setCacheTimeoutDuration(cacheTimeoutDuration);
                List<Object> outputEventAttributes = new ArrayList();
                if (mappingEnabled) {
                    if (dataFrom.equalsIgnoreCase("registry") && !textData.contains("{{") || textData.indexOf("}}") < 0) {
                        textData = eventPublisherService.getRegistryResourceContent(textData);
                    }
                    outputEventAttributes = this.getOutputMappingPropertyList(textData);
                }
                eventPublisherConfiguration.setOutputMapping((OutputMapping)textOutputMapping);
                eventPublisherService.deployEventPublisherConfiguration(eventPublisherConfiguration);
            }
            catch (EventPublisherConfigurationException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new AxisFault(e.getMessage());
            }
        } else {
            throw new AxisFault(eventPublisherName + " is already registered for this tenant");
        }
        return true;
    }

    public boolean deployXmlEventPublisherConfiguration(String eventPublisherName, String streamNameWithVersion, String eventAdapterType, String textData, BasicOutputAdapterPropertyDto[] outputPropertyConfiguration, String dataFrom, boolean mappingEnabled) throws AxisFault {
        return this.deployCacheableXmlEventPublisherConfiguration(eventPublisherName, streamNameWithVersion, eventAdapterType, textData, outputPropertyConfiguration, dataFrom, 15L, mappingEnabled);
    }

    public boolean deployCacheableXmlEventPublisherConfiguration(String eventPublisherName, String streamNameWithVersion, String eventAdapterType, String textData, BasicOutputAdapterPropertyDto[] outputPropertyConfiguration, String dataFrom, long cacheTimeoutDuration, boolean mappingEnabled) throws AxisFault {
        if (this.checkEventPublisherValidity(eventPublisherName)) {
            try {
                EventPublisherService eventPublisherService = EventPublisherAdminServiceValueHolder.getEventPublisherService();
                EventPublisherConfiguration eventPublisherConfiguration = new EventPublisherConfiguration();
                eventPublisherConfiguration.setProcessEnabled(true);
                eventPublisherConfiguration.setEventPublisherName(eventPublisherName);
                String[] fromStreamProperties = streamNameWithVersion.split(":");
                eventPublisherConfiguration.setFromStreamName(fromStreamProperties[0]);
                eventPublisherConfiguration.setFromStreamVersion(fromStreamProperties[1]);
                this.constructOutputAdapterRelatedConfigs(eventPublisherName, eventAdapterType, outputPropertyConfiguration, eventPublisherConfiguration, "xml");
                XMLOutputMapping xmlOutputMapping = new XMLOutputMapping();
                xmlOutputMapping.setCustomMappingEnabled(mappingEnabled);
                List<Object> outputEventAttributes = new ArrayList();
                if (mappingEnabled) {
                    xmlOutputMapping.setMappingXMLText(textData);
                    xmlOutputMapping.setRegistryResource(this.validateRegistrySource(dataFrom));
                    xmlOutputMapping.setCacheTimeoutDuration(cacheTimeoutDuration);
                    outputEventAttributes = this.getOutputMappingPropertyList(textData);
                }
                eventPublisherConfiguration.setOutputMapping((OutputMapping)xmlOutputMapping);
                eventPublisherService.deployEventPublisherConfiguration(eventPublisherConfiguration);
            }
            catch (EventPublisherConfigurationException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new AxisFault(e.getMessage());
            }
        } else {
            throw new AxisFault(eventPublisherName + " is already registered for this tenant");
        }
        return true;
    }

    public boolean deployMapEventPublisherConfiguration(String eventPublisherName, String streamNameWithVersion, String eventAdapterType, EventMappingPropertyDto[] mapData, BasicOutputAdapterPropertyDto[] outputPropertyConfiguration, boolean mappingEnabled) throws AxisFault {
        if (this.checkEventPublisherValidity(eventPublisherName)) {
            try {
                EventPublisherService eventPublisherService = EventPublisherAdminServiceValueHolder.getEventPublisherService();
                EventPublisherConfiguration eventPublisherConfiguration = new EventPublisherConfiguration();
                eventPublisherConfiguration.setProcessEnabled(true);
                eventPublisherConfiguration.setEventPublisherName(eventPublisherName);
                String[] fromStreamProperties = streamNameWithVersion.split(":");
                eventPublisherConfiguration.setFromStreamName(fromStreamProperties[0]);
                eventPublisherConfiguration.setFromStreamVersion(fromStreamProperties[1]);
                this.constructOutputAdapterRelatedConfigs(eventPublisherName, eventAdapterType, outputPropertyConfiguration, eventPublisherConfiguration, "map");
                MapOutputMapping mapOutputMapping = new MapOutputMapping();
                mapOutputMapping.setCustomMappingEnabled(mappingEnabled);
                ArrayList<String> outputEventAttributes = new ArrayList<String>();
                if (mappingEnabled && mapData != null && mapData.length != 0) {
                    for (EventMappingPropertyDto eventOutputPropertyConfiguration : mapData) {
                        EventOutputProperty eventOutputProperty = new EventOutputProperty(eventOutputPropertyConfiguration.getName(), eventOutputPropertyConfiguration.getValueOf());
                        mapOutputMapping.addOutputPropertyConfiguration(eventOutputProperty);
                        outputEventAttributes.add(eventOutputPropertyConfiguration.getValueOf());
                    }
                }
                eventPublisherConfiguration.setOutputMapping((OutputMapping)mapOutputMapping);
                eventPublisherService.deployEventPublisherConfiguration(eventPublisherConfiguration);
            }
            catch (EventPublisherConfigurationException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
                throw new AxisFault(ex.getMessage());
            }
        } else {
            throw new AxisFault(eventPublisherName + " is already registered for this tenant");
        }
        return true;
    }

    public boolean deployJsonEventPublisherConfiguration(String eventPublisherName, String streamNameWithVersion, String eventAdapterType, String textData, BasicOutputAdapterPropertyDto[] outputPropertyConfiguration, String dataFrom, boolean mappingEnabled) throws AxisFault {
        return this.deployCacheableJsonEventPublisherConfiguration(eventPublisherName, streamNameWithVersion, eventAdapterType, textData, outputPropertyConfiguration, dataFrom, 15L, mappingEnabled);
    }

    public boolean deployCacheableJsonEventPublisherConfiguration(String eventPublisherName, String streamNameWithVersion, String eventAdapterType, String jsonData, BasicOutputAdapterPropertyDto[] outputPropertyConfiguration, String dataFrom, long cacheTimeoutDuration, boolean mappingEnabled) throws AxisFault {
        if (this.checkEventPublisherValidity(eventPublisherName)) {
            try {
                EventPublisherService eventPublisherService = EventPublisherAdminServiceValueHolder.getEventPublisherService();
                EventPublisherConfiguration eventPublisherConfiguration = new EventPublisherConfiguration();
                eventPublisherConfiguration.setProcessEnabled(true);
                eventPublisherConfiguration.setEventPublisherName(eventPublisherName);
                String[] fromStreamProperties = streamNameWithVersion.split(":");
                eventPublisherConfiguration.setFromStreamName(fromStreamProperties[0]);
                eventPublisherConfiguration.setFromStreamVersion(fromStreamProperties[1]);
                this.constructOutputAdapterRelatedConfigs(eventPublisherName, eventAdapterType, outputPropertyConfiguration, eventPublisherConfiguration, "json");
                JSONOutputMapping jsonOutputMapping = new JSONOutputMapping();
                jsonOutputMapping.setCustomMappingEnabled(mappingEnabled);
                List<Object> outputEventAttributes = new ArrayList();
                if (mappingEnabled) {
                    jsonOutputMapping.setRegistryResource(this.validateRegistrySource(dataFrom));
                    jsonOutputMapping.setMappingText(jsonData);
                    jsonOutputMapping.setCacheTimeoutDuration(cacheTimeoutDuration);
                    outputEventAttributes = this.getOutputMappingPropertyList(jsonData);
                }
                eventPublisherConfiguration.setOutputMapping((OutputMapping)jsonOutputMapping);
                eventPublisherService.deployEventPublisherConfiguration(eventPublisherConfiguration);
            }
            catch (EventPublisherConfigurationException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
                throw new AxisFault(ex.getMessage());
            }
        } else {
            throw new AxisFault(eventPublisherName + " is already registered for this tenant");
        }
        return true;
    }

    public boolean setStatisticsEnabled(String eventPublisherName, boolean flag) throws AxisFault {
        EventPublisherService eventPublisherService = EventPublisherAdminServiceValueHolder.getEventPublisherService();
        try {
            eventPublisherService.setStatisticsEnabled(eventPublisherName, flag);
        }
        catch (EventPublisherConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage());
        }
        return true;
    }

    public boolean setTracingEnabled(String eventPublisherName, boolean flag) throws AxisFault {
        EventPublisherService eventPublisherService = EventPublisherAdminServiceValueHolder.getEventPublisherService();
        try {
            eventPublisherService.setTraceEnabled(eventPublisherName, flag);
        }
        catch (EventPublisherConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage());
        }
        return true;
    }

    public boolean setProcessingEnabled(String eventPublisherName, boolean flag) throws AxisFault {
        EventPublisherService eventPublisherService = EventPublisherAdminServiceValueHolder.getEventPublisherService();
        try {
            eventPublisherService.setProcessEnabled(eventPublisherName, flag);
        }
        catch (EventPublisherConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage());
        }
        return true;
    }

    public OutputAdapterConfigurationDto getOutputAdapterConfigurationSchema(String adopterType) {
        OutputEventAdapterService outputEventAdapterService = EventPublisherAdminServiceValueHolder.getOutputEventAdapterService();
        OutputEventAdapterSchema outputEventAdapterSchema = outputEventAdapterService.getOutputEventAdapterSchema(adopterType);
        OutputAdapterConfigurationDto outputAdapterConfigurationDto = new OutputAdapterConfigurationDto();
        outputAdapterConfigurationDto.setOutputEventAdapterStaticProperties(this.getPropertyConfigurations(null, outputEventAdapterSchema.getStaticPropertyList()));
        outputAdapterConfigurationDto.setOutputEventAdapterDynamicProperties(this.getPropertyConfigurations(null, outputEventAdapterSchema.getDynamicPropertyList()));
        outputAdapterConfigurationDto.setEventAdapterType(adopterType);
        outputAdapterConfigurationDto.setSupportedMessageFormats(outputEventAdapterSchema.getSupportedMessageFormats().toArray(new String[outputEventAdapterSchema.getSupportedMessageFormats().size()]));
        outputAdapterConfigurationDto.setUsageTips(outputEventAdapterSchema.getUsageTips());
        return outputAdapterConfigurationDto;
    }

    public String[] getAllOutputAdapterTypes() {
        OutputEventAdapterService outputEventAdapterService = EventPublisherAdminServiceValueHolder.getOutputEventAdapterService();
        List outputEventAdapters = outputEventAdapterService.getOutputEventAdapterTypes();
        if (outputEventAdapters == null) {
            return new String[0];
        }
        Collections.sort(outputEventAdapters);
        String[] types = new String[outputEventAdapters.size()];
        return outputEventAdapters.toArray(types);
    }

    private void constructOutputAdapterRelatedConfigs(String eventPublisherName, String eventAdapterType, BasicOutputAdapterPropertyDto[] outputPropertyConfiguration, EventPublisherConfiguration eventPublisherConfiguration, String messageFormat) {
        OutputEventAdapterConfiguration outputEventAdapterConfiguration = new OutputEventAdapterConfiguration();
        outputEventAdapterConfiguration.setName(eventPublisherName);
        outputEventAdapterConfiguration.setType(eventAdapterType);
        outputEventAdapterConfiguration.setMessageFormat(messageFormat);
        outputEventAdapterConfiguration.setStaticProperties(new HashMap());
        eventPublisherConfiguration.setToAdapterDynamicProperties(new HashMap());
        if (outputPropertyConfiguration != null && outputPropertyConfiguration.length != 0) {
            for (BasicOutputAdapterPropertyDto eventPublisherProperty : outputPropertyConfiguration) {
                if (eventPublisherProperty.getValue().trim().equals("")) continue;
                if (eventPublisherProperty.isStatic()) {
                    outputEventAdapterConfiguration.getStaticProperties().put(eventPublisherProperty.getKey().trim(), eventPublisherProperty.getValue().trim());
                    continue;
                }
                eventPublisherConfiguration.getToAdapterDynamicProperties().put(eventPublisherProperty.getKey().trim(), eventPublisherProperty.getValue().trim());
            }
        }
        eventPublisherConfiguration.setToAdapterConfiguration(outputEventAdapterConfiguration);
    }

    private EventMappingPropertyDto[] getEventPropertyDtoArray(List<EventOutputProperty> eventOutputPropertyList) {
        if (eventOutputPropertyList != null && eventOutputPropertyList.size() > 0) {
            EventMappingPropertyDto[] eventMappingPropertyDtos = new EventMappingPropertyDto[eventOutputPropertyList.size()];
            int index = 0;
            for (EventOutputProperty eventOutputProperty : eventOutputPropertyList) {
                eventMappingPropertyDtos[index] = new EventMappingPropertyDto(eventOutputProperty.getName(), eventOutputProperty.getValueOf(), eventOutputProperty.getType().toString().toLowerCase());
                ++index;
            }
            return eventMappingPropertyDtos;
        }
        return null;
    }

    private DetailOutputAdapterPropertyDto[] getPropertyConfigurations(Map<String, String> messageProperties, List<Property> propertyList) {
        if (propertyList != null && propertyList.size() > 0) {
            DetailOutputAdapterPropertyDto[] detailOutputAdapterPropertyDtoArray = new DetailOutputAdapterPropertyDto[propertyList.size()];
            int index = 0;
            for (Property property : propertyList) {
                String value = null;
                if (messageProperties != null) {
                    value = messageProperties.get(property.getPropertyName());
                }
                detailOutputAdapterPropertyDtoArray[index] = new DetailOutputAdapterPropertyDto(property.getPropertyName(), value);
                detailOutputAdapterPropertyDtoArray[index].setSecured(property.isSecured());
                detailOutputAdapterPropertyDtoArray[index].setRequired(property.isRequired());
                detailOutputAdapterPropertyDtoArray[index].setDisplayName(property.getDisplayName());
                detailOutputAdapterPropertyDtoArray[index].setDefaultValue(property.getDefaultValue());
                detailOutputAdapterPropertyDtoArray[index].setHint(property.getHint());
                detailOutputAdapterPropertyDtoArray[index].setOptions(property.getOptions());
                ++index;
            }
            return detailOutputAdapterPropertyDtoArray;
        }
        return new DetailOutputAdapterPropertyDto[0];
    }

    private String getStreamAttributes(StreamDefinition streamDefinition) {
        List metaAttributeList = streamDefinition.getMetaData();
        List correlationAttributeList = streamDefinition.getCorrelationData();
        List payloadAttributeList = streamDefinition.getPayloadData();
        String attributes = "";
        if (metaAttributeList != null) {
            for (Attribute attribute : metaAttributeList) {
                attributes = attributes + "meta_" + attribute.getName() + " " + attribute.getType().toString().toLowerCase() + ", \n";
            }
        }
        if (correlationAttributeList != null) {
            for (Attribute attribute : correlationAttributeList) {
                attributes = attributes + "correlation_" + attribute.getName() + " " + attribute.getType().toString().toLowerCase() + ", \n";
            }
        }
        if (payloadAttributeList != null) {
            for (Attribute attribute : payloadAttributeList) {
                attributes = attributes + attribute.getName() + " " + attribute.getType().toString().toLowerCase() + ", \n";
            }
        }
        if (!attributes.equals("")) {
            return attributes.substring(0, attributes.lastIndexOf(","));
        }
        return attributes;
    }

    private List<String> getOutputMappingPropertyList(String mappingText) {
        ArrayList<String> mappingTextList = new ArrayList<String>();
        String text = mappingText;
        mappingTextList.clear();
        while (text.contains("{{") && text.indexOf("}}") > 0) {
            String property = text.substring(text.indexOf("{{") + 2, text.indexOf("}}"));
            if (property != null && !property.startsWith("arbitrary_")) {
                mappingTextList.add(property);
            }
            text = text.substring(text.indexOf("}}") + 2);
        }
        return mappingTextList;
    }

    private boolean checkEventPublisherValidity(String eventPublisherName) throws AxisFault {
        try {
            EventPublisherService eventPublisherService = EventPublisherAdminServiceValueHolder.getEventPublisherService();
            int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
            List eventPublisherConfigurationList = null;
            eventPublisherConfigurationList = eventPublisherService.getAllActiveEventPublisherConfigurations();
            for (EventPublisherConfiguration eventPublisherConfiguration : eventPublisherConfigurationList) {
                if (!eventPublisherConfiguration.getEventPublisherName().equalsIgnoreCase(eventPublisherName)) continue;
                return false;
            }
        }
        catch (EventPublisherConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage());
        }
        return true;
    }

    private boolean validateRegistrySource(String fromData) {
        return !fromData.equalsIgnoreCase("inline");
    }

    private String getPropertyAttributeDataType(String propertyName, StreamDefinition streamDefinition) throws AxisFault {
        if (propertyName != null) {
            List payloadDataList;
            List correlationDataList;
            List metaDataList = streamDefinition.getMetaData();
            if (metaDataList != null) {
                for (Attribute attribute : metaDataList) {
                    if (!propertyName.equalsIgnoreCase("meta_" + attribute.getName())) continue;
                    return attribute.getType().toString().toLowerCase();
                }
            }
            if ((correlationDataList = streamDefinition.getCorrelationData()) != null) {
                for (Attribute attribute : correlationDataList) {
                    if (!propertyName.equalsIgnoreCase("correlation_" + attribute.getName())) continue;
                    return attribute.getType().toString().toLowerCase();
                }
            }
            if ((payloadDataList = streamDefinition.getPayloadData()) != null) {
                for (Attribute attribute : payloadDataList) {
                    if (!propertyName.equalsIgnoreCase(attribute.getName())) continue;
                    return attribute.getType().toString().toLowerCase();
                }
            }
        }
        throw new AxisFault("Output Stream attributes are not matching with input stream definition");
    }

    public void testPublisherConnection(String eventPublisherName, String eventAdapterType, BasicOutputAdapterPropertyDto[] outputPropertyConfiguration, String messageFormat) throws AxisFault {
        try {
            EventPublisherConfiguration eventPublisherConfiguration = new EventPublisherConfiguration();
            this.constructOutputAdapterRelatedConfigs(eventPublisherName, eventAdapterType, outputPropertyConfiguration, eventPublisherConfiguration, messageFormat);
            EventPublisherAdminServiceValueHolder.getOutputEventAdapterService().testConnection(eventPublisherConfiguration.getToAdapterConfiguration());
        }
        catch (TestConnectionNotSupportedException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage());
        }
        catch (OutputEventAdapterException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage());
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
            throw new AxisFault(e.getMessage());
        }
    }

    public boolean isPublisherEditable(String eventPublisherName) {
        EventPublisherService eventPublisherService = EventPublisherAdminServiceValueHolder.getEventPublisherService();
        List eventPublisherConfigurationList = null;
        boolean isEditable = false;
        try {
            eventPublisherConfigurationList = eventPublisherService.getAllActiveEventPublisherConfigurations();
            for (EventPublisherConfiguration eventPublisherConfiguration : eventPublisherConfigurationList) {
                if (!eventPublisherConfiguration.getEventPublisherName().equalsIgnoreCase(eventPublisherName)) continue;
                isEditable = eventPublisherConfiguration.isEditable();
            }
        }
        catch (EventPublisherConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return isEditable;
    }

    public boolean isPublisherStatisticsEnabled(String eventPublisherName) {
        EventPublisherService eventPublisherService = EventPublisherAdminServiceValueHolder.getEventPublisherService();
        List eventPublisherConfigurationList = null;
        boolean isStatisticsEnabled = false;
        try {
            eventPublisherConfigurationList = eventPublisherService.getAllActiveEventPublisherConfigurations();
            for (EventPublisherConfiguration eventPublisherConfiguration : eventPublisherConfigurationList) {
                if (!eventPublisherConfiguration.getEventPublisherName().equalsIgnoreCase(eventPublisherName)) continue;
                isStatisticsEnabled = eventPublisherConfiguration.isStatisticsEnabled();
            }
        }
        catch (EventPublisherConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return isStatisticsEnabled;
    }

    public boolean isPublisherProcessingEnabled(String eventPublisherName) {
        EventPublisherService eventPublisherService = EventPublisherAdminServiceValueHolder.getEventPublisherService();
        List eventPublisherConfigurationList = null;
        boolean isProcessEnabled = true;
        try {
            eventPublisherConfigurationList = eventPublisherService.getAllActiveEventPublisherConfigurations();
            for (EventPublisherConfiguration eventPublisherConfiguration : eventPublisherConfigurationList) {
                if (!eventPublisherConfiguration.getEventPublisherName().equalsIgnoreCase(eventPublisherName)) continue;
                isProcessEnabled = eventPublisherConfiguration.isProcessingEnabled();
            }
        }
        catch (EventPublisherConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return isProcessEnabled;
    }

    public boolean isPublisherTraceEnabled(String eventPublisherName) {
        EventPublisherService eventPublisherService = EventPublisherAdminServiceValueHolder.getEventPublisherService();
        List eventPublisherConfigurationList = null;
        boolean isTraceEnabled = false;
        try {
            eventPublisherConfigurationList = eventPublisherService.getAllActiveEventPublisherConfigurations();
            for (EventPublisherConfiguration eventPublisherConfiguration : eventPublisherConfigurationList) {
                if (!eventPublisherConfiguration.getEventPublisherName().equalsIgnoreCase(eventPublisherName)) continue;
                isTraceEnabled = eventPublisherConfiguration.isTracingEnabled();
            }
        }
        catch (EventPublisherConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return isTraceEnabled;
    }
}

