/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.common.util;

import java.text.DecimalFormat;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThroughputProbe
extends TimerTask {
    private static Log log = LogFactory.getLog(ThroughputProbe.class);
    private long count = 0L;
    private int sampleCount = 0;
    private long samplingRateInSeconds;
    private String name;
    private double maxThroughput = 0.0;
    private double minThroughput = Double.MAX_VALUE;
    private double accumulatedThroughput = 0.0;
    DecimalFormat formatter = new DecimalFormat("#.000");
    Timer timer;
    private long totalEventCount = 0L;

    public ThroughputProbe(String name, int samplingRateInSeconds) {
        this.name = name;
        this.samplingRateInSeconds = samplingRateInSeconds;
    }

    public void startSampling() {
        this.count = 0L;
        this.timer = new Timer();
        this.timer.schedule((TimerTask)this, this.samplingRateInSeconds * 1000L, this.samplingRateInSeconds * 1000L);
    }

    public void update() {
        ++this.count;
        ++this.totalEventCount;
    }

    @Override
    public void run() {
        if (log.isDebugEnabled() && this.totalEventCount > 0L) {
            double throughput = this.count / this.samplingRateInSeconds;
            if (this.maxThroughput < throughput) {
                this.maxThroughput = throughput;
            }
            if (this.minThroughput > throughput && throughput != 0.0) {
                this.minThroughput = throughput;
            }
            this.accumulatedThroughput += throughput;
            ++this.sampleCount;
            log.debug((Object)("[ThroughputProbe:" + this.name + "] " + this.count + " events in " + this.samplingRateInSeconds + " seconds. Throughput=" + this.formatter.format(throughput) + " events/s.(Avg=" + this.formatter.format(this.accumulatedThroughput / (double)this.sampleCount) + " ,Max=" + this.formatter.format(this.maxThroughput) + " ,Min=" + (this.minThroughput == Double.MAX_VALUE ? "0.0" : this.formatter.format(this.minThroughput)) + " ) TotalEvents=" + this.totalEventCount));
            this.count = 0L;
        }
    }
}

