/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.common.util;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.dsl.Disruptor;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

class AsynchronousEventBuffer<Type> {
    private Disruptor<DataHolder> disruptor;
    private RingBuffer<DataHolder> ringBuffer;

    public AsynchronousEventBuffer(int bufferSize, EventHandler publishHandler) {
        this.disruptor = new Disruptor((EventFactory)new EventFactory<DataHolder>(){

            public DataHolder newInstance() {
                return new DataHolder();
            }
        }, bufferSize, (Executor)Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("Thread pool- component - AsynchronousEventBuffer").build()));
        this.ringBuffer = this.disruptor.getRingBuffer();
        this.disruptor.handleEventsWith(new EventHandler[]{publishHandler});
        this.disruptor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(Type data, long timestamp, String streamId) {
        long sequenceNo = this.ringBuffer.next();
        try {
            DataHolder existingHolder = (DataHolder)this.ringBuffer.get(sequenceNo);
            existingHolder.setData(data);
            existingHolder.setTimestamp(timestamp);
            existingHolder.setStreamId(streamId);
        }
        finally {
            this.ringBuffer.publish(sequenceNo);
        }
    }

    public void terminate() {
        this.disruptor.halt();
    }

    class DataHolder {
        Type data;
        String streamId;
        private long timestamp;

        DataHolder() {
        }

        public void setData(Type data) {
            this.data = data;
        }

        public Type getData() {
            return this.data;
        }

        public void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        public String getStreamId() {
            return this.streamId;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }
    }
}

