/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.common.util;

import com.lmax.disruptor.EventHandler;
import java.io.IOException;
import java.net.SocketException;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.wso2.carbon.event.processor.common.storm.manager.service.StormManagerService;
import org.wso2.carbon.event.processor.common.storm.manager.service.exception.EndpointNotFoundException;
import org.wso2.carbon.event.processor.common.storm.manager.service.exception.NotStormCoordinatorException;
import org.wso2.carbon.event.processor.common.util.AsynchronousEventBuffer;
import org.wso2.carbon.event.processor.common.util.ThroughputProbe;
import org.wso2.carbon.event.processor.manager.commons.transport.client.ConnectionFailureHandler;
import org.wso2.carbon.event.processor.manager.commons.transport.client.TCPEventPublisher;
import org.wso2.carbon.event.processor.manager.commons.transport.server.ConnectionCallback;
import org.wso2.carbon.event.processor.manager.commons.utils.HostAndPort;
import org.wso2.carbon.event.processor.manager.commons.utils.Utils;
import org.wso2.carbon.event.processor.manager.core.config.DistributedConfiguration;
import org.wso2.siddhi.query.api.definition.StreamDefinition;

public class AsyncEventPublisher
implements EventHandler<AsynchronousEventBuffer.DataHolder>,
ConnectionFailureHandler {
    private transient Log log = LogFactory.getLog(AsyncEventPublisher.class);
    private String logPrefix;
    private String destinationTypeString;
    private String publisherTypeString;
    private DestinationType destinationType;
    private Set<StreamDefinition> streams;
    private String executionPlanName;
    private int tenantId;
    private String thisHostIp;
    private List<HostAndPort> managerServiceEndpoints;
    private DistributedConfiguration stormDeploymentConfig;
    AsynchronousEventBuffer eventSendBuffer = null;
    private ConnectionCallback connectionCallback;
    private TCPEventPublisher tcpEventPublisher = null;
    private EndpointConnectionCreator endpointConnectionCreator;
    private boolean shutdown = false;
    private ThroughputProbe inputThroughputProbe;
    private ThroughputProbe publishThroughputProbe;

    public AsyncEventPublisher(DestinationType destinationType, Set<StreamDefinition> streams, List<HostAndPort> managerServiceEndpoints, String executionPlanName, int tenantId, DistributedConfiguration stormDeploymentConfig, ConnectionCallback connectionCallback) {
        this.destinationType = destinationType;
        this.streams = streams;
        this.executionPlanName = executionPlanName;
        this.tenantId = tenantId;
        this.managerServiceEndpoints = managerServiceEndpoints;
        this.stormDeploymentConfig = stormDeploymentConfig;
        this.connectionCallback = connectionCallback;
        this.endpointConnectionCreator = new EndpointConnectionCreator();
        this.destinationTypeString = destinationType == DestinationType.STORM_RECEIVER ? "StormReceiver" : "CEPPublisher";
        this.publisherTypeString = destinationType == DestinationType.STORM_RECEIVER ? "CEPReceiver" : "PublisherBolt";
        int bufferSize = this.publisherTypeString.equals("CEPReceiver") ? stormDeploymentConfig.getCepReceiverOutputQueueSize() : stormDeploymentConfig.getStormPublisherOutputQueueSize();
        this.eventSendBuffer = new AsynchronousEventBuffer(bufferSize, this);
        this.logPrefix = "[" + tenantId + ":" + executionPlanName + ":" + this.publisherTypeString + "] ";
    }

    public void initializeConnection(boolean sync) {
        try {
            this.thisHostIp = Utils.findAddress((String)"localhost");
            if (sync) {
                this.endpointConnectionCreator.establishConnection();
            } else {
                Thread thread = new Thread(this.endpointConnectionCreator);
                thread.start();
            }
            this.inputThroughputProbe = new ThroughputProbe(this.logPrefix + "-In", 10);
            this.publishThroughputProbe = new ThroughputProbe(this.logPrefix + " -Publish", 10);
            this.inputThroughputProbe.startSampling();
            this.publishThroughputProbe.startSampling();
        }
        catch (SocketException e) {
            this.log.error((Object)(this.logPrefix + "Error while trying to obtain this host IP address"), (Throwable)e);
        }
    }

    public void sendEvent(Object[] eventData, long timestamp, String streamId) {
        this.eventSendBuffer.addEvent(eventData, timestamp, streamId);
        this.inputThroughputProbe.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(AsynchronousEventBuffer.DataHolder dataHolder, long sequence, boolean endOfBatch) {
        while (this.tcpEventPublisher == null) {
            this.log.info((Object)(this.logPrefix + "Can't send event. TCP event publisher not initialized. Waiting " + this.stormDeploymentConfig.getTransportReconnectInterval() + "s"));
            try {
                AsyncEventPublisher asyncEventPublisher = this;
                synchronized (asyncEventPublisher) {
                    if (this.shutdown) {
                        this.log.info((Object)(this.logPrefix + "Aborting retry to send events. AsyncEventPublisher has shutdown."));
                        return;
                    }
                }
                Thread.sleep(this.stormDeploymentConfig.getTransportReconnectInterval());
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            this.tcpEventPublisher.sendEvent(dataHolder.getStreamId(), dataHolder.getTimestamp(), (Object[])dataHolder.getData(), endOfBatch);
            this.publishThroughputProbe.update();
        }
        catch (IOException e) {
            this.log.error((Object)(this.logPrefix + "Error while trying to send event to " + this.destinationTypeString + " at " + this.tcpEventPublisher.getHostUrl()), (Throwable)e);
            this.reconnect();
            this.onEvent(dataHolder, sequence, endOfBatch);
        }
    }

    private void reconnect() {
        String destinationHostPort = this.tcpEventPublisher.getHostUrl();
        this.resetTCPEventPublisher();
        this.tcpEventPublisher = this.endpointConnectionCreator.connectToEndpoint(destinationHostPort, 3);
        if (this.tcpEventPublisher == null) {
            this.log.error((Object)(this.logPrefix + "Failed to connect to existing " + this.destinationTypeString + " at " + destinationHostPort + ". Reinitializing connection process"));
            this.initializeConnection(true);
        }
    }

    private void resetTCPEventPublisher() {
        if (this.tcpEventPublisher != null) {
            this.tcpEventPublisher.terminate();
            this.tcpEventPublisher = null;
        }
    }

    protected void finalize() {
        if (this.tcpEventPublisher != null) {
            this.tcpEventPublisher.shutdown();
            this.tcpEventPublisher = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        AsyncEventPublisher asyncEventPublisher = this;
        synchronized (asyncEventPublisher) {
            this.shutdown = true;
        }
        this.eventSendBuffer.terminate();
        this.finalize();
    }

    public void onConnectionFail(Exception e) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Pinging failed to " + this.tcpEventPublisher.getHostUrl() + ". Trying to re-connect."));
        }
        if (!this.shutdown) {
            this.reconnect();
        } else {
            this.log.info((Object)("Not trying to reconnect to " + this.tcpEventPublisher.getHostUrl() + " because event publisher is shutdown"));
        }
    }

    class EndpointConnectionCreator
    implements Runnable {
        EndpointConnectionCreator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getEndpointFromManagerService() {
            String endpointHostPort = null;
            do {
                for (HostAndPort endpoint : AsyncEventPublisher.this.managerServiceEndpoints) {
                    TSocket transport = null;
                    try {
                        transport = new TSocket(endpoint.getHostName(), endpoint.getPort());
                        TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
                        transport.open();
                        StormManagerService.Client client = new StormManagerService.Client((TProtocol)protocol);
                        endpointHostPort = AsyncEventPublisher.this.destinationType == DestinationType.CEP_PUBLISHER ? client.getCEPPublisher(AsyncEventPublisher.this.tenantId, AsyncEventPublisher.this.executionPlanName, AsyncEventPublisher.this.thisHostIp) : client.getStormReceiver(AsyncEventPublisher.this.tenantId, AsyncEventPublisher.this.executionPlanName, AsyncEventPublisher.this.thisHostIp);
                        AsyncEventPublisher.this.log.info((Object)(AsyncEventPublisher.this.logPrefix + "Retrieved " + AsyncEventPublisher.this.destinationTypeString + " at " + endpointHostPort + " from storm manager service at " + endpoint.getHostName() + ":" + endpoint.getPort()));
                        break;
                    }
                    catch (NotStormCoordinatorException e) {
                        AsyncEventPublisher.this.log.info((Object)(AsyncEventPublisher.this.logPrefix + "Cannot retrieve " + AsyncEventPublisher.this.destinationType.name() + " endpoint information from storm manager service at " + endpoint.getHostName() + ":" + endpoint.getPort() + " as it's not a Storm coordinator, Trying next Storm manager."));
                    }
                    catch (EndpointNotFoundException e) {
                        AsyncEventPublisher.this.log.info((Object)(AsyncEventPublisher.this.logPrefix + AsyncEventPublisher.this.destinationType.name() + " endpoint information not available on storm manager service at " + endpoint.getHostName() + ":" + endpoint.getPort() + ". Trying next Storm manager."));
                    }
                    catch (TTransportException e) {
                        AsyncEventPublisher.this.log.info((Object)(AsyncEventPublisher.this.logPrefix + "Cannot retrieve " + AsyncEventPublisher.this.destinationType.name() + " endpoint information from storm manager service at " + endpoint.getHostName() + ":" + endpoint.getPort() + " as it's not reachable, " + e.getMessage() + ". Trying next Storm manager."));
                    }
                    catch (TException e) {
                        AsyncEventPublisher.this.log.info((Object)(AsyncEventPublisher.this.logPrefix + "Cannot retrieve " + AsyncEventPublisher.this.destinationType.name() + " endpoint information from storm manager service at " + endpoint.getHostName() + ":" + endpoint.getPort() + " as it's not reachable, " + e.getMessage() + ". Trying next Storm manager."));
                    }
                    finally {
                        if (transport == null) continue;
                        transport.close();
                    }
                }
                AsyncEventPublisher asyncEventPublisher = AsyncEventPublisher.this;
                synchronized (asyncEventPublisher) {
                    if (AsyncEventPublisher.this.shutdown) {
                        AsyncEventPublisher.this.log.info((Object)(AsyncEventPublisher.this.logPrefix + "Stopping attempting to connect to Storm manager service. Async event publisher is shutdown"));
                        return null;
                    }
                }
                if (endpointHostPort != null) continue;
                try {
                    AsyncEventPublisher.this.log.info((Object)(AsyncEventPublisher.this.logPrefix + "Failed to retrieve " + AsyncEventPublisher.this.destinationType.name() + " from given set of Storm Managers. Retrying to retrieve endpoint from manager service in " + AsyncEventPublisher.this.stormDeploymentConfig.getManagementReconnectInterval() + " ms to get a " + AsyncEventPublisher.this.destinationTypeString));
                    Thread.sleep(AsyncEventPublisher.this.stormDeploymentConfig.getManagementReconnectInterval());
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
            } while (endpointHostPort == null);
            return endpointHostPort;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TCPEventPublisher connectToEndpoint(String endpoint, int retryAttempts) {
            TCPEventPublisher tcpEventPublisher = null;
            int attemptCount = 0;
            do {
                block11: {
                    AsyncEventPublisher asyncEventPublisher = AsyncEventPublisher.this;
                    synchronized (asyncEventPublisher) {
                        if (AsyncEventPublisher.this.shutdown) {
                            AsyncEventPublisher.this.log.info((Object)(AsyncEventPublisher.this.logPrefix + "Stopping attempting to connect to endpoint " + endpoint + ". Async event publisher is shutdown"));
                            return null;
                        }
                    }
                    try {
                        tcpEventPublisher = new TCPEventPublisher(endpoint, AsyncEventPublisher.this.stormDeploymentConfig.constructTransportPublisherConfig(), true, AsyncEventPublisher.this.connectionCallback);
                        StringBuilder streamsIDs = new StringBuilder();
                        for (StreamDefinition siddhiStreamDefinition : AsyncEventPublisher.this.streams) {
                            tcpEventPublisher.addStreamDefinition(siddhiStreamDefinition);
                            streamsIDs.append(siddhiStreamDefinition.getId() + ",");
                        }
                        tcpEventPublisher.registerConnectionFailureHandler((ConnectionFailureHandler)AsyncEventPublisher.this);
                        AsyncEventPublisher.this.log.info((Object)(AsyncEventPublisher.this.logPrefix + "Connected to " + AsyncEventPublisher.this.destinationTypeString + " at " + endpoint + " for the Stream(s) " + streamsIDs.toString()));
                    }
                    catch (IOException e) {
                        AsyncEventPublisher.this.log.info((Object)(AsyncEventPublisher.this.logPrefix + "Cannot connect to " + AsyncEventPublisher.this.destinationTypeString + " at " + endpoint + ", " + e.getMessage()));
                        if (!AsyncEventPublisher.this.log.isDebugEnabled()) break block11;
                        AsyncEventPublisher.this.log.debug((Object)(AsyncEventPublisher.this.logPrefix + "Cannot connect to " + AsyncEventPublisher.this.destinationTypeString + " at " + endpoint), (Throwable)e);
                    }
                }
                if (tcpEventPublisher != null) continue;
                if (retryAttempts > 0 && ++attemptCount > retryAttempts) {
                    return null;
                }
                try {
                    AsyncEventPublisher.this.log.info((Object)(AsyncEventPublisher.this.logPrefix + "Retrying(" + attemptCount + ") to connect to " + AsyncEventPublisher.this.destinationTypeString + " at " + endpoint + " in " + AsyncEventPublisher.this.stormDeploymentConfig.getTransportReconnectInterval() + "ms"));
                    Thread.sleep(AsyncEventPublisher.this.stormDeploymentConfig.getTransportReconnectInterval());
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
            } while (tcpEventPublisher == null);
            return tcpEventPublisher;
        }

        public void establishConnection() {
            AsyncEventPublisher.this.log.info((Object)(AsyncEventPublisher.this.logPrefix + "Requesting a " + AsyncEventPublisher.this.destinationTypeString + " for " + AsyncEventPublisher.this.thisHostIp));
            do {
                String endpointHostPort;
                if ((endpointHostPort = this.getEndpointFromManagerService()) == null) continue;
                AsyncEventPublisher.this.tcpEventPublisher = this.connectToEndpoint(endpointHostPort, 3);
            } while (AsyncEventPublisher.this.tcpEventPublisher == null);
        }

        @Override
        public void run() {
            this.establishConnection();
        }
    }

    public static enum DestinationType {
        STORM_RECEIVER,
        CEP_PUBLISHER;

    }
}

