/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.common.storm.component;

import backtype.storm.spout.SpoutOutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.topology.base.BaseRichSpout;
import backtype.storm.tuple.Fields;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.siddhi.core.ExecutionPlanRuntime;
import org.wso2.siddhi.core.SiddhiManager;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.stream.output.StreamCallback;

public class TriggerSpout
extends BaseRichSpout {
    public static final String TRIGGER_TIME_FIELD_NAME = "triggered_time";
    String triggerId;
    String triggerDefinition;
    SpoutOutputCollector outputCollector;
    private transient SiddhiManager siddhiManager;
    private transient ExecutionPlanRuntime executionPlanRuntime;
    private static transient Log log = LogFactory.getLog(TriggerSpout.class);
    String logPrefix;

    public TriggerSpout(String triggerId, String triggerDefinition, String executionPlanName, int tenantId) {
        this.triggerId = triggerId;
        this.triggerDefinition = triggerDefinition;
        this.logPrefix = "[" + tenantId + ":" + executionPlanName + ":" + triggerId + "] ";
    }

    public void declareOutputFields(OutputFieldsDeclarer outputFieldsDeclarer) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(0, "_timestamp");
        list.add(0, TRIGGER_TIME_FIELD_NAME);
        Fields fields = new Fields(list);
        outputFieldsDeclarer.declareStream(this.triggerId, fields);
    }

    public void open(Map map, TopologyContext topologyContext, SpoutOutputCollector spoutOutputCollector) {
        this.outputCollector = spoutOutputCollector;
        this.siddhiManager = new SiddhiManager();
        String fullQueryExpression = this.triggerDefinition;
        this.executionPlanRuntime = this.siddhiManager.createExecutionPlanRuntime(fullQueryExpression);
        this.executionPlanRuntime.addCallback(this.triggerId, new StreamCallback(){

            public void receive(Event[] events) {
                for (Event event : events) {
                    Object[] eventData = Arrays.copyOf(event.getData(), event.getData().length + 1);
                    eventData[event.getData().length] = event.getTimestamp();
                    TriggerSpout.this.outputCollector.emit(TriggerSpout.this.triggerId, Arrays.asList(eventData));
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)(TriggerSpout.this.logPrefix + "Trigger Event Emitted :" + Arrays.deepToString(eventData)));
                }
            }
        });
        this.executionPlanRuntime.start();
    }

    public void nextTuple() {
    }
}

