/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.common.storm.component;

import backtype.storm.task.TopologyContext;
import backtype.storm.topology.BasicOutputCollector;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.topology.base.BaseBasicBolt;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.processor.common.util.ThroughputProbe;
import org.wso2.carbon.event.processor.manager.commons.utils.Utils;
import org.wso2.siddhi.core.ExecutionPlanRuntime;
import org.wso2.siddhi.core.SiddhiManager;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.stream.input.InputHandler;
import org.wso2.siddhi.core.stream.output.StreamCallback;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.definition.StreamDefinition;
import org.wso2.siddhi.query.compiler.SiddhiCompiler;

public class SiddhiBolt
extends BaseBasicBolt {
    private final String name;
    private transient Log log = LogFactory.getLog(SiddhiBolt.class);
    private transient SiddhiManager siddhiManager;
    private List<String> outputStreamDefinitions;
    private List<String> inputStreamDefinitions;
    private String query;
    private BasicOutputCollector collector;
    private String logPrefix;
    private transient ExecutionPlanRuntime executionPlanRuntime;
    private transient ThroughputProbe inputThroughputProbe;
    private transient ThroughputProbe emitThroughputProbe;

    public SiddhiBolt(String name, List<String> inputStreamDefinitions, String query, List<String> outputSiddhiDefinitions, String executionPlanName, int tenantId) {
        this.inputStreamDefinitions = inputStreamDefinitions;
        this.query = query;
        this.outputStreamDefinitions = outputSiddhiDefinitions;
        this.name = name;
        this.logPrefix = "[" + tenantId + ":" + executionPlanName + ":" + name + "] ";
        this.init();
    }

    private void init() {
        this.log = LogFactory.getLog(SiddhiBolt.class);
        this.inputThroughputProbe = new ThroughputProbe(this.logPrefix + "-IN", 10);
        this.emitThroughputProbe = new ThroughputProbe(this.logPrefix + " -EMIT", 10);
        this.inputThroughputProbe.startSampling();
        this.emitThroughputProbe.startSampling();
        this.siddhiManager = new SiddhiManager();
        String fullQueryExpression = Utils.constructQueryExpression(this.inputStreamDefinitions, this.outputStreamDefinitions, (String)this.query);
        this.executionPlanRuntime = this.siddhiManager.createExecutionPlanRuntime(fullQueryExpression);
        for (String outputStreamDefinition : this.outputStreamDefinitions) {
            final StreamDefinition outputSiddhiDefinition = SiddhiCompiler.parseStreamDefinition((String)outputStreamDefinition);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(this.logPrefix + " Adding callback for stream: " + outputSiddhiDefinition.getId()));
            }
            this.executionPlanRuntime.addCallback(outputSiddhiDefinition.getId(), new StreamCallback(){

                public void receive(Event[] events) {
                    for (Event event : events) {
                        Object[] eventData = Arrays.copyOf(event.getData(), event.getData().length + 1);
                        eventData[event.getData().length] = event.getTimestamp();
                        SiddhiBolt.this.collector.emit(outputSiddhiDefinition.getId(), Arrays.asList(eventData));
                        if (SiddhiBolt.this.log.isDebugEnabled()) {
                            SiddhiBolt.this.log.debug((Object)(SiddhiBolt.this.logPrefix + "Emitted Event:" + outputSiddhiDefinition.getId() + ":" + Arrays.deepToString(eventData) + "@" + event.getTimestamp()));
                        }
                        SiddhiBolt.this.emitThroughputProbe.update();
                    }
                }
            });
        }
        this.executionPlanRuntime.start();
    }

    public void prepare(Map stormConf, TopologyContext context) {
        super.prepare(stormConf, context);
    }

    public void execute(Tuple tuple, BasicOutputCollector collector) {
        if (this.siddhiManager == null) {
            this.init();
        }
        this.inputThroughputProbe.update();
        try {
            this.collector = collector;
            InputHandler inputHandler = this.executionPlanRuntime.getInputHandler(tuple.getSourceStreamId());
            Object[] dataArray = tuple.getValues().toArray();
            long timestamp = (Long)dataArray[dataArray.length - 1];
            dataArray = ArrayUtils.remove((Object[])dataArray, (int)(dataArray.length - 1));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(this.logPrefix + "Received Event: " + tuple.getSourceStreamId() + ":" + Arrays.deepToString(dataArray) + "@" + timestamp));
            }
            if (inputHandler != null) {
                inputHandler.send(timestamp, dataArray);
            } else {
                this.log.warn((Object)(this.logPrefix + "Event received for unknown stream " + tuple.getSourceStreamId() + ". Discarding the Event: " + tuple.getSourceStreamId() + ":" + Arrays.deepToString(dataArray) + "@" + timestamp));
            }
        }
        catch (InterruptedException e) {
            this.log.error((Object)e);
        }
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        if (this.siddhiManager == null) {
            this.init();
        }
        for (String outputStreamDefinition : this.outputStreamDefinitions) {
            StreamDefinition siddhiOutputDefinition = SiddhiCompiler.parseStreamDefinition((String)outputStreamDefinition);
            if (outputStreamDefinition == null) {
                throw new RuntimeException(this.logPrefix + "Cannot find exported stream : " + siddhiOutputDefinition.getId());
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add(0, "_timestamp");
            for (Attribute attribute : siddhiOutputDefinition.getAttributeList()) {
                list.add(attribute.getName());
            }
            Fields fields = new Fields(list);
            declarer.declareStream(siddhiOutputDefinition.getId(), fields);
            this.log.info((Object)(this.logPrefix + "Declaring output field for stream :" + siddhiOutputDefinition.getId()));
        }
    }
}

