/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.common.storm.component;

import backtype.storm.spout.SpoutOutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.topology.base.BaseRichSpout;
import backtype.storm.tuple.Fields;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.wso2.carbon.event.processor.common.storm.event.Event;
import org.wso2.carbon.event.processor.common.storm.manager.service.StormManagerService;
import org.wso2.carbon.event.processor.common.util.ThroughputProbe;
import org.wso2.carbon.event.processor.manager.commons.transport.server.StreamCallback;
import org.wso2.carbon.event.processor.manager.commons.transport.server.TCPEventServer;
import org.wso2.carbon.event.processor.manager.commons.transport.server.TCPEventServerConfig;
import org.wso2.carbon.event.processor.manager.commons.utils.HostAndPort;
import org.wso2.carbon.event.processor.manager.commons.utils.Utils;
import org.wso2.carbon.event.processor.manager.core.config.DistributedConfiguration;
import org.wso2.siddhi.query.api.definition.StreamDefinition;
import org.wso2.siddhi.query.compiler.SiddhiCompiler;

public class EventReceiverSpout
extends BaseRichSpout
implements StreamCallback {
    private static transient Log log = LogFactory.getLog(EventReceiverSpout.class);
    private int listeningPort;
    private String thisHostIp;
    private DistributedConfiguration stormDeploymentConfig;
    private List<StreamDefinition> incomingStreamDefinitions;
    private TCPEventServer tcpEventServer;
    private List<String> incomingStreamIDs = new ArrayList<String>();
    private transient LinkedBlockingQueue<Event> storedEvents = null;
    private SpoutOutputCollector spoutOutputCollector = null;
    private String executionPlanName;
    private int tenantId = -1234;
    private String logPrefix;
    private int heartbeatInterval;
    private transient ThroughputProbe inputThroughputProbe;
    private transient ThroughputProbe outputThroughputProbe;

    public EventReceiverSpout(DistributedConfiguration stormDeploymentConfig, List<String> incomingStreamDefinitions, String executionPlanName, int tenantId, int heartbeatInterval) {
        this.incomingStreamDefinitions = new ArrayList<StreamDefinition>(incomingStreamDefinitions.size());
        this.stormDeploymentConfig = stormDeploymentConfig;
        this.executionPlanName = executionPlanName;
        this.tenantId = tenantId;
        this.heartbeatInterval = heartbeatInterval;
        for (String definition : incomingStreamDefinitions) {
            this.incomingStreamDefinitions.add(SiddhiCompiler.parseStreamDefinition((String)definition));
        }
        this.logPrefix = "[" + tenantId + ":" + executionPlanName + ":EventReceiverSpout] ";
    }

    public void declareOutputFields(OutputFieldsDeclarer outputFieldsDeclarer) {
        for (StreamDefinition siddhiStreamDefinition : this.incomingStreamDefinitions) {
            ArrayList<String> attributeList = new ArrayList<String>(Arrays.asList(siddhiStreamDefinition.getAttributeNameArray()));
            attributeList.add(0, "_timestamp");
            Fields fields = new Fields(attributeList);
            outputFieldsDeclarer.declareStream(siddhiStreamDefinition.getId(), fields);
            this.incomingStreamIDs.add(siddhiStreamDefinition.getId());
            log.info((Object)(this.logPrefix + "Declaring output fields for stream : " + siddhiStreamDefinition.getId()));
        }
    }

    public void open(Map map, TopologyContext topologyContext, SpoutOutputCollector spoutOutputCollector) {
        this.spoutOutputCollector = spoutOutputCollector;
        this.storedEvents = new LinkedBlockingQueue(this.stormDeploymentConfig.getStormSpoutBufferSize());
        this.inputThroughputProbe = new ThroughputProbe(this.logPrefix + "-IN", 10);
        this.outputThroughputProbe = new ThroughputProbe(this.logPrefix + " -OUT", 10);
        this.inputThroughputProbe.startSampling();
        this.outputThroughputProbe.startSampling();
        try {
            this.thisHostIp = Utils.findAddress((String)"localhost");
            this.listeningPort = this.findPort(this.thisHostIp);
            TCPEventServerConfig configs = new TCPEventServerConfig(this.thisHostIp, this.listeningPort);
            this.tcpEventServer = new TCPEventServer(configs, (StreamCallback)this, null);
            for (StreamDefinition siddhiStreamDefinition : this.incomingStreamDefinitions) {
                this.tcpEventServer.addStreamDefinition(siddhiStreamDefinition);
            }
            this.tcpEventServer.start();
            log.info((Object)(this.logPrefix + "EventReceiverSpout starting to listen for events on port " + this.listeningPort));
            Thread thread = new Thread(new Registrar());
            thread.start();
        }
        catch (Throwable e) {
            log.error((Object)(this.logPrefix + "Error starting event listener for spout: " + e.getMessage()), e);
        }
    }

    public void nextTuple() {
        Event event = this.storedEvents.poll();
        if (event != null) {
            String siddhiStreamName = event.getStreamId();
            if (this.incomingStreamIDs.contains(siddhiStreamName)) {
                Object[] eventData = Arrays.copyOf(event.getData(), event.getData().length + 1);
                eventData[event.getData().length] = event.getTimestamp();
                this.spoutOutputCollector.emit(siddhiStreamName, Arrays.asList(eventData));
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.logPrefix + "Emitted Event: " + siddhiStreamName + ":" + Arrays.deepToString(eventData) + "@" + event.getTimestamp()));
                }
                this.outputThroughputProbe.update();
            } else {
                log.warn((Object)(this.logPrefix + "Event received for unknown stream : " + siddhiStreamName));
            }
        }
    }

    private int findPort(String host) throws Exception {
        for (int i = this.stormDeploymentConfig.getTransportMinPort(); i <= this.stormDeploymentConfig.getTransportMaxPort(); ++i) {
            if (Utils.isPortUsed((int)i, (String)host)) continue;
            return i;
        }
        throw new Exception("Cannot find free port in range " + this.stormDeploymentConfig.getTransportMinPort() + "~" + this.stormDeploymentConfig.getTransportMaxPort());
    }

    public void receive(String streamId, long timestamp, Object[] eventData, Map<String, String> arbitraryMapData) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.logPrefix + "Received Event: " + streamId + ":" + Arrays.deepToString(eventData) + "@" + timestamp));
        }
        try {
            this.storedEvents.put(new Event(timestamp, eventData, streamId));
            this.inputThroughputProbe.update();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    class Registrar
    implements Runnable {
        private String managerHost;
        private int managerPort;

        Registrar() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            log.info((Object)(EventReceiverSpout.this.logPrefix + "Registering Event Receiver Spout for " + EventReceiverSpout.this.thisHostIp + ":" + EventReceiverSpout.this.listeningPort));
            while (true) {
                block13: {
                    if (this.registerStormReceiverWithStormMangerService()) {
                        while (true) {
                            TSocket transport = null;
                            try {
                                transport = new TSocket(this.managerHost, this.managerPort);
                                TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
                                transport.open();
                                StormManagerService.Client client = new StormManagerService.Client((TProtocol)protocol);
                                client.registerStormReceiver(EventReceiverSpout.this.tenantId, EventReceiverSpout.this.executionPlanName, EventReceiverSpout.this.thisHostIp, EventReceiverSpout.this.listeningPort);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)(EventReceiverSpout.this.logPrefix + "Successfully registered Event Receiver Spout for " + EventReceiverSpout.this.thisHostIp + ":" + EventReceiverSpout.this.listeningPort));
                                }
                                try {
                                    Thread.sleep(EventReceiverSpout.this.heartbeatInterval);
                                }
                                catch (InterruptedException e1) {
                                    if (transport == null) continue;
                                    transport.close();
                                }
                                continue;
                            }
                            catch (Exception e) {
                                log.error((Object)(EventReceiverSpout.this.logPrefix + "Error in registering Event Receiver Spout for " + EventReceiverSpout.this.thisHostIp + ":" + EventReceiverSpout.this.listeningPort + " with manager " + this.managerHost + ":" + this.managerPort + ". Trying next manager after " + EventReceiverSpout.this.heartbeatInterval + "ms"), (Throwable)e);
                                break block13;
                            }
                            finally {
                                if (transport == null) continue;
                                transport.close();
                                continue;
                            }
                            break;
                        }
                    }
                    log.error((Object)(EventReceiverSpout.this.logPrefix + "Error registering Event Receiver Spout with given set of manager nodes. Retrying after " + EventReceiverSpout.this.heartbeatInterval + "ms"));
                }
                try {
                    Thread.sleep(EventReceiverSpout.this.heartbeatInterval);
                }
                catch (InterruptedException e1) {
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean registerStormReceiverWithStormMangerService() {
            TSocket transport = null;
            for (HostAndPort endpoint : EventReceiverSpout.this.stormDeploymentConfig.getManagers()) {
                try {
                    transport = new TSocket(endpoint.getHostName(), endpoint.getPort());
                    TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
                    transport.open();
                    StormManagerService.Client client = new StormManagerService.Client((TProtocol)protocol);
                    client.registerStormReceiver(EventReceiverSpout.this.tenantId, EventReceiverSpout.this.executionPlanName, EventReceiverSpout.this.thisHostIp, EventReceiverSpout.this.listeningPort);
                    log.info((Object)(EventReceiverSpout.this.logPrefix + "Successfully registered Event Receiver Spout for " + EventReceiverSpout.this.thisHostIp + ":" + EventReceiverSpout.this.listeningPort + " with manager service at " + endpoint.getHostName() + ":" + endpoint.getPort()));
                    this.managerHost = endpoint.getHostName();
                    this.managerPort = endpoint.getPort();
                    boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    log.error((Object)(EventReceiverSpout.this.logPrefix + "Error in registering Event Receiver Spout for " + EventReceiverSpout.this.thisHostIp + ":" + EventReceiverSpout.this.listeningPort + " with manager " + endpoint.getHostName() + ":" + endpoint.getPort() + ", Trying next manager."), (Throwable)e);
                }
                finally {
                    if (transport == null) continue;
                    transport.close();
                }
            }
            return false;
        }
    }
}

