/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.common.storm.component;

import backtype.storm.task.TopologyContext;
import backtype.storm.topology.BasicOutputCollector;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.topology.base.BaseBasicBolt;
import backtype.storm.tuple.Tuple;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.processor.common.storm.component.SiddhiBolt;
import org.wso2.carbon.event.processor.common.util.AsyncEventPublisher;
import org.wso2.carbon.event.processor.manager.commons.utils.Utils;
import org.wso2.carbon.event.processor.manager.core.config.DistributedConfiguration;
import org.wso2.siddhi.core.ExecutionPlanRuntime;
import org.wso2.siddhi.core.SiddhiManager;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.stream.output.StreamCallback;
import org.wso2.siddhi.query.api.definition.StreamDefinition;
import org.wso2.siddhi.query.compiler.SiddhiCompiler;

public class EventPublisherBolt
extends BaseBasicBolt {
    private transient Log log = LogFactory.getLog(EventPublisherBolt.class);
    private List<String> inputStreamDefinitions;
    private List<String> outputStreamDefinitions;
    private String query;
    private transient Map<String, StreamDefinition> streamIdToDefinitionMap;
    private transient AsyncEventPublisher asyncEventPublisher;
    private BasicOutputCollector collector;
    private String executionPlanName;
    private String logPrefix;
    private int tenantId = -1234;
    private DistributedConfiguration stormDeploymentConfig;
    private Boolean initialized = false;
    private transient SiddhiManager siddhiManager;
    private transient ExecutionPlanRuntime executionPlanRuntime;
    private int eventCount;
    private long batchStartTime;

    public EventPublisherBolt(DistributedConfiguration stormDeploymentConfig, List<String> inputStreamDefinitions, List<String> outputStreamDefinitions, String query, String executionPlanName, int tenantId) {
        this.stormDeploymentConfig = stormDeploymentConfig;
        this.inputStreamDefinitions = inputStreamDefinitions;
        this.outputStreamDefinitions = outputStreamDefinitions;
        this.query = query;
        this.executionPlanName = executionPlanName;
        this.tenantId = tenantId;
        this.logPrefix = "[" + tenantId + ":" + executionPlanName + ":EventPublisherBolt]";
    }

    public void execute(Tuple tuple, BasicOutputCollector basicOutputCollector) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.logPrefix + "Received Event: " + tuple.getSourceStreamId() + ":" + Arrays.deepToString(tuple.getValues().toArray())));
        }
        this.collector = basicOutputCollector;
        if (!this.initialized.booleanValue()) {
            this.init();
        }
        Object[] dataArray = tuple.getValues().toArray();
        long timestamp = (Long)dataArray[dataArray.length - 1];
        dataArray = ArrayUtils.remove((Object[])dataArray, (int)(dataArray.length - 1));
        StreamDefinition streamDefinition = this.streamIdToDefinitionMap.get(tuple.getSourceStreamId());
        if (streamDefinition != null) {
            this.asyncEventPublisher.sendEvent(dataArray, timestamp, tuple.getSourceStreamId());
        } else {
            this.log.warn((Object)(this.logPrefix + "Tuple received for unknown stream " + tuple.getSourceStreamId() + ". Discarding Event: " + tuple.getSourceStreamId() + ":" + Arrays.deepToString(dataArray) + "@" + timestamp));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.logPrefix + "Emitted Event: " + tuple.getSourceStreamId() + ":" + Arrays.deepToString(dataArray) + "@" + timestamp));
        }
    }

    public void declareOutputFields(OutputFieldsDeclarer outputFieldsDeclarer) {
    }

    public void prepare(Map stormConf, TopologyContext context) {
        super.prepare(stormConf, context);
        this.init();
    }

    private void init() {
        try {
            this.log = LogFactory.getLog(EventPublisherBolt.class);
            this.initialized = true;
            if (this.query != null && !this.query.isEmpty()) {
                this.siddhiManager = new SiddhiManager();
                this.eventCount = 0;
                this.batchStartTime = System.currentTimeMillis();
                this.log = LogFactory.getLog(SiddhiBolt.class);
                String fullQueryExpression = Utils.constructQueryExpression(this.inputStreamDefinitions, this.outputStreamDefinitions, (String)this.query);
                this.executionPlanRuntime = this.siddhiManager.createExecutionPlanRuntime(fullQueryExpression);
                for (String outputStreamDefinition : this.outputStreamDefinitions) {
                    final StreamDefinition outputSiddhiDefinition = SiddhiCompiler.parseStreamDefinition((String)outputStreamDefinition);
                    this.log.info((Object)(this.logPrefix + "Adding callback for stream:" + outputSiddhiDefinition.getId()));
                    this.executionPlanRuntime.addCallback(outputSiddhiDefinition.getId(), new StreamCallback(){

                        public void receive(Event[] events) {
                            for (Event event : events) {
                                Object[] eventData = Arrays.copyOf(event.getData(), event.getData().length + 1);
                                eventData[event.getData().length] = event.getTimestamp();
                                EventPublisherBolt.this.collector.emit(outputSiddhiDefinition.getId(), Arrays.asList(eventData));
                                if (!EventPublisherBolt.this.log.isDebugEnabled()) continue;
                                if (++EventPublisherBolt.this.eventCount % 10000 == 0) {
                                    double timeSpentInSecs = (double)(System.currentTimeMillis() - EventPublisherBolt.this.batchStartTime) / 1000.0;
                                    double throughput = 10000.0 / timeSpentInSecs;
                                    EventPublisherBolt.this.log.debug((Object)(EventPublisherBolt.this.logPrefix + "Processed 10000 events in " + timeSpentInSecs + " seconds, throughput : " + throughput + " events/sec. Stream : " + outputSiddhiDefinition.getId()));
                                    EventPublisherBolt.this.eventCount = 0;
                                    EventPublisherBolt.this.batchStartTime = System.currentTimeMillis();
                                }
                                EventPublisherBolt.this.log.debug((Object)(EventPublisherBolt.this.logPrefix + "Emitted Event:" + outputSiddhiDefinition.getId() + ":" + Arrays.deepToString(eventData) + "@" + event.getTimestamp()));
                            }
                        }
                    });
                }
                this.executionPlanRuntime.start();
            }
            this.streamIdToDefinitionMap = new HashMap<String, StreamDefinition>();
            for (String outputStreamDefinition : this.outputStreamDefinitions) {
                StreamDefinition siddhiDefinition = SiddhiCompiler.parseStreamDefinition((String)outputStreamDefinition);
                this.streamIdToDefinitionMap.put(siddhiDefinition.getId(), siddhiDefinition);
            }
            this.asyncEventPublisher = new AsyncEventPublisher(AsyncEventPublisher.DestinationType.CEP_PUBLISHER, new HashSet<StreamDefinition>(this.streamIdToDefinitionMap.values()), this.stormDeploymentConfig.getManagers(), this.executionPlanName, this.tenantId, this.stormDeploymentConfig, null);
            this.asyncEventPublisher.initializeConnection(false);
        }
        catch (Throwable e) {
            this.log.error((Object)(this.logPrefix + "Error starting event publisher bolt: " + e.getMessage()), e);
        }
    }
}

