/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.api.model.subscription;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.apimgt.api.model.subscription.CacheableEntity;
import org.wso2.carbon.apimgt.api.model.subscription.Verb;

public class Resource
implements CacheableEntity<String> {
    private String urlPattern;
    private int apiId;
    private Map<String, Verb> httpVerbs = new HashMap<String, Verb>();

    public Resource() {
    }

    public Resource(int apiId, String urlPattern) {
        this();
        this.apiId = apiId;
        this.urlPattern = urlPattern;
    }

    public List<Verb> getAllVerbs() {
        return Arrays.asList(this.httpVerbs.values().toArray(new Verb[0]));
    }

    public int getApiId() {
        return this.apiId;
    }

    public void setApiId(int apiId) {
        this.apiId = apiId;
    }

    public String getUrlPattern() {
        return this.urlPattern;
    }

    public void setUrlPattern(String urlPattern) {
        this.urlPattern = urlPattern;
    }

    public void addVerb(Verb resourceVerb) {
        this.httpVerbs.put(resourceVerb.getHttpVerb(), resourceVerb);
    }

    public Verb getVerb(String httpVerb) {
        return this.httpVerbs.get(httpVerb);
    }

    @Override
    public String getCacheKey() {
        return this.urlPattern + "." + this.apiId;
    }
}

