/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.api.model.subscription;

import java.util.HashMap;
import java.util.Map;
import org.wso2.carbon.apimgt.api.model.subscription.CacheableEntity;
import org.wso2.carbon.apimgt.api.model.subscription.URLMapping;

public class API
implements CacheableEntity<String> {
    private String apiUUID;
    private int apiId = -1;
    private String provider = null;
    private String name = null;
    private String version = null;
    private String context = null;
    private String policy = null;
    private String apiType = null;
    private Boolean isDefaultVersion = false;
    private String environment;
    private String status;
    private String revision;
    private Map<String, URLMapping> resources = new HashMap<String, URLMapping>();

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void addResource(URLMapping urlMapping) {
        String key = urlMapping.getUrlPattern().concat(":").concat(urlMapping.getHttpMethod());
        this.resources.put(key, urlMapping);
    }

    public boolean removeResource(URLMapping urlMapping) {
        String key = urlMapping.getUrlPattern().concat(":").concat(urlMapping.getHttpMethod());
        this.resources.remove(key);
        return true;
    }

    public int getApiId() {
        return this.apiId;
    }

    public void setApiId(int apiId) {
        this.apiId = apiId;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getPolicy() {
        return this.policy;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    @Override
    public String getCacheKey() {
        return this.context + ":" + this.version;
    }

    public String getApiType() {
        return this.apiType;
    }

    public void setApiType(String apiType) {
        this.apiType = apiType;
    }

    public URLMapping getResource(String urlPattern, String httpMethod) {
        String key = urlPattern.concat(":").concat(httpMethod);
        return this.resources.get(key);
    }

    public Map<String, URLMapping> getAllResources() {
        return this.resources;
    }

    public Boolean isDefaultVersion() {
        return this.isDefaultVersion;
    }

    public void setIsDefaultVersion(Boolean defaultVersion) {
        this.isDefaultVersion = defaultVersion;
    }

    public String getApiUUID() {
        return this.apiUUID;
    }

    public void setApiUUID(String apiUUID) {
        this.apiUUID = apiUUID;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }
}

