/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.api.model.policy;

import org.wso2.carbon.apimgt.api.model.policy.Condition;

public class IPRangeCondition
extends Condition {
    private String startingIP;
    private String endingIP;

    public IPRangeCondition() {
        this.setType("IPRange");
        this.queryAttributeName = "cast(map:get(propertiesMap,'ip'),'string')";
    }

    public String getStartingIP() {
        return this.startingIP;
    }

    public void setStartingIP(String startingIP) {
        this.startingIP = startingIP;
    }

    public String getEndingIP() {
        return this.endingIP;
    }

    public void setEndingIP(String endingIP) {
        this.endingIP = endingIP;
    }

    public long ipToLong(String ip) {
        long ipAddressinLong = 0L;
        if (ip != null) {
            String[] ipAddressArray = ip.split("\\.");
            for (int i = 0; i < ipAddressArray.length; ++i) {
                int power = 3 - i;
                long ipAddress = Long.parseLong(ipAddressArray[i]);
                ipAddressinLong = (long)((double)ipAddressinLong + (double)ipAddress * Math.pow(256.0, power));
            }
        }
        return ipAddressinLong;
    }

    @Override
    public String getCondition() {
        long ipStart = this.ipToLong(this.getStartingIP());
        long ipEnd = this.ipToLong(this.getEndingIP());
        String condition = "('" + ipStart + "'" + "<=" + this.getQueryAttributeName() + " AND " + "'" + ipEnd + "'" + ">=" + this.getQueryAttributeName() + ")";
        if (this.isInvertCondition()) {
            condition = "NOT" + condition;
        }
        return condition;
    }

    @Override
    public String getNullCondition() {
        return null;
    }

    @Override
    public String toString() {
        return "IPRangeCondition [startingIP=" + this.startingIP + ", endingIP=" + this.endingIP + ", toString()=" + super.toString() + "]";
    }
}

