/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.api.model.policy;

import java.math.BigInteger;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.wso2.carbon.apimgt.api.model.policy.Condition;

public class IPCondition
extends Condition {
    private String specificIP;
    private String startingIP;
    private String endingIP;

    public IPCondition(String conditionType) {
        this.setType(conditionType);
        this.queryAttributeName = "cast(map:get(propertiesMap,'ip'),'Long')";
    }

    public String getSpecificIP() {
        return this.specificIP;
    }

    public void setSpecificIP(String specificIP) {
        this.specificIP = specificIP;
    }

    public String getStartingIP() {
        return this.startingIP;
    }

    public void setStartingIP(String startingIP) {
        this.startingIP = startingIP;
    }

    public String getEndingIP() {
        return this.endingIP;
    }

    public void setEndingIP(String endingIP) {
        this.endingIP = endingIP;
    }

    public long ipToLong(String ip) {
        long ipAddressinLong = 0L;
        if (ip != null) {
            String[] ipAddressArray = ip.split("\\.");
            for (int i = 0; i < ipAddressArray.length; ++i) {
                int power = 3 - i;
                long ipAddress = Long.parseLong(ipAddressArray[i]);
                ipAddressinLong = (long)((double)ipAddressinLong + (double)ipAddress * Math.pow(256.0, power));
            }
        }
        return ipAddressinLong;
    }

    private BigInteger ipToBigInteger(String ip) {
        try {
            InetAddress address = InetAddress.getByName(ip);
            byte[] bytes = address.getAddress();
            return new BigInteger(1, bytes);
        }
        catch (UnknownHostException unknownHostException) {
            return BigInteger.ZERO;
        }
    }

    public static boolean isIPv6Address(String ip) {
        try {
            InetAddress address = InetAddress.getByName(ip);
            if (address instanceof Inet6Address) {
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public String getCondition() {
        String condition = null;
        if ("IPSpecific".equalsIgnoreCase(this.getType())) {
            if (IPCondition.isIPv6Address(this.specificIP)) {
                BigInteger ip = this.ipToBigInteger(this.getSpecificIP());
                condition = "(" + this.getQueryAttributeNameForIPv6(ip) + "==" + 0 + ")";
            } else {
                long ip = this.ipToLong(this.getSpecificIP());
                condition = "(" + this.getQueryAttributeName() + "==" + ip + "l" + ")";
            }
            if (this.isInvertCondition()) {
                condition = "NOT" + condition;
            }
        }
        if ("IPRange".equalsIgnoreCase(this.getType())) {
            if (IPCondition.isIPv6Address(this.startingIP) && IPCondition.isIPv6Address(this.endingIP)) {
                BigInteger ipStart = this.ipToBigInteger(this.getStartingIP());
                BigInteger ipEnd = this.ipToBigInteger(this.getEndingIP());
                condition = "(" + this.getQueryAttributeNameForIPv6(ipStart) + ">=" + 0 + " AND " + this.getQueryAttributeNameForIPv6(ipEnd) + "<=" + 0 + ")";
            } else {
                long ipStart = this.ipToLong(this.getStartingIP());
                long ipEnd = this.ipToLong(this.getEndingIP());
                condition = "(" + ipStart + "l" + "<=" + this.getQueryAttributeName() + " AND " + ipEnd + "l" + ">=" + this.getQueryAttributeName() + ")";
            }
            if (this.isInvertCondition()) {
                condition = "NOT" + condition;
            }
        }
        return condition;
    }

    @Override
    public String getNullCondition() {
        return null;
    }

    @Override
    public String toString() {
        String msg = "";
        if ("IPSpecific".equalsIgnoreCase(this.getType())) {
            msg = "IPCondition [specificIP=" + this.specificIP + ", toString()=" + super.toString() + "]";
        }
        if ("IPRange".equalsIgnoreCase(this.getType())) {
            msg = "IPRangeCondition [startingIP=" + this.startingIP + ", endingIP=" + this.endingIP + ", toString()=" + super.toString() + "]";
        }
        return msg;
    }

    private String getQueryAttributeNameForIPv6(BigInteger ip) {
        return "throttler:bigIntcmp(map:get(propertiesMap,'ipv6'), '" + ip + "'" + ")";
    }
}

