/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.api.model;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.wso2.carbon.apimgt.api.APIManagementException;

public class VHost {
    private String host;
    private String httpContext = "";
    private Integer httpPort = 80;
    private Integer httpsPort = 443;
    private Integer wsPort = 9099;
    private Integer wssPort = 8099;
    private Integer websubHttpPort = 9021;
    private Integer websubHttpsPort = 8021;
    public static final int DEFAULT_HTTP_PORT = 80;
    public static final int DEFAULT_HTTPS_PORT = 443;
    public static final int DEFAULT_WS_PORT = 9099;
    public static final int DEFAULT_WSS_PORT = 8099;
    public static final int DEFAULT_WEBSUB_HTTP_PORT = 9021;
    public static final int DEFAULT_WEBSUB_HTTPS_PORT = 8021;
    public static final String HTTP_PROTOCOL = "http";
    public static final String HTTPS_PROTOCOL = "https";
    public static final String WS_PROTOCOL = "ws";
    public static final String WSS_PROTOCOL = "wss";
    public static final String PROTOCOL_SEPARATOR = "://";
    private static final String WEBSUB_HTTP_PROTOCOL = "websub_http";
    private static final String WEBSUB_HTTPS_PROTOCOL = "websub_https";

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHttpContext() {
        return this.httpContext;
    }

    public void setHttpContext(String httpContext) {
        this.httpContext = httpContext;
    }

    public Integer getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(Integer httpPort) {
        this.httpPort = httpPort;
    }

    public Integer getHttpsPort() {
        return this.httpsPort;
    }

    public void setHttpsPort(Integer httpsPort) {
        this.httpsPort = httpsPort;
    }

    public Integer getWsPort() {
        return this.wsPort;
    }

    public void setWsPort(Integer wsPort) {
        this.wsPort = wsPort;
    }

    public Integer getWssPort() {
        return this.wssPort;
    }

    public void setWssPort(Integer wssPort) {
        this.wssPort = wssPort;
    }

    public Integer getWebsubHttpPort() {
        return this.websubHttpPort;
    }

    public void setWebsubHttpPort(Integer websubHttpPort) {
        this.websubHttpPort = websubHttpPort;
    }

    public Integer getWebsubHttpsPort() {
        return this.websubHttpsPort;
    }

    public void setWebsubHttpsPort(Integer websubHttpsPort) {
        this.websubHttpsPort = websubHttpsPort;
    }

    public String getHttpUrl() {
        return this.getUrl(HTTP_PROTOCOL, this.httpPort == 80 ? "" : ":" + this.httpPort, this.httpContext);
    }

    public String getHttpsUrl() {
        return this.getUrl(HTTPS_PROTOCOL, this.httpsPort == 443 ? "" : ":" + this.httpsPort, this.httpContext);
    }

    public String getWsUrl() {
        return this.getUrl(WS_PROTOCOL, this.wsPort == 80 ? "" : ":" + this.wsPort, "");
    }

    public String getWssUrl() {
        return this.getUrl(WSS_PROTOCOL, this.wssPort == 443 ? "" : ":" + this.wssPort, "");
    }

    private String getUrl(String protocol, String port, String context) {
        if (StringUtils.isNotEmpty((CharSequence)context) && !context.startsWith("/")) {
            context = "/" + context;
        }
        return String.format("%s://%s%s%s", protocol, this.host, port, context);
    }

    public static VHost fromEndpointUrls(String[] endpoints) throws APIManagementException {
        VHost vhost = new VHost();
        for (String endpoint : endpoints) {
            if (StringUtils.isEmpty((CharSequence)endpoint)) continue;
            String[] elem = endpoint.split(PROTOCOL_SEPARATOR);
            if (elem.length != 2) {
                throw new APIManagementException("Error reading gateway environment endpoint URL");
            }
            try {
                switch (elem[0]) {
                    case "https": {
                        URL url = new URL(endpoint);
                        vhost.setHttpsPort(url.getPort() < 0 ? 443 : url.getPort());
                        vhost.setHost(url.getHost());
                        vhost.setHttpContext(url.getPath());
                        break;
                    }
                    case "http": {
                        URL url = new URL(endpoint);
                        vhost.setHttpPort(url.getPort() < 0 ? 80 : url.getPort());
                        String host = StringUtils.isNotEmpty((CharSequence)vhost.getHost()) ? vhost.getHost() : url.getHost();
                        vhost.setHost(host);
                        String httpContext = StringUtils.isNotEmpty((CharSequence)vhost.getHttpContext()) ? vhost.getHttpContext() : url.getPath();
                        vhost.setHttpContext(httpContext);
                        break;
                    }
                    case "wss": {
                        URL url = new URL("https://" + elem[1]);
                        vhost.setWssPort(url.getPort() < 0 ? 8099 : url.getPort());
                        break;
                    }
                    case "ws": {
                        URL url = new URL("http://" + elem[1]);
                        vhost.setWsPort(url.getPort() < 0 ? 9099 : url.getPort());
                        break;
                    }
                    case "websub_http": {
                        URL url = new URL("http://" + elem[1]);
                        vhost.setWebsubHttpPort(url.getPort() < 0 ? 9021 : url.getPort());
                        break;
                    }
                    case "websub_https": {
                        URL url = new URL("https://" + elem[1]);
                        vhost.setWebsubHttpsPort(url.getPort() < 0 ? 8021 : url.getPort());
                    }
                }
            }
            catch (MalformedURLException e) {
                throw new APIManagementException("Error reading gateway environment endpoint URL", e);
            }
        }
        if (StringUtils.isEmpty((CharSequence)vhost.getHost())) {
            throw new APIManagementException("Error while building VHost, missing required HTTP or HTTPS endpoint");
        }
        return vhost;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        VHost vHost = (VHost)obj;
        return StringUtils.equals((CharSequence)vHost.host, (CharSequence)this.host) && StringUtils.equals((CharSequence)vHost.httpContext, (CharSequence)this.httpContext) && vHost.httpPort.equals(this.httpPort) && vHost.httpsPort.equals(this.httpsPort) && vHost.wsPort.equals(this.wsPort) && vHost.wssPort.equals(this.wssPort);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.httpContext == null ? 0 : this.httpContext.hashCode());
        result = 31 * result + this.httpPort;
        result = 31 * result + this.httpsPort;
        result = 31 * result + this.wsPort;
        result = 31 * result + this.wssPort;
        return result;
    }
}

