/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.simple.JSONValue;
import org.wso2.carbon.apimgt.api.dto.ConditionGroupDTO;
import org.wso2.carbon.apimgt.api.model.APIProductIdentifier;
import org.wso2.carbon.apimgt.api.model.Scope;

public class URITemplate
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String uriTemplate;
    private String resourceURI;
    private String resourceSandboxURI;
    private String httpVerb;
    private String authType;
    private LinkedHashSet<String> httpVerbs = new LinkedHashSet();
    private List<String> authTypes = new ArrayList<String>();
    private List<String> throttlingConditions = new ArrayList<String>();
    private String applicableLevel;
    private String throttlingTier;
    private List<String> throttlingTiers = new ArrayList<String>();
    private Scope scope;
    private String mediationScript;
    private List<Scope> scopes = new ArrayList<Scope>();
    private Map<String, String> mediationScripts = new HashMap<String, String>();
    private ConditionGroupDTO[] conditionGroups;
    private int id;
    private Set<APIProductIdentifier> usedByProducts = new HashSet<APIProductIdentifier>();
    private String amznResourceName;
    private int amznResourceTimeout;

    public ConditionGroupDTO[] getConditionGroups() {
        return this.conditionGroups;
    }

    public void setConditionGroups(ConditionGroupDTO[] conditionGroups) {
        this.conditionGroups = conditionGroups;
    }

    public String getMediationScript() {
        return this.mediationScript;
    }

    public List<String> getThrottlingConditions() {
        return this.throttlingConditions;
    }

    public void setThrottlingConditions(List<String> throttlingConditions) {
        this.throttlingConditions = throttlingConditions;
    }

    public void setMediationScript(String mediationScript) {
        this.mediationScript = mediationScript;
    }

    public void setMediationScripts(String method, String mediationScript) {
        if (mediationScript != null && !mediationScript.trim().equals("") && !mediationScript.trim().equals("null")) {
            this.mediationScripts.put(method, mediationScript);
        }
    }

    public String getAggregatedMediationScript() {
        if (this.mediationScripts.isEmpty()) {
            return "null";
        }
        if (this.mediationScripts.size() == 1 && this.httpVerbs.size() == 1) {
            return this.mediationScript;
        }
        StringBuilder aggregatedScript = new StringBuilder();
        for (Map.Entry<String, String> entry : this.mediationScripts.entrySet()) {
            String httpMethod = entry.getKey();
            String mediationScript = entry.getValue();
            aggregatedScript.append("if (mc.getProperty('REST_METHOD') == '").append(httpMethod).append("'){");
            aggregatedScript.append(mediationScript);
            aggregatedScript.append("}");
        }
        return aggregatedScript.toString();
    }

    public String getThrottlingTier() {
        return this.throttlingTier;
    }

    public void setThrottlingTier(String throttlingTier) {
        this.throttlingTier = throttlingTier;
    }

    public List<String> getThrottlingTiers() {
        return this.throttlingTiers;
    }

    public void setThrottlingTiers(List<String> throttlingTiers) {
        this.throttlingTiers = throttlingTiers;
    }

    public String getHTTPVerb() {
        return this.httpVerb;
    }

    public void setHTTPVerb(String httpVerb) {
        this.httpVerb = httpVerb;
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public String getResourceURI() {
        return this.resourceURI;
    }

    public void setResourceURI(String resourceURI) {
        this.resourceURI = resourceURI;
    }

    public boolean isResourceURIExist() {
        return this.resourceURI != null;
    }

    public String getResourceSandboxURI() {
        return this.resourceSandboxURI;
    }

    public void setResourceSandboxURI(String resourceSandboxURI) {
        this.resourceSandboxURI = resourceSandboxURI;
    }

    public boolean isResourceSandboxURIExist() {
        return this.resourceSandboxURI != null;
    }

    public String getUriTemplate() {
        return this.uriTemplate;
    }

    public void setUriTemplate(String template) {
        this.uriTemplate = template;
    }

    public void setHttpVerbs(String httpVerb) {
        this.httpVerbs.add(httpVerb);
    }

    public LinkedHashSet<String> getHttpVerbs() {
        return this.httpVerbs;
    }

    public void setAuthTypes(String authType) {
        this.authTypes.add(authType);
    }

    public String getAuthTypes() {
        return this.authType;
    }

    public String getMethodsAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String method : this.httpVerbs) {
            stringBuilder.append(method).append(" ");
        }
        return stringBuilder.toString().trim();
    }

    public String getAuthTypeAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String authType : this.authTypes) {
            stringBuilder.append(authType).append(" ");
        }
        return stringBuilder.toString().trim();
    }

    public String getThrottlingConditionsAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String authType : this.throttlingConditions) {
            stringBuilder.append(authType).append(" ");
        }
        return stringBuilder.toString().trim();
    }

    public void setThrottlingTiers(String tier) {
        this.throttlingTiers.add(tier);
    }

    public String getThrottlingTiersAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String tier : this.throttlingTiers) {
            if (tier.contains(">")) {
                stringBuilder.append(tier.substring(0, tier.indexOf(">")).trim()).append(" ");
                continue;
            }
            stringBuilder.append(tier.trim()).append(" ");
        }
        return stringBuilder.toString().trim();
    }

    public boolean checkContentAwareFromThrottlingTiers() {
        String throttlingTierWithContentAware;
        if (!this.throttlingTiers.isEmpty() && (throttlingTierWithContentAware = this.throttlingTiers.get(0)) != null && throttlingTierWithContentAware.contains(">")) {
            String[] splitThrottlingTiers = throttlingTierWithContentAware.split(">");
            return Boolean.valueOf(splitThrottlingTiers[splitThrottlingTiers.length - 1]);
        }
        return false;
    }

    public Scope getScope() {
        return this.scope;
    }

    public List<Scope> getScopes() {
        return this.scopes;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public void setScopes(Scope scope) {
        this.scopes.add(scope);
    }

    public String getResourceMap() {
        LinkedHashMap verbs = new LinkedHashMap();
        int i = 0;
        for (String method : this.httpVerbs) {
            LinkedHashMap<String, String> verb = new LinkedHashMap<String, String>();
            verb.put("auth_type", this.authTypes.get(i));
            verb.put("throttling_tier", this.throttlingTiers.get(i));
            try {
                Scope tmpScope = this.scopes.get(i);
                if (tmpScope != null) {
                    verb.put("scope", tmpScope.getKey());
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            verbs.put(method, verb);
            ++i;
        }
        return JSONValue.toJSONString(verbs);
    }

    public String getApplicableLevel() {
        return this.applicableLevel;
    }

    public void setApplicableLevel(String applicableLevel) {
        this.applicableLevel = applicableLevel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        URITemplate that = (URITemplate)o;
        if (!this.uriTemplate.equals(that.uriTemplate)) {
            return false;
        }
        if (this.resourceURI != null ? !this.resourceURI.equals(that.resourceURI) : that.resourceURI != null) {
            return false;
        }
        if (this.resourceSandboxURI != null ? !this.resourceSandboxURI.equals(that.resourceSandboxURI) : that.resourceSandboxURI != null) {
            return false;
        }
        if (!this.httpVerb.equals(that.httpVerb)) {
            return false;
        }
        if (!this.authType.equals(that.authType)) {
            return false;
        }
        if (!this.httpVerbs.equals(that.httpVerbs)) {
            return false;
        }
        if (!this.authTypes.equals(that.authTypes)) {
            return false;
        }
        if (this.throttlingConditions != null ? !this.throttlingConditions.equals(that.throttlingConditions) : that.throttlingConditions != null) {
            return false;
        }
        if (this.applicableLevel != null ? !this.applicableLevel.equals(that.applicableLevel) : that.applicableLevel != null) {
            return false;
        }
        if (!this.throttlingTier.equals(that.throttlingTier)) {
            return false;
        }
        if (!this.throttlingTiers.equals(that.throttlingTiers)) {
            return false;
        }
        if (this.scope != null ? !this.scope.equals(that.scope) : that.scope != null) {
            return false;
        }
        if (this.mediationScript != null ? !this.mediationScript.equals(that.mediationScript) : that.mediationScript != null) {
            return false;
        }
        if (this.scopes != null ? !this.scopes.equals(that.scopes) : that.scopes != null) {
            return false;
        }
        if (this.mediationScripts != null ? !this.mediationScripts.equals(that.mediationScripts) : that.mediationScripts != null) {
            return false;
        }
        return Arrays.equals(this.conditionGroups, that.conditionGroups);
    }

    public int hashCode() {
        int result = this.uriTemplate.hashCode();
        result = 31 * result + (this.resourceURI != null ? this.resourceURI.hashCode() : 0);
        result = 31 * result + (this.resourceSandboxURI != null ? this.resourceSandboxURI.hashCode() : 0);
        result = 31 * result + (this.httpVerb != null ? this.httpVerb.hashCode() : 0);
        result = 31 * result + (this.authType != null ? this.authType.hashCode() : 0);
        result = 31 * result + (this.httpVerbs != null ? this.httpVerbs.hashCode() : 0);
        result = 31 * result + (this.authTypes != null ? this.authTypes.hashCode() : 0);
        result = 31 * result + (this.throttlingConditions != null ? this.throttlingConditions.hashCode() : 0);
        result = 31 * result + (this.applicableLevel != null ? this.applicableLevel.hashCode() : 0);
        result = 31 * result + (this.throttlingTier != null ? this.throttlingTier.hashCode() : 0);
        result = 31 * result + (this.throttlingTiers != null ? this.throttlingTiers.hashCode() : 0);
        result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
        result = 31 * result + (this.mediationScript != null ? this.mediationScript.hashCode() : 0);
        result = 31 * result + (this.scopes != null ? this.scopes.hashCode() : 0);
        result = 31 * result + (this.mediationScripts != null ? this.mediationScripts.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.conditionGroups);
        return result;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public List<Scope> retrieveAllScopes() {
        return this.scopes;
    }

    public void addAllScopes(List<Scope> scopes) {
        this.scopes = scopes;
    }

    public Set<APIProductIdentifier> retrieveUsedByProducts() {
        return this.usedByProducts;
    }

    public void addUsedByProduct(APIProductIdentifier usedByProduct) {
        this.usedByProducts.add(usedByProduct);
    }

    public void setAmznResourceName(String amznResourceName) {
        this.amznResourceName = amznResourceName;
    }

    public String getAmznResourceName() {
        return this.amznResourceName;
    }

    public void setAmznResourceTimeout(int amznResourceTimeout) {
        this.amznResourceTimeout = amznResourceTimeout;
    }

    public int getAmznResourceTimeout() {
        return this.amznResourceTimeout;
    }
}

