/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.api.model;

import java.io.Serializable;
import java.util.Map;
import org.wso2.carbon.apimgt.api.model.TierPermission;

public class Tier
implements Serializable,
Comparable<Tier> {
    private static final long serialVersionUID = 1L;
    private String name;
    private String displayName;
    private String description;
    private byte[] policyContent;
    private Map<String, Object> tierAttributes;
    private long requestsPerMin = 0L;
    private long requestCount = 0L;
    private long unitTime = 0L;
    private String timeUnit = "ms";
    private String tierPlan;
    private boolean stopOnQuotaReached = true;
    private TierPermission tierPermission;
    private Map<String, String> monetizationAttributes;
    private String quotaPolicyType;
    private int rateLimitCount;
    private String rateLimitTimeUnit;
    private String bandwidthDataUnit;

    public Map<String, String> getMonetizationAttributes() {
        return this.monetizationAttributes;
    }

    public void setMonetizationAttributes(Map<String, String> monetizationAttributes) {
        this.monetizationAttributes = monetizationAttributes;
    }

    public Tier(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public byte[] getPolicyContent() {
        return this.policyContent;
    }

    public void setPolicyContent(byte[] policyContent) {
        this.policyContent = policyContent;
    }

    public Map<String, Object> getTierAttributes() {
        return this.tierAttributes;
    }

    public void setTierAttributes(Map<String, Object> tierAttributes) {
        this.tierAttributes = tierAttributes;
    }

    public long getRequestsPerMin() {
        return this.requestsPerMin;
    }

    public void setRequestsPerMin(long requestsPerMin) {
        this.requestsPerMin = requestsPerMin;
    }

    public long getRequestCount() {
        return this.requestCount;
    }

    public void setRequestCount(long requestCount) {
        this.requestCount = requestCount;
    }

    public long getUnitTime() {
        return this.unitTime;
    }

    public void setUnitTime(long unitTime) {
        this.unitTime = unitTime;
    }

    public String getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(String timeUnit) {
        this.timeUnit = timeUnit;
    }

    public String getTierPlan() {
        return this.tierPlan;
    }

    public void setTierPlan(String tierPlan) {
        this.tierPlan = tierPlan;
    }

    public boolean isStopOnQuotaReached() {
        return this.stopOnQuotaReached;
    }

    public void setStopOnQuotaReached(boolean stopOnQuotaReached) {
        this.stopOnQuotaReached = stopOnQuotaReached;
    }

    public TierPermission getTierPermission() {
        return this.tierPermission;
    }

    public void setTierPermission(TierPermission tierPermission) {
        this.tierPermission = tierPermission;
    }

    public void setQuotaPolicyType(String quotaPolicyType) {
        this.quotaPolicyType = quotaPolicyType;
    }

    public String getQuotaPolicyType() {
        return this.quotaPolicyType;
    }

    public int getRateLimitCount() {
        return this.rateLimitCount;
    }

    public String getRateLimitTimeUnit() {
        return this.rateLimitTimeUnit;
    }

    public void setRateLimitCount(int rateLimitCount) {
        this.rateLimitCount = rateLimitCount;
    }

    public void setRateLimitTimeUnit(String rateLimitTimeUnit) {
        this.rateLimitTimeUnit = rateLimitTimeUnit;
    }

    public void setBandwidthDataUnit(String bandwidthDataUnit) {
        this.bandwidthDataUnit = bandwidthDataUnit;
    }

    public String getBandwidthDataUnit() {
        return this.bandwidthDataUnit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tier tier = (Tier)o;
        return !(this.name == null ? tier.name != null : !this.name.equals(tier.name));
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    @Override
    public int compareTo(Tier tier) {
        if (tier.getRequestsPerMin() == Long.MAX_VALUE || tier.getRequestsPerMin() == Integer.MAX_VALUE) {
            return 1;
        }
        if (this.getRequestsPerMin() == Long.MAX_VALUE || this.getRequestsPerMin() == Integer.MAX_VALUE) {
            return -1;
        }
        return new Long(tier.getRequestsPerMin() - this.getRequestsPerMin()).intValue();
    }
}

