/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.api.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIProduct;
import org.wso2.carbon.apimgt.api.model.APIProductResource;
import org.wso2.carbon.apimgt.api.model.Scope;
import org.wso2.carbon.apimgt.api.model.URITemplate;

public class SwaggerData {
    private String title;
    private String description;
    private String version;
    private String contactName;
    private String contactEmail;
    private String transportType;
    private String security;
    private String apiLevelPolicy;
    private Set<Resource> resources = new LinkedHashSet<Resource>();
    private Set<Scope> scopes = new HashSet<Scope>();

    public SwaggerData(API api) {
        this.title = api.getId().getName();
        this.description = api.getDescription();
        this.version = api.getId().getVersion();
        if (api.getBusinessOwner() != null) {
            this.contactName = api.getBusinessOwner();
        }
        if (api.getBusinessOwnerEmail() != null) {
            this.contactEmail = api.getBusinessOwnerEmail();
        }
        Set<URITemplate> uriTemplates = api.getUriTemplates();
        for (URITemplate uriTemplate : uriTemplates) {
            Resource resource = new Resource();
            resource.path = uriTemplate.getUriTemplate();
            resource.verb = uriTemplate.getHTTPVerb();
            resource.authType = uriTemplate.getAuthType();
            resource.policy = uriTemplate.getThrottlingTier();
            resource.scope = uriTemplate.getScope();
            resource.scopes = uriTemplate.retrieveAllScopes();
            resource.amznResourceName = uriTemplate.getAmznResourceName();
            resource.amznResourceTimeout = uriTemplate.getAmznResourceTimeout();
            this.resources.add(resource);
        }
        this.transportType = api.getType();
        this.security = api.getApiSecurity();
        this.apiLevelPolicy = api.getApiLevelPolicy();
        Set<Scope> scopes = api.getScopes();
        if (scopes != null) {
            this.scopes.addAll(scopes);
        }
    }

    public SwaggerData(APIProduct apiProduct) {
        this.title = apiProduct.getId().getName();
        this.description = apiProduct.getDescription();
        this.version = apiProduct.getId().getVersion();
        if (apiProduct.getBusinessOwner() != null) {
            this.contactName = apiProduct.getBusinessOwner();
        }
        if (apiProduct.getBusinessOwnerEmail() != null) {
            this.contactEmail = apiProduct.getBusinessOwnerEmail();
        }
        List<APIProductResource> productResources = apiProduct.getProductResources();
        for (APIProductResource productResource : productResources) {
            URITemplate uriTemplate = productResource.getUriTemplate();
            Resource resource = new Resource();
            resource.path = uriTemplate.getUriTemplate();
            resource.verb = uriTemplate.getHTTPVerb();
            resource.authType = uriTemplate.getAuthType();
            resource.policy = uriTemplate.getThrottlingTier();
            resource.scope = uriTemplate.getScope();
            resource.scopes = uriTemplate.retrieveAllScopes();
            resource.amznResourceName = uriTemplate.getAmznResourceName();
            resource.amznResourceTimeout = uriTemplate.getAmznResourceTimeout();
            this.resources.add(resource);
        }
        Set<Scope> scopes = apiProduct.getScopes();
        if (scopes != null) {
            this.scopes.addAll(scopes);
        }
    }

    public Set<Resource> getResources() {
        return this.resources;
    }

    public Set<Scope> getScopes() {
        return this.scopes;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVersion() {
        return this.version;
    }

    public String getContactName() {
        return this.contactName;
    }

    public String getContactEmail() {
        return this.contactEmail;
    }

    public String getTransportType() {
        return this.transportType;
    }

    public String getSecurity() {
        return this.security;
    }

    public String getApiLevelPolicy() {
        return this.apiLevelPolicy;
    }

    public static class Resource {
        private String path;
        private String verb;
        private String authType;
        private String policy;
        private Scope scope;
        private List<Scope> scopes = new ArrayList<Scope>();
        private String amznResourceName;
        private int amznResourceTimeout;

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getVerb() {
            return this.verb;
        }

        public void setVerb(String verb) {
            this.verb = verb;
        }

        public String getAuthType() {
            return this.authType;
        }

        public void setAuthType(String authType) {
            this.authType = authType;
        }

        public String getPolicy() {
            return this.policy;
        }

        public void setPolicy(String policy) {
            this.policy = policy;
        }

        public Scope getScope() {
            return this.scope;
        }

        public void setScope(Scope scope) {
            this.scope = scope;
        }

        public String getAmznResourceName() {
            return this.amznResourceName;
        }

        public void setAmznResourceName(String amznResourceName) {
            this.amznResourceName = amznResourceName;
        }

        public int getAmznResourceTimeout() {
            return this.amznResourceTimeout;
        }

        public void setAmznResourceTimeout(int amznResourceTimeout) {
            this.amznResourceTimeout = amznResourceTimeout;
        }

        public List<Scope> getScopes() {
            return this.scopes;
        }

        public void setScopes(List<Scope> scopes) {
            this.scopes = scopes;
        }
    }
}

