/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.api.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.APIKey;
import org.wso2.carbon.apimgt.api.model.APIProductIdentifier;
import org.wso2.carbon.apimgt.api.model.Application;
import org.wso2.carbon.apimgt.api.model.Identifier;
import org.wso2.carbon.apimgt.api.model.Subscriber;
import org.wso2.carbon.apimgt.api.model.Tier;

public class SubscribedAPI {
    private int subscriptionId;
    private Tier tier;
    private Tier requestedTier;
    private Subscriber subscriber;
    private APIIdentifier apiId;
    private APIProductIdentifier productId;
    private Date lastAccessed;
    private Application application;
    private String subStatus;
    private String subCreatedStatus;
    private List<APIKey> keys = new ArrayList<APIKey>();
    private String uuid;
    private String createdTime;
    private String updatedTime;
    private boolean isBlocked;

    public SubscribedAPI(Subscriber subscriber, APIIdentifier apiId) {
        this.subscriber = subscriber;
        this.apiId = apiId;
    }

    public SubscribedAPI(Subscriber subscriber, APIProductIdentifier productId) {
        this.subscriber = subscriber;
        this.productId = productId;
    }

    public SubscribedAPI(String uuid) {
        this.uuid = uuid;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setSubStatus(String status) {
        this.subStatus = status;
    }

    public String getSubStatus() {
        return this.subStatus;
    }

    public Subscriber getSubscriber() {
        return this.subscriber;
    }

    public APIIdentifier getApiId() {
        return this.apiId;
    }

    public Tier getTier() {
        return this.tier;
    }

    public void setTier(Tier tier) {
        this.tier = tier;
    }

    public List<APIKey> getKeys() {
        return this.keys;
    }

    public void addKey(APIKey key) {
        this.keys.add(key);
    }

    public Date getLastAccessed() {
        return new Date(this.lastAccessed.getTime());
    }

    public void setLastAccessed(Date lastAccessed) {
        if (lastAccessed != null) {
            this.lastAccessed = new Date(lastAccessed.getTime());
        }
    }

    public boolean isBlocked() {
        return this.isBlocked;
    }

    public void setBlocked(boolean blocked) {
        this.isBlocked = blocked;
    }

    public String getSubCreatedStatus() {
        return this.subCreatedStatus;
    }

    public void setSubCreatedStatus(String subCreatedStatus) {
        this.subCreatedStatus = subCreatedStatus;
    }

    public int getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSubscriptionId(int subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public String getUUID() {
        return this.uuid;
    }

    public APIProductIdentifier getProductId() {
        return this.productId;
    }

    public void setProductId(APIProductIdentifier productId) {
        this.productId = productId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscribedAPI that = (SubscribedAPI)o;
        return this.apiId.equals(that.apiId) && this.application.equals(that.application) && this.subscriber.equals(that.subscriber);
    }

    public int hashCode() {
        int result = this.subscriber.hashCode();
        result = 31 * result + (this.apiId == null ? this.productId.hashCode() : this.apiId.hashCode());
        result = 31 * result + this.application.hashCode();
        return result;
    }

    public String getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(String createdTime) {
        this.createdTime = createdTime;
    }

    public String getUpdatedTime() {
        return this.updatedTime;
    }

    public void setUpdatedTime(String updatedTime) {
        this.updatedTime = updatedTime;
    }

    public Tier getRequestedTier() {
        return this.requestedTier;
    }

    public void setRequestedTier(Tier requestedTier) {
        this.requestedTier = requestedTier;
    }

    public Identifier getIdentifier() {
        if (this.apiId != null) {
            return this.apiId;
        }
        return this.productId;
    }
}

