/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.api.model;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.AccessTokenInfo;
import org.wso2.carbon.apimgt.api.model.AccessTokenRequest;
import org.wso2.carbon.apimgt.api.model.KeyManagerConfiguration;
import org.wso2.carbon.apimgt.api.model.OAuthAppRequest;
import org.wso2.carbon.apimgt.api.model.OAuthApplicationInfo;
import org.wso2.carbon.apimgt.api.model.Scope;
import org.wso2.carbon.apimgt.api.model.URITemplate;

public interface KeyManager {
    public OAuthApplicationInfo createApplication(OAuthAppRequest var1) throws APIManagementException;

    public OAuthApplicationInfo updateApplication(OAuthAppRequest var1) throws APIManagementException;

    default public OAuthApplicationInfo updateApplicationOwner(OAuthAppRequest appInfoDTO, String owner) throws APIManagementException {
        throw new APIManagementException("This is not supported");
    }

    public void deleteApplication(String var1) throws APIManagementException;

    public OAuthApplicationInfo retrieveApplication(String var1) throws APIManagementException;

    public AccessTokenInfo getNewApplicationAccessToken(AccessTokenRequest var1) throws APIManagementException;

    public String getNewApplicationConsumerSecret(AccessTokenRequest var1) throws APIManagementException;

    public AccessTokenInfo getTokenMetaData(String var1) throws APIManagementException;

    public KeyManagerConfiguration getKeyManagerConfiguration() throws APIManagementException;

    default public OAuthApplicationInfo buildFromJSON(String jsonInput) throws APIManagementException {
        return null;
    }

    public OAuthApplicationInfo buildFromJSON(OAuthApplicationInfo var1, String var2) throws APIManagementException;

    public AccessTokenRequest buildAccessTokenRequestFromJSON(String var1, AccessTokenRequest var2) throws APIManagementException;

    public OAuthApplicationInfo mapOAuthApplication(OAuthAppRequest var1) throws APIManagementException;

    public AccessTokenRequest buildAccessTokenRequestFromOAuthApp(OAuthApplicationInfo var1, AccessTokenRequest var2) throws APIManagementException;

    public void loadConfiguration(KeyManagerConfiguration var1) throws APIManagementException;

    public boolean registerNewResource(API var1, Map var2) throws APIManagementException;

    public Map getResourceByApiId(String var1) throws APIManagementException;

    public boolean updateRegisteredResource(API var1, Map var2) throws APIManagementException;

    public void deleteRegisteredResourceByAPIId(String var1) throws APIManagementException;

    public void deleteMappedApplication(String var1) throws APIManagementException;

    public Set<String> getActiveTokensByConsumerKey(String var1) throws APIManagementException;

    public AccessTokenInfo getAccessTokenByConsumerKey(String var1) throws APIManagementException;

    default public boolean canHandleToken(String accessToken) throws APIManagementException {
        return true;
    }

    public Map<String, Set<Scope>> getScopesForAPIS(String var1) throws APIManagementException;

    public void registerScope(Scope var1) throws APIManagementException;

    public Scope getScopeByName(String var1) throws APIManagementException;

    public Map<String, Scope> getAllScopes() throws APIManagementException;

    default public void attachResourceScopes(API api, Set<URITemplate> uriTemplates) throws APIManagementException {
    }

    default public void updateResourceScopes(API api, Set<String> oldLocalScopeKeys, Set<Scope> newLocalScopes, Set<URITemplate> oldURITemplates, Set<URITemplate> newURITemplates) throws APIManagementException {
    }

    default public void detachResourceScopes(API api, Set<URITemplate> uriTemplates) throws APIManagementException {
    }

    public void deleteScope(String var1) throws APIManagementException;

    public void updateScope(Scope var1) throws APIManagementException;

    public boolean isScopeExists(String var1) throws APIManagementException;

    default public void validateScopes(Set<Scope> scopes) throws APIManagementException {
    }

    public String getType();

    public void setTenantDomain(String var1);

    default public Map<String, String> getUserClaims(String username, Map<String, Object> properties) throws APIManagementException {
        return Collections.emptyMap();
    }
}

