/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.VHost;

public class Environment
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String type = "hybrid";
    private String serverURL;
    private String userName;
    private String password;
    private String apiGatewayEndpoint;
    private String websocketGatewayEndpoint;
    private String webSubGatewayEndpoint;
    private boolean isDefault;
    private Integer id;
    private String uuid;
    private String name;
    private String displayName;
    private String description;
    private boolean isReadOnly;
    private List<VHost> vhosts = new ArrayList<VHost>();
    private boolean showInConsole = true;

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean aDefault) {
        this.isDefault = aDefault;
    }

    public String getWebsocketGatewayEndpoint() {
        return this.websocketGatewayEndpoint;
    }

    public void setWebsocketGatewayEndpoint(String websocketGatewayEndpoint) {
        this.websocketGatewayEndpoint = websocketGatewayEndpoint;
    }

    public String getWebSubGatewayEndpoint() {
        return this.webSubGatewayEndpoint;
    }

    public void setWebSubGatewayEndpoint(String webSubGatewayEndpoint) {
        this.webSubGatewayEndpoint = webSubGatewayEndpoint;
    }

    public boolean isShowInConsole() {
        return this.showInConsole;
    }

    public void setShowInConsole(boolean showInConsole) {
        this.showInConsole = showInConsole;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public void setServerURL(String serverURL) {
        this.serverURL = serverURL;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getApiGatewayEndpoint() {
        return this.apiGatewayEndpoint;
    }

    public void setApiGatewayEndpoint(String apiGatewayEndpoint) {
        this.apiGatewayEndpoint = apiGatewayEndpoint;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        if (StringUtils.isEmpty((CharSequence)this.uuid)) {
            this.uuid = name;
        }
        if (StringUtils.isEmpty((CharSequence)this.displayName)) {
            this.displayName = name;
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.isReadOnly = readOnly;
    }

    public List<VHost> getVhosts() {
        return this.vhosts;
    }

    public void setVhosts(List<VHost> vhosts) {
        this.vhosts = vhosts;
        if (StringUtils.isEmpty((CharSequence)this.apiGatewayEndpoint) && StringUtils.isEmpty((CharSequence)this.websocketGatewayEndpoint) && !vhosts.isEmpty()) {
            VHost vhost = vhosts.get(0);
            String endpointFormat = "%s%s:%s%s";
            String httpContext = StringUtils.isEmpty((CharSequence)vhost.getHttpContext()) ? "" : "/" + vhost.getHttpContext();
            String gwHttpEndpoint = String.format(endpointFormat, "http://", vhost.getHost(), vhost.getHttpPort(), httpContext);
            String gwHttpsEndpoint = String.format(endpointFormat, "https://", vhost.getHost(), vhost.getHttpsPort(), httpContext);
            this.apiGatewayEndpoint = gwHttpsEndpoint + "," + gwHttpEndpoint;
            String gwWsEndpoint = String.format(endpointFormat, "ws://", vhost.getHost(), vhost.getWsPort(), "");
            String gwWssEndpoint = String.format(endpointFormat, "wss://", vhost.getHost(), vhost.getWssPort(), "");
            this.websocketGatewayEndpoint = gwWssEndpoint + "," + gwWsEndpoint;
        }
    }

    public void setEndpointsAsVhost() throws APIManagementException {
        String modifiedWebSubGatewayEndpoint = this.webSubGatewayEndpoint.replaceAll("http://", "websub_http://").replaceAll("https://", "websub_https://");
        String[] endpoints = (this.apiGatewayEndpoint + "," + this.websocketGatewayEndpoint + "," + modifiedWebSubGatewayEndpoint).split(",", 6);
        this.getVhosts().add(VHost.fromEndpointUrls(endpoints));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Environment that = (Environment)o;
        if (!this.getName().equals(that.getName())) {
            return false;
        }
        return this.type.equals(that.getType());
    }

    public int hashCode() {
        int result = this.type.hashCode();
        return 31 * result + this.getName().hashCode();
    }
}

