/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wso2.carbon.apimgt.api.model.APIKey;
import org.wso2.carbon.apimgt.api.model.OAuthApplicationInfo;
import org.wso2.carbon.apimgt.api.model.SubscribedAPI;
import org.wso2.carbon.apimgt.api.model.Subscriber;

public class Application {
    private int id;
    private String name;
    private String uuid;
    private Subscriber subscriber;
    private Set<SubscribedAPI> subscribedAPIs = new LinkedHashSet<SubscribedAPI>();
    private List<APIKey> keys = new ArrayList<APIKey>();
    private Map<String, Map<String, OAuthApplicationInfo>> keyManagerWiseOAuthApp = new HashMap<String, Map<String, OAuthApplicationInfo>>();
    private String tier;
    private String tierQuotaType;
    private String callbackUrl;
    private String description;
    private String status;
    private String groupId;
    private Boolean isBlackListed;
    private String owner;
    private Map<String, String> applicationAttributes = new HashMap<String, String>();
    private String createdTime;
    private String lastUpdatedTime;
    private String tokenType;
    private String keyType;
    private int subscriptionCount;
    private String keyManager;
    private String applicationWorkFlowStatus;

    public Map<String, Map<String, OAuthApplicationInfo>> getKeyManagerWiseOAuthApp() {
        return this.keyManagerWiseOAuthApp;
    }

    public String getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(String createdTime) {
        this.createdTime = createdTime;
    }

    public String getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public void setLastUpdatedTime(String lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public Application(String name, Subscriber subscriber) {
        this.name = name;
        this.subscriber = subscriber;
    }

    public Application(int appId) {
        this.id = appId;
        this.subscriber = new Subscriber(null);
    }

    public Application(String uuid) {
        this.uuid = uuid;
        this.subscriber = new Subscriber(null);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Subscriber getSubscriber() {
        return this.subscriber;
    }

    public Set<SubscribedAPI> getSubscribedAPIs() {
        return this.subscribedAPIs;
    }

    public void setSubscribedAPIs(Set<SubscribedAPI> subscribedAPIs) {
        this.subscribedAPIs = subscribedAPIs;
    }

    public void addSubscribedAPIs(Set<SubscribedAPI> subscribedAPIs) {
        for (SubscribedAPI subscribedAPI : subscribedAPIs) {
            subscribedAPI.setApplication(this);
        }
        this.subscribedAPIs.addAll(subscribedAPIs);
    }

    public void removeSubscribedAPIs(Set<SubscribedAPI> subscribedAPIs) {
        this.subscribedAPIs.removeAll(subscribedAPIs);
    }

    public Map<String, String> getApplicationAttributes() {
        return this.applicationAttributes;
    }

    public void setApplicationAttributes(Map<String, String> applicationAttributes) {
        this.applicationAttributes = applicationAttributes;
    }

    public Map<String, OAuthApplicationInfo> getOAuthApp(String keyType) {
        return this.keyManagerWiseOAuthApp.get(keyType);
    }

    public void addOAuthApp(String keyType, String keyManager, OAuthApplicationInfo oAuthApplicationInfo) {
        Map keyTypeWiseOauthApp = this.keyManagerWiseOAuthApp.getOrDefault(keyType, new HashMap());
        keyTypeWiseOauthApp.put(keyManager, oAuthApplicationInfo);
        this.keyManagerWiseOAuthApp.put(keyType, keyTypeWiseOauthApp);
    }

    public OAuthApplicationInfo getOAuthApp(String keyType, String keyManager) {
        Map keyManagerWiseOauthAPP = this.keyManagerWiseOAuthApp.getOrDefault(keyType, new HashMap());
        return (OAuthApplicationInfo)keyManagerWiseOauthAPP.get(keyManager);
    }

    public void clearOAuthApps() {
        this.keyManagerWiseOAuthApp.clear();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public List<APIKey> getKeys() {
        return this.keys;
    }

    public void addKey(APIKey key) {
        this.keys.add(key);
    }

    public String getTier() {
        return this.tier;
    }

    public void setTier(String tier) {
        this.tier = tier;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Application that = (Application)o;
        return this.id == that.id && this.name.equals(that.name) && this.subscriber.equals(that.subscriber);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + Integer.valueOf(this.id).hashCode();
        result = 31 * result + this.subscriber.hashCode();
        return result;
    }

    public String getApplicationWorkFlowStatus() {
        return this.applicationWorkFlowStatus;
    }

    public void setApplicationWorkFlowStatus(String applicationWorkFlowStatus) {
        this.applicationWorkFlowStatus = applicationWorkFlowStatus;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public String getUUID() {
        return this.uuid;
    }

    public Boolean getIsBlackListed() {
        return this.isBlackListed;
    }

    public void setIsBlackListed(Boolean isBlackListed) {
        this.isBlackListed = isBlackListed;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public void setSubscriptionCount(int subscriptionCount) {
        this.subscriptionCount = subscriptionCount;
    }

    public int getSubscriptionCount() {
        return this.subscriptionCount;
    }

    public void updateSubscriber(Subscriber subscriber) {
        this.subscriber = subscriber;
    }

    public String getTierQuotaType() {
        return this.tierQuotaType;
    }

    public void setTierQuotaType(String tierQuotaType) {
        this.tierQuotaType = tierQuotaType;
    }

    public String getKeyManager() {
        return this.keyManager;
    }

    public void setKeyManager(String keyManager) {
        this.keyManager = keyManager;
    }
}

