/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.api.model;

import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.APIProductIdentifier;
import org.wso2.carbon.apimgt.api.model.EndpointSecurity;
import org.wso2.carbon.apimgt.api.model.URITemplate;

public class APIProductResource {
    private String apiName;
    private String apiId;
    private APIIdentifier apiIdentifier;
    private APIProductIdentifier productIdentifier;
    private URITemplate uriTemplate;
    private String endpointConfig;
    private Map<String, EndpointSecurity> endpointSecurityMap = new HashMap<String, EndpointSecurity>();
    private String inSequenceName = "";
    private String outSequenceName = "";
    private String faultSequenceName = "";

    public String getApiName() {
        return this.apiName;
    }

    public void setApiName(String apiName) {
        this.apiName = apiName;
    }

    public String getApiId() {
        return this.apiId;
    }

    public void setApiId(String apiId) {
        this.apiId = apiId;
    }

    public void setApiIdentifier(APIIdentifier apiIdentifier) {
        this.apiIdentifier = apiIdentifier;
    }

    public APIIdentifier getApiIdentifier() {
        return this.apiIdentifier;
    }

    public void setProductIdentifier(APIProductIdentifier productIdentifier) {
        this.productIdentifier = productIdentifier;
    }

    public APIProductIdentifier getProductIdentifier() {
        return this.productIdentifier;
    }

    public String toString() {
        String resources = this.uriTemplate.getHTTPVerb() + ":" + this.uriTemplate.getResourceURI() + " ";
        return "APIProductResource [apiName=" + this.apiName + ", apiId=" + this.apiId + ", apiIdentifier=" + this.apiIdentifier + ", resources=" + resources + "]";
    }

    public URITemplate getUriTemplate() {
        return this.uriTemplate;
    }

    public void setUriTemplate(URITemplate uriTemplate) {
        this.uriTemplate = uriTemplate;
    }

    public String getInSequenceName() {
        return this.inSequenceName;
    }

    public void setInSequenceName(String inSequenceName) {
        this.inSequenceName = inSequenceName;
    }

    public String getFaultSequenceName() {
        return this.faultSequenceName;
    }

    public void setFaultSequenceName(String faultSequenceName) {
        this.faultSequenceName = faultSequenceName;
    }

    public String getOutSequenceName() {
        return this.outSequenceName;
    }

    public void setOutSequenceName(String outSequenceName) {
        this.outSequenceName = outSequenceName;
    }

    public String getEndpointConfig() {
        return this.endpointConfig;
    }

    public JSONObject getEndpointConfigAsJSON() throws ParseException {
        JSONParser parser = new JSONParser();
        Object config = parser.parse(this.endpointConfig);
        return (JSONObject)config;
    }

    public void setEndpointConfig(String endpointConfig) {
        this.endpointConfig = endpointConfig;
    }

    public String getEndpointKey() {
        return this.productIdentifier.getName() + "--v" + this.productIdentifier.getVersion() + "--" + this.apiId;
    }

    public Map<String, EndpointSecurity> getEndpointSecurityMap() {
        return this.endpointSecurityMap;
    }

    public void setEndpointSecurityMap(Map<String, EndpointSecurity> endpointSecurityMap) {
        this.endpointSecurityMap = endpointSecurityMap;
    }
}

