/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.api.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONObject;
import org.wso2.carbon.apimgt.api.model.APICategory;
import org.wso2.carbon.apimgt.api.model.APIProductIdentifier;
import org.wso2.carbon.apimgt.api.model.APIProductResource;
import org.wso2.carbon.apimgt.api.model.CORSConfiguration;
import org.wso2.carbon.apimgt.api.model.Scope;
import org.wso2.carbon.apimgt.api.model.Tier;

public class APIProduct {
    private APIProductIdentifier id;
    private String uuid;
    private String type;
    private int productId;
    private String context;
    private String description;
    private Set<Tier> availableTiers = new LinkedHashSet<Tier>();
    private String productLevelPolicy;
    private Set<String> tags = new LinkedHashSet<String>();
    private String contextTemplate;
    private String visibility;
    private String visibleRoles;
    private String visibleTenants;
    private String subscriptionAvailability;
    private String subscriptionAvailableTenants;
    private String state;
    private String businessOwner;
    private String businessOwnerEmail;
    private String technicalOwner;
    private String technicalOwnerEmail;
    private String tenantDomain;
    private String rating;
    private List<APIProductResource> productResources = new ArrayList<APIProductResource>();
    private String definition;
    private JSONObject additionalProperties = new JSONObject();
    private Set<String> environments = new HashSet<String>();
    private boolean enableSchemaValidation = false;
    private Set<Scope> scopes = new HashSet<Scope>();
    private JSONObject monetizationProperties = new JSONObject();
    private boolean isMonetizationEnabled = false;
    private String apiSecurity = "oauth2";
    private static final String NULL_VALUE = "NULL";
    private static final String API_PRODUCT = "APIProduct";
    private String transports;
    private String responseCache;
    private int cacheTimeout;
    private String thumbnailUrl;
    private String productionMaxTps;
    private String sandboxMaxTps;
    private String authorizationHeader;
    private CORSConfiguration corsConfiguration;
    private String accessControl;
    private String accessControlRoles;
    private List<APICategory> apiCategories;
    private Date lastUpdated;
    private Date createdTime;
    private String testKey;
    private boolean enableStore = true;
    private boolean isRevision = false;
    private String revisionedApiProductId;
    private int revisionId;

    public APIProduct() {
    }

    public APIProduct(APIProductIdentifier id) {
        this.id = id;
    }

    public void setID(APIProductIdentifier id) {
        this.id = id;
    }

    public APIProductIdentifier getId() {
        return this.id;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public List<APIProductResource> getProductResources() {
        return this.productResources;
    }

    public void setProductResources(List<APIProductResource> productResources) {
        this.productResources = productResources;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public String getSubscriptionAvailability() {
        return this.subscriptionAvailability;
    }

    public void setSubscriptionAvailability(String subscriptionAvailability) {
        this.subscriptionAvailability = subscriptionAvailability;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getTechnicalOwner() {
        return this.technicalOwner;
    }

    public void setTechnicalOwner(String technicalOwner) {
        this.technicalOwner = technicalOwner;
    }

    public String getTechnicalOwnerEmail() {
        return this.technicalOwnerEmail;
    }

    public void setTechnicalOwnerEmail(String technicalOwnerEmail) {
        this.technicalOwnerEmail = technicalOwnerEmail;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = StringUtils.isEmpty((CharSequence)type) || NULL_VALUE.equalsIgnoreCase(StringUtils.trim((String)type)) ? API_PRODUCT : type;
    }

    public String getBusinessOwner() {
        return this.businessOwner;
    }

    public void setBusinessOwner(String businessOwner) {
        this.businessOwner = businessOwner;
    }

    public String getBusinessOwnerEmail() {
        return this.businessOwnerEmail;
    }

    public void setBusinessOwnerEmail(String businessOwnerEmail) {
        this.businessOwnerEmail = businessOwnerEmail;
    }

    public int getProductId() {
        return this.productId;
    }

    public JSONObject getMonetizationProperties() {
        return this.monetizationProperties;
    }

    @Deprecated
    public boolean getMonetizationStatus() {
        return this.isMonetizationEnabled;
    }

    @Deprecated
    public void setMonetizationStatus(boolean monetizationStatus) {
        this.isMonetizationEnabled = monetizationStatus;
    }

    public boolean isMonetizationEnabled() {
        return this.isMonetizationEnabled;
    }

    public void setMonetizationEnabled(boolean isMonetizationEnabled) {
        this.isMonetizationEnabled = isMonetizationEnabled;
    }

    public boolean isEnableSchemaValidation() {
        return this.enableSchemaValidation;
    }

    public void setMonetizationProperties(JSONObject monetizationProperties) {
        this.monetizationProperties = monetizationProperties;
    }

    public void addMonetizationProperty(String key, String value) {
        this.monetizationProperties.put((Object)key, (Object)value);
    }

    public void setProductId(int productId) {
        this.productId = productId;
    }

    public Set<Tier> getAvailableTiers() {
        return this.availableTiers;
    }

    public void setAvailableTiers(Set<Tier> availableTiers) {
        this.availableTiers = availableTiers;
    }

    public String getSubscriptionAvailableTenants() {
        return this.subscriptionAvailableTenants;
    }

    public void setSubscriptionAvailableTenants(String subscriptionAvailableTenants) {
        this.subscriptionAvailableTenants = subscriptionAvailableTenants;
    }

    public String getVisibleRoles() {
        return this.visibleRoles;
    }

    public void setVisibleRoles(String visibleRoles) {
        this.visibleRoles = visibleRoles;
    }

    public String getVisibleTenants() {
        return this.visibleTenants;
    }

    public void setVisibleTenants(String visibleTenants) {
        this.visibleTenants = visibleTenants;
    }

    public String getTenantDomain() {
        return this.tenantDomain;
    }

    public void setTenantDomain(String tenantDomain) {
        this.tenantDomain = tenantDomain;
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    public Set<String> getEnvironments() {
        return this.environments;
    }

    public void setEnvironments(Set<String> environments) {
        this.environments = environments;
    }

    public JSONObject getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(JSONObject properties) {
        this.additionalProperties = properties;
    }

    public void addProperty(String key, String value) {
        this.additionalProperties.put((Object)key, (Object)value);
    }

    public String getProperty(String key) {
        return this.additionalProperties.get((Object)key).toString();
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getTransports() {
        return this.transports;
    }

    public void setTransports(String transports) {
        this.transports = transports;
    }

    public String getResponseCache() {
        return this.responseCache;
    }

    public void setResponseCache(String responseCache) {
        this.responseCache = responseCache;
    }

    public int getCacheTimeout() {
        return this.cacheTimeout;
    }

    public void setCacheTimeout(int cacheTimeout) {
        this.cacheTimeout = cacheTimeout;
    }

    public String getProductionMaxTps() {
        return this.productionMaxTps;
    }

    public void setProductionMaxTps(String productionMaxTps) {
        this.productionMaxTps = productionMaxTps;
    }

    public String getSandboxMaxTps() {
        return this.sandboxMaxTps;
    }

    public void setSandboxMaxTps(String sandboxMaxTps) {
        this.sandboxMaxTps = sandboxMaxTps;
    }

    public void setThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
    }

    public String getThumbnailUrl() {
        return this.thumbnailUrl;
    }

    public void setAccessControl(String accessControl) {
        this.accessControl = accessControl;
    }

    public String getAccessControl() {
        return this.accessControl;
    }

    public void setAccessControlRoles(String accessControlRoles) {
        this.accessControlRoles = accessControlRoles;
    }

    public String getAccessControlRoles() {
        return this.accessControlRoles;
    }

    @Deprecated
    public boolean isEnabledSchemaValidation() {
        return this.enableSchemaValidation;
    }

    public void setEnableSchemaValidation(boolean enableSchemaValidation) {
        this.enableSchemaValidation = enableSchemaValidation;
    }

    public String getApiSecurity() {
        return this.apiSecurity;
    }

    public void setApiSecurity(String apiSecurity) {
        this.apiSecurity = apiSecurity;
    }

    public String getAuthorizationHeader() {
        return this.authorizationHeader;
    }

    public void setAuthorizationHeader(String authorizationHeader) {
        this.authorizationHeader = authorizationHeader;
    }

    public CORSConfiguration getCorsConfiguration() {
        return this.corsConfiguration;
    }

    public void setCorsConfiguration(CORSConfiguration corsConfiguration) {
        this.corsConfiguration = corsConfiguration;
    }

    public Set<Scope> getScopes() {
        return this.scopes;
    }

    public void setScopes(Set<Scope> scopes) {
        this.scopes = scopes;
    }

    public void addScope(Scope scope) {
        this.scopes.add(scope);
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public void setContextTemplate(String contextTemplate) {
        this.contextTemplate = contextTemplate;
    }

    public String getContextTemplate() {
        return this.contextTemplate;
    }

    public boolean isEnableStore() {
        return this.enableStore;
    }

    public void setEnableStore(boolean enableStore) {
        this.enableStore = enableStore;
    }

    public String getTestKey() {
        return this.testKey;
    }

    public void setTestKey(String testKey) {
        this.testKey = testKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof APIProduct)) {
            return false;
        }
        APIProduct that = (APIProduct)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        String tiers = "";
        for (Tier tier : this.availableTiers) {
            tiers = tiers + tier.getName() + " ";
        }
        String env = "";
        for (String environment : this.environments) {
            env = env + environment + " ";
        }
        return "APIProduct [name=" + this.id.getName() + ", version=" + this.id.getVersion() + ", uuid=" + this.uuid + ", productId=" + this.productId + ", provider=" + this.id.getProviderName() + ", description=" + this.description + ", availableTiers=" + tiers + ", visibility=" + this.visibility + ", visibleRoles=" + this.visibleRoles + ", visibleTenants=" + this.visibleTenants + ", environments=" + env + ", subscriptionAvailability=" + this.subscriptionAvailability + ", subscriptionAvailableTenants=" + this.subscriptionAvailableTenants + ", accessControl=" + this.accessControl + ", accessControlRoles=" + this.accessControlRoles + ", state=" + this.state + ", businessOwner=" + this.businessOwner + ", businessOwnerEmail=" + this.businessOwnerEmail + ", tenantDomain=" + this.tenantDomain + ", productResources=" + this.productResources + "]";
    }

    public Set<String> getTags() {
        return Collections.unmodifiableSet(this.tags);
    }

    public void setTags(Set<String> tags) {
        this.tags.addAll(tags);
    }

    @Deprecated
    public void addTags(Set<String> tags) {
        this.tags.addAll(tags);
    }

    public void removeTags(Set<String> tags) {
        this.tags.removeAll(tags);
    }

    public String getRating() {
        return this.rating;
    }

    public void setRating(String rating) {
        this.rating = rating;
    }

    public String getProductLevelPolicy() {
        return this.productLevelPolicy;
    }

    public void setProductLevelPolicy(String productLevelPolicy) {
        this.productLevelPolicy = productLevelPolicy;
    }

    public void removeAllTiers() {
        this.availableTiers.clear();
    }

    public void removeAvailableTiers(Set<Tier> availableTiers) {
        this.availableTiers.removeAll(availableTiers);
    }

    public void setApiCategories(List<APICategory> apiCategories) {
        this.apiCategories = apiCategories;
    }

    public List<APICategory> getApiCategories() {
        return this.apiCategories;
    }

    public boolean isAsync() {
        return this.getType().equals("WS") || this.getType().equals("WEBSUB") || this.getType().equals("SSE");
    }

    public boolean isRevision() {
        return this.isRevision;
    }

    public void setRevision(boolean revision) {
        this.isRevision = revision;
    }

    public String getRevisionedApiProductId() {
        return this.revisionedApiProductId;
    }

    public void setRevisionedApiProductId(String revisionedApiProductId) {
        this.revisionedApiProductId = revisionedApiProductId;
    }

    public int getRevisionId() {
        return this.revisionId;
    }

    public void setRevisionId(int revisionId) {
        this.revisionId = revisionId;
    }
}

