/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.api.model;

import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.APIStatus;

public class APIInfo {
    private String id;
    private String name;
    private String version;
    private String provider;
    private String context;
    private String contextTemplate;
    private String apiTier;
    private String apiType;
    private String createdTime;
    private String createdBy;
    private String updatedTime;
    private String updatedBy;
    private APIStatus status;
    private int revisionsCreated;
    private boolean isRevision;

    private APIInfo() {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getContextTemplate() {
        return this.contextTemplate;
    }

    public void setContextTemplate(String contextTemplate) {
        this.contextTemplate = contextTemplate;
    }

    public String getApiTier() {
        return this.apiTier;
    }

    public void setApiTier(String apiTier) {
        this.apiTier = apiTier;
    }

    public String getApiType() {
        return this.apiType;
    }

    public void setApiType(String apiType) {
        this.apiType = apiType;
    }

    public String getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(String createdTime) {
        this.createdTime = createdTime;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getUpdatedTime() {
        return this.updatedTime;
    }

    public void setUpdatedTime(String updatedTime) {
        this.updatedTime = updatedTime;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public APIStatus getStatus() {
        return this.status;
    }

    public void setStatus(APIStatus status) {
        this.status = status;
    }

    public APIIdentifier toAPIIdentifier() {
        String providerEmailDomainReplaced = this.provider;
        if (this.provider != null && this.provider.contains("@")) {
            providerEmailDomainReplaced = this.provider.replace("@", "-AT-");
        }
        return new APIIdentifier(providerEmailDomainReplaced, this.name, this.version);
    }

    public int getRevisionsCreated() {
        return this.revisionsCreated;
    }

    public void setRevisionsCreated(int revisionsCreated) {
        this.revisionsCreated = revisionsCreated;
    }

    public boolean isRevision() {
        return this.isRevision;
    }

    public void setRevision(boolean revision) {
        this.isRevision = revision;
    }

    public static class Builder {
        private String id;
        private String name;
        private String version;
        private String provider;
        private String context;
        private String contextTemplate;
        private String apiTier;
        private String apiType;
        private String createdTime;
        private String createdBy;
        private String updatedTime;
        private String updatedBy;
        private APIStatus status;
        private int revisionsCreated;
        private boolean isRevision;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public Builder context(String context) {
            this.context = context;
            return this;
        }

        public Builder contextTemplate(String contextTemplate) {
            this.contextTemplate = contextTemplate;
            return this;
        }

        public Builder apiTier(String apiTier) {
            this.apiTier = apiTier;
            return this;
        }

        public Builder apiType(String apiType) {
            this.apiType = apiType;
            return this;
        }

        public Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public Builder updatedTime(String updatedTime) {
            this.updatedTime = updatedTime;
            return this;
        }

        public Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public Builder status(APIStatus status) {
            this.status = status;
            return this;
        }

        public Builder revisionsCreated(int revisionsCreated) {
            this.revisionsCreated = revisionsCreated;
            return this;
        }

        public Builder isRevision(boolean isRevision) {
            this.isRevision = isRevision;
            return this;
        }

        public APIInfo build() {
            APIInfo apiInfo = new APIInfo();
            apiInfo.id = this.id;
            apiInfo.name = this.name;
            apiInfo.version = this.version;
            apiInfo.provider = this.provider;
            apiInfo.context = this.context;
            apiInfo.contextTemplate = this.contextTemplate;
            apiInfo.apiTier = this.apiTier;
            apiInfo.apiType = this.apiType;
            apiInfo.createdTime = this.createdTime;
            apiInfo.createdBy = this.createdBy;
            apiInfo.updatedTime = this.updatedTime;
            apiInfo.updatedBy = this.updatedBy;
            apiInfo.status = this.status;
            apiInfo.revisionsCreated = this.revisionsCreated;
            apiInfo.isRevision = this.isRevision;
            return apiInfo;
        }
    }
}

