/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.api.model;

import java.io.Serializable;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.Default;
import org.wso2.carbon.apimgt.api.model.Identifier;

public class APIIdentifier
implements Serializable,
Identifier {
    private static final long serialVersionUID = 1L;
    private final String providerName;
    private final String apiName;
    private final String version;
    private String tier;
    private String applicationId;
    private String uuid;
    private int id;

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    @Override
    public String getTier() {
        return this.tier;
    }

    @Override
    public void setTier(String tier) {
        this.tier = tier;
    }

    @Default
    public APIIdentifier(String providerName, String apiName, String version) {
        this.providerName = providerName;
        this.apiName = apiName;
        this.version = version;
    }

    public APIIdentifier(String providerName, String apiName, String version, String uuid) {
        this.providerName = providerName;
        this.apiName = apiName;
        this.version = version;
        this.uuid = uuid;
    }

    public APIIdentifier(String apiId) throws APIManagementException {
        String[] split = apiId.split("_");
        if (split.length != 3) {
            throw new APIManagementException("Invalid API ID : " + apiId);
        }
        this.providerName = split[0];
        this.apiName = split[1];
        this.version = split[2];
    }

    @Override
    public String getProviderName() {
        return this.providerName;
    }

    public String getApiName() {
        return this.apiName;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APIIdentifier that = (APIIdentifier)o;
        return this.apiName.equals(that.apiName) && this.providerName.equals(that.providerName) && this.version.equals(that.version);
    }

    public int hashCode() {
        int result = this.providerName.hashCode();
        result = 31 * result + this.apiName.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public String toString() {
        return this.getProviderName() + '-' + this.getName() + '-' + this.getVersion();
    }

    @Override
    public String getName() {
        return this.apiName;
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }
}

