/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONObject;
import org.wso2.carbon.apimgt.api.model.APICategory;
import org.wso2.carbon.apimgt.api.model.APIEndpoint;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.APIStatus;
import org.wso2.carbon.apimgt.api.model.AuthorizationPolicy;
import org.wso2.carbon.apimgt.api.model.CORSConfiguration;
import org.wso2.carbon.apimgt.api.model.Documentation;
import org.wso2.carbon.apimgt.api.model.Mediation;
import org.wso2.carbon.apimgt.api.model.ResourceFile;
import org.wso2.carbon.apimgt.api.model.SOAPToRestSequence;
import org.wso2.carbon.apimgt.api.model.Scope;
import org.wso2.carbon.apimgt.api.model.Tier;
import org.wso2.carbon.apimgt.api.model.URITemplate;
import org.wso2.carbon.apimgt.api.model.WebSocketTopicMappingConfiguration;
import org.wso2.carbon.apimgt.api.model.WebsubSubscriptionConfiguration;
import org.wso2.carbon.apimgt.api.model.policy.Policy;

public class API
implements Serializable {
    private static final long serialVersionUID = 1L;
    private APIIdentifier id;
    private String uuid;
    private String description;
    private String url;
    private String sandboxUrl;
    private String wsdlUrl;
    private String wsdlArchivePath;
    private String wadlUrl;
    private String swaggerDefinition;
    private String graphQLSchema;
    private String asyncApiDefinition;
    private String type;
    private String context;
    private String contextTemplate;
    private String thumbnailUrl;
    private ResourceFile wsdlResource;
    private Set<String> tags = new LinkedHashSet<String>();
    private Set<Documentation> documents = new LinkedHashSet<Documentation>();
    private String httpVerb;
    private Date lastUpdated;
    private Set<Tier> availableTiers = new LinkedHashSet<Tier>();
    private Set<Policy> availableSubscriptionLevelPolicies = new LinkedHashSet<Policy>();
    private String apiLevelPolicy;
    private AuthorizationPolicy authorizationPolicy;
    private Set<URITemplate> uriTemplates = new LinkedHashSet<URITemplate>();
    private boolean apiHeaderChanged;
    private boolean apiResourcePatternsChanged;
    private String status;
    private String technicalOwner;
    private String technicalOwnerEmail;
    private String businessOwner;
    private String businessOwnerEmail;
    private String productionMaxTps;
    private String sandboxMaxTps;
    private String visibility;
    private String visibleRoles;
    private String visibleTenants;
    private boolean endpointSecured = false;
    private boolean endpointAuthDigest = false;
    private String endpointUTUsername;
    private String endpointUTPassword;
    private String transports;
    private String inSequence;
    private String outSequence;
    private String faultSequence;
    private Mediation inSequenceMediation;
    private Mediation outSequenceMediation;
    private Mediation faultSequenceMediation;
    private String oldInSequence;
    private String oldOutSequence;
    private String oldFaultSequence;
    private boolean advertiseOnly;
    private String apiOwner;
    private String redirectURL;
    private String vendor;
    private String subscriptionAvailability;
    private String subscriptionAvailableTenants;
    private CORSConfiguration corsConfiguration;
    private String endpointConfig;
    private WebsubSubscriptionConfiguration websubSubscriptionConfiguration;
    private WebSocketTopicMappingConfiguration webSocketTopicMappingConfiguration;
    private Map<String, String> wsUriMapping;
    private String responseCache;
    private int cacheTimeout;
    private String implementation = "ENDPOINT";
    private String monetizationCategory;
    private List<SOAPToRestSequence> soapToRestSequences;
    private String authorizationHeader;
    private Set<Scope> scopes;
    private boolean isDefaultVersion = false;
    private boolean isPublishedDefaultVersion = false;
    private List<String> keyManagers = new ArrayList<String>();
    private JSONObject serviceInfo = new JSONObject();
    private String workflowStatus = null;
    private Set<String> environments;
    private String createdTime;
    private JSONObject additionalProperties;
    private JSONObject monetizationProperties = new JSONObject();
    private boolean isMonetizationEnabled = false;
    private Set<String> environmentList;
    private String apiSecurity = "oauth2";
    private static final String NULL_VALUE = "NULL";
    private List<APIEndpoint> endpoints = new ArrayList<APIEndpoint>();
    private boolean enableSchemaValidation = false;
    private List<APICategory> apiCategories;
    private boolean enableStore = true;
    private String testKey;
    private boolean isRevision = false;
    private String revisionedApiId;
    private int revisionId;
    private String accessControl;
    private String accessControlRoles;
    private float rating;
    private boolean isLatest;

    public List<SOAPToRestSequence> getSoapToRestSequences() {
        return this.soapToRestSequences;
    }

    public void setSoapToRestSequences(List<SOAPToRestSequence> soapToRestSequences) {
        this.soapToRestSequences = soapToRestSequences;
    }

    public void setEnvironmentList(Set<String> environmentList) {
        this.environmentList = environmentList;
    }

    public Set<String> getEnvironmentList() {
        return this.environmentList;
    }

    public JSONObject getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(JSONObject properties) {
        this.additionalProperties = properties;
    }

    public JSONObject getServiceInfoObject() {
        return this.serviceInfo;
    }

    public void setServiceInfo(String key, String value) {
        this.serviceInfo.put((Object)key, (Object)value);
    }

    public void setServiceInfo(JSONObject serviceInfo) {
        this.serviceInfo = serviceInfo;
    }

    public String getServiceInfo(String key) {
        if (this.serviceInfo != null && this.serviceInfo.get((Object)key) != null) {
            return this.serviceInfo.get((Object)key).toString();
        }
        return null;
    }

    public JSONObject getMonetizationProperties() {
        return this.monetizationProperties;
    }

    @Deprecated
    public boolean getMonetizationStatus() {
        return this.isMonetizationEnabled;
    }

    @Deprecated
    public void setMonetizationStatus(boolean monetizationStatus) {
        this.isMonetizationEnabled = monetizationStatus;
    }

    public boolean isMonetizationEnabled() {
        return this.isMonetizationEnabled;
    }

    public void setMonetizationEnabled(boolean isMonetizationEnabled) {
        this.isMonetizationEnabled = isMonetizationEnabled;
    }

    public void setMonetizationProperties(JSONObject monetizationProperties) {
        this.monetizationProperties = monetizationProperties;
    }

    public void addMonetizationProperty(String key, String value) {
        this.monetizationProperties.put((Object)key, (Object)value);
    }

    public void addProperty(String key, String value) {
        this.additionalProperties.put((Object)key, (Object)value);
    }

    public String getProperty(String key) {
        return this.additionalProperties.get((Object)key).toString();
    }

    public String getSwaggerDefinition() {
        return this.swaggerDefinition;
    }

    public void setSwaggerDefinition(String swaggerDefinition) {
        this.swaggerDefinition = swaggerDefinition;
    }

    public void setGraphQLSchema(String graphQLSchema) {
        this.graphQLSchema = graphQLSchema;
    }

    public String getGraphQLSchema() {
        return this.graphQLSchema;
    }

    public String getAsyncApiDefinition() {
        return this.asyncApiDefinition;
    }

    public void setAsyncApiDefinition(String asyncApiDefinition) {
        this.asyncApiDefinition = asyncApiDefinition;
    }

    public Set<String> getEnvironments() {
        return this.environments;
    }

    public void setEnvironments(Set<String> environments) {
        this.environments = environments;
    }

    public String getImplementation() {
        return this.implementation;
    }

    public void setImplementation(String implementation) {
        this.implementation = implementation;
    }

    @Deprecated
    public String getUUID() {
        return this.uuid;
    }

    @Deprecated
    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getProductionMaxTps() {
        return this.productionMaxTps;
    }

    public void setProductionMaxTps(String productionMaxTps) {
        this.productionMaxTps = productionMaxTps;
    }

    public String getSandboxMaxTps() {
        return this.sandboxMaxTps;
    }

    public void setSandboxMaxTps(String sandboxMaxTps) {
        this.sandboxMaxTps = sandboxMaxTps;
    }

    public boolean isAdvertiseOnly() {
        return this.advertiseOnly;
    }

    public void setAdvertiseOnly(boolean advertiseOnly) {
        this.advertiseOnly = advertiseOnly;
    }

    public String getApiOwner() {
        return this.apiOwner;
    }

    public void setApiOwner(String apiOwner) {
        this.apiOwner = apiOwner;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public void setRedirectURL(String redirectURL) {
        this.redirectURL = redirectURL;
    }

    public String getAdvertiseOnlyAPIVendor() {
        return this.vendor;
    }

    public void setAdvertiseOnlyAPIVendor(String advertiseOnlyAPIVendor) {
        this.vendor = advertiseOnlyAPIVendor;
    }

    public API(APIIdentifier id) {
        this.id = id;
        this.additionalProperties = new JSONObject();
    }

    public APIIdentifier getId() {
        return this.id;
    }

    public void setId(APIIdentifier id) {
        this.id = id;
    }

    public String getTransports() {
        return this.transports;
    }

    public void setTransports(String transports) {
        this.transports = transports;
    }

    public String getTechnicalOwner() {
        return this.technicalOwner;
    }

    public void setTechnicalOwner(String technicalOwner) {
        this.technicalOwner = technicalOwner;
    }

    public String getTechnicalOwnerEmail() {
        return this.technicalOwnerEmail;
    }

    public void setTechnicalOwnerEmail(String technicalOwnerEmail) {
        this.technicalOwnerEmail = technicalOwnerEmail;
    }

    public String getBusinessOwner() {
        return this.businessOwner;
    }

    public void setBusinessOwner(String businessOwner) {
        this.businessOwner = businessOwner;
    }

    public String getBusinessOwnerEmail() {
        return this.businessOwnerEmail;
    }

    public void setBusinessOwnerEmail(String businessOwnerEmail) {
        this.businessOwnerEmail = businessOwnerEmail;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getSandboxUrl() {
        return this.sandboxUrl;
    }

    public void setSandboxUrl(String sandboxUrl) {
        this.sandboxUrl = sandboxUrl;
    }

    public String getWsdlUrl() {
        return this.wsdlUrl;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getContext() {
        return this.context;
    }

    public void setContextTemplate(String contextTemplate) {
        this.contextTemplate = contextTemplate;
    }

    public String getContextTemplate() {
        return this.contextTemplate;
    }

    public void setWsdlUrl(String wsdlUrl) {
        this.wsdlUrl = wsdlUrl;
    }

    public String getThumbnailUrl() {
        return this.thumbnailUrl;
    }

    public void setThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
    }

    public Set<String> getTags() {
        return Collections.unmodifiableSet(this.tags);
    }

    @Deprecated
    public void addTags(Set<String> tags) {
        this.tags.addAll(tags);
    }

    public void setTags(Set<String> tags) {
        this.tags.addAll(tags);
    }

    public void removeTags(Set<String> tags) {
        this.tags.removeAll(tags);
    }

    public Set<Documentation> getDocuments() {
        return Collections.unmodifiableSet(this.documents);
    }

    public void addDocuments(Set<Documentation> documents) {
        this.documents.addAll(documents);
    }

    public void removeDocuments(Set<Documentation> documents) {
        this.documents.removeAll(documents);
    }

    public String getHttpVerb() {
        return this.httpVerb;
    }

    public void setHttpVerb(String httpVerb) {
        this.httpVerb = httpVerb;
    }

    public Date getLastUpdated() {
        if (this.lastUpdated != null) {
            return new Date(this.lastUpdated.getTime());
        }
        return null;
    }

    public void setLastUpdated(Date lastUpdated) {
        if (lastUpdated != null) {
            this.lastUpdated = new Date(lastUpdated.getTime());
        }
    }

    public Set<Tier> getAvailableTiers() {
        return Collections.unmodifiableSet(this.availableTiers);
    }

    @Deprecated
    public void addAvailableTiers(Set<Tier> availableTiers) {
        this.availableTiers.addAll(availableTiers);
    }

    public void setAvailableTiers(Set<Tier> availableTiers) {
        this.availableTiers.addAll(availableTiers);
    }

    public void removeAllTiers() {
        this.availableTiers.clear();
    }

    public void removeAllPolicies() {
        this.availableSubscriptionLevelPolicies.clear();
    }

    public void removeAvailableTiers(Set<Tier> availableTiers) {
        this.availableTiers.removeAll(availableTiers);
    }

    public Set<URITemplate> getUriTemplates() {
        return this.uriTemplates;
    }

    public void setUriTemplates(Set<URITemplate> uriTemplates) {
        this.uriTemplates = uriTemplates;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setStatus(APIStatus status) {
        this.status = status.getStatus();
    }

    public float getRating() {
        return this.rating;
    }

    public void setRating(float rating) {
        this.rating = rating;
    }

    public void setLatest(boolean latest) {
        this.isLatest = latest;
    }

    public boolean isLatest() {
        return this.isLatest;
    }

    public AuthorizationPolicy getAuthorizationPolicy() {
        return this.authorizationPolicy;
    }

    public void setAuthorizationPolicy(AuthorizationPolicy authorizationPolicy) {
        this.authorizationPolicy = authorizationPolicy;
    }

    public String getWadlUrl() {
        return this.wadlUrl;
    }

    public void setWadlUrl(String wadlUrl) {
        this.wadlUrl = wadlUrl;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public String getVisibleRoles() {
        return this.visibleRoles;
    }

    public void setVisibleRoles(String visibleRoles) {
        this.visibleRoles = visibleRoles;
    }

    public String getVisibleTenants() {
        return this.visibleTenants;
    }

    public void setVisibleTenants(String visibleTenants) {
        this.visibleTenants = visibleTenants;
    }

    public boolean isApiHeaderChanged() {
        return this.apiHeaderChanged;
    }

    public void setApiHeaderChanged(boolean apiHeaderChanged) {
        this.apiHeaderChanged = apiHeaderChanged;
    }

    public boolean isApiResourcePatternsChanged() {
        return this.apiResourcePatternsChanged;
    }

    public void setApiResourcePatternsChanged(boolean apiResourcePatternsChanged) {
        this.apiResourcePatternsChanged = apiResourcePatternsChanged;
    }

    public String getEndpointUTUsername() {
        return this.endpointUTUsername;
    }

    public void setEndpointUTUsername(String endpointUTUsername) {
        this.endpointUTUsername = endpointUTUsername;
    }

    public String getEndpointUTPassword() {
        return this.endpointUTPassword;
    }

    public void setEndpointUTPassword(String endpointUTPassword) {
        this.endpointUTPassword = endpointUTPassword;
    }

    public boolean isEndpointSecured() {
        return this.endpointSecured;
    }

    public void setEndpointSecured(boolean endpointSecured) {
        this.endpointSecured = endpointSecured;
    }

    public boolean isEndpointAuthDigest() {
        return this.endpointAuthDigest;
    }

    public void setEndpointAuthDigest(boolean endpointAuthDigest) {
        this.endpointAuthDigest = endpointAuthDigest;
    }

    public String getInSequence() {
        return this.inSequence;
    }

    public void setInSequence(String inSeq) {
        this.inSequence = inSeq;
    }

    public String getOutSequence() {
        return this.outSequence;
    }

    public void setOutSequence(String outSeq) {
        this.outSequence = outSeq;
    }

    public void removeCustomSequences() {
        this.inSequence = null;
        this.outSequence = null;
        this.faultSequence = null;
    }

    public String getOldInSequence() {
        return this.oldInSequence;
    }

    public void setOldInSequence(String oldInSequence) {
        this.oldInSequence = oldInSequence;
    }

    public String getOldOutSequence() {
        return this.oldOutSequence;
    }

    public void setOldOutSequence(String oldOutSequence) {
        this.oldOutSequence = oldOutSequence;
    }

    public String getSubscriptionAvailability() {
        return this.subscriptionAvailability;
    }

    public void setSubscriptionAvailability(String subscriptionAvailability) {
        this.subscriptionAvailability = subscriptionAvailability;
    }

    public String getSubscriptionAvailableTenants() {
        return this.subscriptionAvailableTenants;
    }

    public void setSubscriptionAvailableTenants(String subscriptionAvailableTenants) {
        this.subscriptionAvailableTenants = subscriptionAvailableTenants;
    }

    public String getEndpointConfig() {
        if (this.endpointConfig == null || StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{this.endpointConfig}) && this.endpoints.size() > 0) {
            return API.getEndpointConfigString(this.endpoints);
        }
        return this.endpointConfig;
    }

    public void setEndpointConfig(String endpointConfig) {
        this.endpointConfig = endpointConfig;
    }

    public String getResponseCache() {
        return this.responseCache;
    }

    public void setResponseCache(String responseCache) {
        this.responseCache = responseCache;
    }

    public int getCacheTimeout() {
        return this.cacheTimeout;
    }

    public void setCacheTimeout(int cacheTimeout) {
        this.cacheTimeout = cacheTimeout;
    }

    public String getFaultSequence() {
        return this.faultSequence;
    }

    public void setFaultSequence(String faultSequence) {
        this.faultSequence = faultSequence;
    }

    public String getOldFaultSequence() {
        return this.oldFaultSequence;
    }

    public void setOldFaultSequence(String oldFaultSequence) {
        this.oldFaultSequence = oldFaultSequence;
    }

    public Set<Scope> getScopes() {
        return this.scopes;
    }

    public void setScopes(Set<Scope> scopes) {
        this.scopes = scopes;
    }

    @Deprecated
    public void setAsDefaultVersion(boolean value) {
        this.isDefaultVersion = value;
    }

    public void setDefaultVersion(boolean isDefaultVersion) {
        this.isDefaultVersion = isDefaultVersion;
    }

    public void setAsPublishedDefaultVersion(boolean value) {
        this.isPublishedDefaultVersion = value;
    }

    public boolean isDefaultVersion() {
        return this.isDefaultVersion;
    }

    public boolean isPublishedDefaultVersion() {
        return this.isPublishedDefaultVersion;
    }

    public CORSConfiguration getCorsConfiguration() {
        return this.corsConfiguration;
    }

    public void setCorsConfiguration(CORSConfiguration corsConfiguration) {
        this.corsConfiguration = corsConfiguration;
    }

    public String getMonetizationCategory() {
        return this.monetizationCategory;
    }

    public void setMonetizationCategory(String monetizationCategory) {
        this.monetizationCategory = monetizationCategory;
    }

    public WebsubSubscriptionConfiguration getWebsubSubscriptionConfiguration() {
        return this.websubSubscriptionConfiguration;
    }

    public void setWebsubSubscriptionConfiguration(WebsubSubscriptionConfiguration websubSubscriptionConfiguration) {
        this.websubSubscriptionConfiguration = websubSubscriptionConfiguration;
    }

    public WebSocketTopicMappingConfiguration getWebSocketTopicMappingConfiguration() {
        return this.webSocketTopicMappingConfiguration;
    }

    public void setWebSocketTopicMappingConfiguration(WebSocketTopicMappingConfiguration webSocketTopicMappingConfiguration) {
        this.webSocketTopicMappingConfiguration = webSocketTopicMappingConfiguration;
    }

    public Map<String, String> getWsUriMapping() {
        return this.wsUriMapping;
    }

    public void setWsUriMapping(Map<String, String> wsUriMapping) {
        this.wsUriMapping = wsUriMapping;
    }

    public String getApiLevelPolicy() {
        return this.apiLevelPolicy;
    }

    public void setApiLevelPolicy(String apiLevelPolicy) {
        this.apiLevelPolicy = apiLevelPolicy;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = StringUtils.isEmpty((CharSequence)type) || NULL_VALUE.equalsIgnoreCase(StringUtils.trim((String)type)) ? "HTTP" : StringUtils.trim((String)type).toUpperCase();
    }

    public String getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(String createdTime) {
        this.createdTime = createdTime;
    }

    public String getAccessControlRoles() {
        return this.accessControlRoles;
    }

    public void setAccessControlRoles(String accessControlRoles) {
        this.accessControlRoles = accessControlRoles;
    }

    public String getAccessControl() {
        return this.accessControl;
    }

    public void setAccessControl(String accessControl) {
        this.accessControl = accessControl;
    }

    public String getAuthorizationHeader() {
        return this.authorizationHeader;
    }

    public void setAuthorizationHeader(String authorizationHeader) {
        this.authorizationHeader = authorizationHeader;
    }

    @Deprecated
    public boolean isEnabledSchemaValidation() {
        return this.enableSchemaValidation;
    }

    public void setEnableSchemaValidation(boolean enableSchemaValidation) {
        this.enableSchemaValidation = enableSchemaValidation;
    }

    public boolean isEnableSchemaValidation() {
        return this.enableSchemaValidation;
    }

    public void setApiSecurity(String apiSecurity) {
        if (apiSecurity != null) {
            this.apiSecurity = apiSecurity;
        }
    }

    public String getApiSecurity() {
        return this.apiSecurity;
    }

    public String getWsdlArchivePath() {
        return this.wsdlArchivePath;
    }

    public void setWsdlArchivePath(String wsdlArchivePath) {
        this.wsdlArchivePath = wsdlArchivePath;
    }

    public ResourceFile getWsdlResource() {
        return this.wsdlResource;
    }

    public void setWsdlResource(ResourceFile wsdl) {
        this.wsdlResource = wsdl;
    }

    public String getWorkflowStatus() {
        return this.workflowStatus;
    }

    public void setWorkflowStatus(String workflowStatus) {
        this.workflowStatus = workflowStatus;
    }

    public List<APIEndpoint> getEndpoint() {
        return this.endpoints;
    }

    public void setEndpoint(List<APIEndpoint> endpoint) {
        this.endpoints = endpoint;
    }

    public boolean isEnableStore() {
        return this.enableStore;
    }

    public void setEnableStore(boolean enableStore) {
        this.enableStore = enableStore;
    }

    public String getTestKey() {
        return this.testKey;
    }

    public void setTestKey(String testKey) {
        this.testKey = testKey;
    }

    public static String getEndpointConfigString(List<APIEndpoint> endpoints) {
        StringBuilder sb = new StringBuilder();
        if (endpoints != null && endpoints.size() > 0) {
            sb.append("{");
            for (APIEndpoint endpoint : endpoints) {
                sb.append("\"").append(endpoint.getType()).append("\": {\"url\":\"").append(endpoint.getInline().getEndpointConfig().getList().get(0).getUrl()).append("\",\"timeout\":\"").append(endpoint.getInline().getEndpointConfig().getList().get(0).getTimeout()).append("\",\"key\":\"").append(endpoint.getKey()).append("\"},");
            }
            sb.append("\"endpoint_type\" : \"").append(endpoints.get(0).getInline().getType()).append("\"}\n");
        }
        return sb.toString();
    }

    public void setApiCategories(List<APICategory> apiCategories) {
        this.apiCategories = apiCategories;
    }

    public List<APICategory> getApiCategories() {
        return this.apiCategories;
    }

    public List<String> getKeyManagers() {
        return this.keyManagers;
    }

    public void setKeyManagers(List<String> keyManagers) {
        this.keyManagers = keyManagers;
    }

    public Mediation getInSequenceMediation() {
        return this.inSequenceMediation;
    }

    public void setInSequenceMediation(Mediation inSequenceMediation) {
        this.inSequenceMediation = inSequenceMediation;
    }

    public Mediation getOutSequenceMediation() {
        return this.outSequenceMediation;
    }

    public void setOutSequenceMediation(Mediation outSequenceMediation) {
        this.outSequenceMediation = outSequenceMediation;
    }

    public Mediation getFaultSequenceMediation() {
        return this.faultSequenceMediation;
    }

    public void setFaultSequenceMediation(Mediation faultSequenceMediation) {
        this.faultSequenceMediation = faultSequenceMediation;
    }

    public boolean isRevision() {
        return this.isRevision;
    }

    public void setRevision(boolean revision) {
        this.isRevision = revision;
    }

    public String getRevisionedApiId() {
        return this.revisionedApiId;
    }

    public void setRevisionedApiId(String revisionedApiId) {
        this.revisionedApiId = revisionedApiId;
    }

    public int getRevisionId() {
        return this.revisionId;
    }

    public void setRevisionId(int revisionId) {
        this.revisionId = revisionId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof API)) {
            return false;
        }
        return Objects.equals(this.id, ((API)o).id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean isAsync() {
        return "WS".equals(this.type) || "WEBSUB".equals(this.type) || "SSE".equals(this.type);
    }
}

