/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.api;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.simple.JSONObject;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.APIManager;
import org.wso2.carbon.apimgt.api.FaultGatewaysException;
import org.wso2.carbon.apimgt.api.doc.model.APIResource;
import org.wso2.carbon.apimgt.api.dto.CertificateInformationDTO;
import org.wso2.carbon.apimgt.api.dto.CertificateMetadataDTO;
import org.wso2.carbon.apimgt.api.dto.ClientCertificateDTO;
import org.wso2.carbon.apimgt.api.dto.UserApplicationAPIUsage;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.APIProduct;
import org.wso2.carbon.apimgt.api.model.APIProductIdentifier;
import org.wso2.carbon.apimgt.api.model.APIProductResource;
import org.wso2.carbon.apimgt.api.model.APIRevision;
import org.wso2.carbon.apimgt.api.model.APIRevisionDeployment;
import org.wso2.carbon.apimgt.api.model.APIStateChangeResponse;
import org.wso2.carbon.apimgt.api.model.APIStatus;
import org.wso2.carbon.apimgt.api.model.APIStore;
import org.wso2.carbon.apimgt.api.model.ApiTypeWrapper;
import org.wso2.carbon.apimgt.api.model.BlockConditionsDTO;
import org.wso2.carbon.apimgt.api.model.Comment;
import org.wso2.carbon.apimgt.api.model.CommentList;
import org.wso2.carbon.apimgt.api.model.Documentation;
import org.wso2.carbon.apimgt.api.model.DocumentationContent;
import org.wso2.carbon.apimgt.api.model.DuplicateAPIException;
import org.wso2.carbon.apimgt.api.model.Identifier;
import org.wso2.carbon.apimgt.api.model.LifeCycleEvent;
import org.wso2.carbon.apimgt.api.model.Mediation;
import org.wso2.carbon.apimgt.api.model.Monetization;
import org.wso2.carbon.apimgt.api.model.Provider;
import org.wso2.carbon.apimgt.api.model.ResourceFile;
import org.wso2.carbon.apimgt.api.model.ResourcePath;
import org.wso2.carbon.apimgt.api.model.Scope;
import org.wso2.carbon.apimgt.api.model.SharedScopeUsage;
import org.wso2.carbon.apimgt.api.model.SubscribedAPI;
import org.wso2.carbon.apimgt.api.model.Subscriber;
import org.wso2.carbon.apimgt.api.model.Tier;
import org.wso2.carbon.apimgt.api.model.URITemplate;
import org.wso2.carbon.apimgt.api.model.Usage;
import org.wso2.carbon.apimgt.api.model.policy.APIPolicy;
import org.wso2.carbon.apimgt.api.model.policy.ApplicationPolicy;
import org.wso2.carbon.apimgt.api.model.policy.GlobalPolicy;
import org.wso2.carbon.apimgt.api.model.policy.Policy;
import org.wso2.carbon.apimgt.api.model.policy.SubscriptionPolicy;

public interface APIProvider
extends APIManager {
    public String addComment(Identifier var1, Comment var2, String var3) throws APIManagementException;

    public Comment getComment(ApiTypeWrapper var1, String var2, Integer var3, Integer var4) throws APIManagementException;

    public CommentList getComments(ApiTypeWrapper var1, String var2, Integer var3, Integer var4) throws APIManagementException;

    public boolean editComment(ApiTypeWrapper var1, String var2, Comment var3) throws APIManagementException;

    public boolean deleteComment(ApiTypeWrapper var1, String var2) throws APIManagementException;

    public Set<Provider> getAllProviders() throws APIManagementException;

    public List<API> getAPIsByProvider(String var1) throws APIManagementException;

    public Set<Subscriber> getSubscribersOfProvider(String var1) throws APIManagementException;

    public Provider getProvider(String var1) throws APIManagementException;

    public Usage getUsageByAPI(APIIdentifier var1);

    public Usage getAPIUsageByUsers(String var1, String var2);

    public UserApplicationAPIUsage[] getAllAPIUsageByProvider(String var1) throws APIManagementException;

    public List<SubscribedAPI> getAPIUsageByAPIId(APIIdentifier var1) throws APIManagementException;

    public List<SubscribedAPI> getAPIProductUsageByAPIProductId(APIProductIdentifier var1) throws APIManagementException;

    public Usage getAPIUsageBySubscriber(APIIdentifier var1, String var2);

    public Set<Subscriber> getSubscribersOfAPI(APIIdentifier var1) throws APIManagementException;

    public List<SubscribedAPI> getSubscriptionsOfAPI(String var1, String var2, String var3) throws APIManagementException;

    public long getAPISubscriptionCountByAPI(APIIdentifier var1) throws APIManagementException;

    public String getSubscriber(String var1) throws APIManagementException;

    public Map getSubscriberClaims(String var1) throws APIManagementException;

    public void addTier(Tier var1) throws APIManagementException;

    public void addPolicy(Policy var1) throws APIManagementException;

    public void deleteSubscriptionBlockCondition(String var1) throws APIManagementException;

    public String getAPIContext(APIIdentifier var1) throws APIManagementException;

    public APIPolicy getAPIPolicy(String var1, String var2) throws APIManagementException;

    public APIPolicy getAPIPolicyByUUID(String var1) throws APIManagementException;

    public ApplicationPolicy getApplicationPolicy(String var1, String var2) throws APIManagementException;

    public ApplicationPolicy getApplicationPolicyByUUID(String var1) throws APIManagementException;

    public SubscriptionPolicy getSubscriptionPolicy(String var1, String var2) throws APIManagementException;

    public SubscriptionPolicy getSubscriptionPolicyByUUID(String var1) throws APIManagementException;

    public GlobalPolicy getGlobalPolicy(String var1) throws APIManagementException;

    public GlobalPolicy getGlobalPolicyByUUID(String var1) throws APIManagementException;

    public boolean isGlobalPolicyKeyTemplateExists(GlobalPolicy var1) throws APIManagementException;

    public void updatePolicy(Policy var1) throws APIManagementException;

    public void updateTier(Tier var1) throws APIManagementException;

    public void removeTier(Tier var1) throws APIManagementException;

    public String getDefaultVersion(APIIdentifier var1) throws APIManagementException;

    public API addAPI(API var1) throws APIManagementException;

    public boolean isAPIUpdateValid(API var1) throws APIManagementException;

    public void updateAPI(API var1) throws APIManagementException, FaultGatewaysException;

    public API updateAPI(API var1, API var2) throws APIManagementException, FaultGatewaysException;

    public void manageAPI(API var1) throws APIManagementException, FaultGatewaysException;

    public void updateWsdlFromResourceFile(API var1) throws APIManagementException;

    public void updateWsdlFromUrl(API var1) throws APIManagementException;

    public void makeAPIKeysForwardCompatible(API var1) throws APIManagementException;

    public void createNewAPIVersion(API var1, String var2) throws DuplicateAPIException, APIManagementException;

    public API createNewAPIVersion(String var1, String var2, Boolean var3, String var4) throws APIManagementException;

    public String retrieveServiceKeyByApiId(int var1, int var2) throws APIManagementException;

    public void removeDocumentation(APIIdentifier var1, String var2, String var3, String var4) throws APIManagementException;

    public void removeDocumentation(String var1, String var2, String var3) throws APIManagementException;

    public void removeDocumentation(Identifier var1, String var2, String var3) throws APIManagementException;

    public void addDocumentation(Identifier var1, Documentation var2) throws APIManagementException;

    public Documentation addDocumentation(String var1, Documentation var2, String var3) throws APIManagementException;

    public void addDocumentationContent(String var1, String var2, String var3, DocumentationContent var4) throws APIManagementException;

    public void addFileToDocumentation(APIIdentifier var1, Documentation var2, String var3, InputStream var4, String var5) throws APIManagementException;

    public boolean checkIfAPIExists(APIIdentifier var1) throws APIManagementException;

    public void addDocumentationContent(API var1, String var2, String var3) throws APIManagementException;

    public Documentation updateDocumentation(String var1, Documentation var2, String var3) throws APIManagementException;

    public void copyAllDocumentation(APIIdentifier var1, String var2) throws APIManagementException;

    public List<LifeCycleEvent> getLifeCycleEvents(APIIdentifier var1) throws APIManagementException;

    public List<API> searchAPIs(String var1, String var2, String var3) throws APIManagementException;

    public void updateSubscription(APIIdentifier var1, String var2, int var3) throws APIManagementException;

    public void updateSubscription(SubscribedAPI var1) throws APIManagementException;

    public void updateTierPermissions(String var1, String var2, String var3) throws APIManagementException;

    public void deleteTierPermissions(String var1) throws APIManagementException;

    public Set getTierPermissions() throws APIManagementException;

    public Object getThrottleTierPermission(String var1) throws APIManagementException;

    public void updateThrottleTierPermissions(String var1, String var2, String var3) throws APIManagementException;

    public Set getThrottleTierPermissions() throws APIManagementException;

    public List<String> getCustomInSequences() throws APIManagementException;

    public List<String> getCustomOutSequences() throws APIManagementException;

    public List<String> getCustomInSequences(APIIdentifier var1) throws APIManagementException;

    public List<String> getCustomOutSequences(APIIdentifier var1) throws APIManagementException;

    public List<String> getCustomFaultSequences() throws APIManagementException;

    public List<String> getCustomFaultSequences(APIIdentifier var1) throws APIManagementException;

    public List<String> getCustomApiInSequences(APIIdentifier var1) throws APIManagementException;

    public List<String> getCustomApiOutSequences(APIIdentifier var1) throws APIManagementException;

    public List<String> getCustomApiFaultSequences(APIIdentifier var1) throws APIManagementException;

    public boolean publishToExternalAPIStores(API var1, List<String> var2) throws APIManagementException;

    public void publishToExternalAPIStores(API var1, Set<APIStore> var2, boolean var3) throws APIManagementException;

    public boolean updateAPIsInExternalAPIStores(API var1, Set<APIStore> var2, boolean var3) throws APIManagementException;

    public Set<APIStore> getExternalAPIStores(APIIdentifier var1) throws APIManagementException;

    public Set<APIStore> getPublishedExternalAPIStores(APIIdentifier var1) throws APIManagementException;

    public boolean isSynapseGateway() throws APIManagementException;

    public Map<Documentation, API> searchAPIsByDoc(String var1, String var2) throws APIManagementException;

    public String[] getConsumerKeys(APIIdentifier var1) throws APIManagementException;

    public void saveSwagger20Definition(APIIdentifier var1, String var2, String var3) throws APIManagementException;

    public void saveSwagger20Definition(APIProductIdentifier var1, String var2) throws APIManagementException;

    public void saveSwaggerDefinition(API var1, String var2, String var3) throws APIManagementException;

    public void saveSwaggerDefinition(String var1, String var2, String var3) throws APIManagementException;

    public void saveSwaggerDefinition(APIProduct var1, String var2) throws APIManagementException;

    public void addAPIProductSwagger(String var1, Map<API, List<APIProductResource>> var2, APIProduct var3, String var4) throws APIManagementException;

    public void updateAPIProductSwagger(String var1, Map<API, List<APIProductResource>> var2, APIProduct var3, String var4) throws APIManagementException, FaultGatewaysException;

    public void validateResourceThrottlingTiers(API var1, String var2) throws APIManagementException;

    public void validateResourceThrottlingTiers(String var1, String var2) throws APIManagementException;

    public void validateAPIThrottlingTier(API var1, String var2) throws APIManagementException;

    public void validateProductThrottlingTier(APIProduct var1, String var2) throws APIManagementException;

    public void configureMonetizationInAPIArtifact(API var1) throws APIManagementException;

    public void configureMonetizationInAPIProductArtifact(APIProduct var1) throws APIManagementException;

    public Monetization getMonetizationImplClass() throws APIManagementException;

    public APIStateChangeResponse changeLifeCycleStatus(APIIdentifier var1, String var2) throws APIManagementException, FaultGatewaysException;

    public APIStateChangeResponse changeLifeCycleStatus(String var1, String var2, String var3, Map<String, Boolean> var4) throws APIManagementException, FaultGatewaysException;

    public boolean changeAPILCCheckListItems(APIIdentifier var1, int var2, boolean var3) throws APIManagementException;

    public boolean checkAndChangeAPILCCheckListItem(APIIdentifier var1, String var2, boolean var3) throws APIManagementException;

    public Map<String, Object> getAPILifeCycleData(APIIdentifier var1) throws APIManagementException;

    public Map<String, Object> getAPILifeCycleData(String var1, String var2) throws APIManagementException;

    public Map<String, String> propergateAPIStatusChangeToGateways(APIIdentifier var1, String var2) throws APIManagementException;

    public Map<String, String> propergateAPIStatusChangeToGateways(APIIdentifier var1, APIStatus var2) throws APIManagementException;

    public boolean updateAPIforStateChange(APIIdentifier var1, String var2, Map<String, String> var3) throws APIManagementException, FaultGatewaysException;

    public boolean updateAPIforStateChange(APIIdentifier var1, APIStatus var2, Map<String, String> var3) throws APIManagementException, FaultGatewaysException;

    public String getAPILifeCycleStatus(APIIdentifier var1) throws APIManagementException;

    public Map<String, Object> getAllPaginatedAPIs(String var1, int var2, int var3) throws APIManagementException;

    public String[] getPolicyNames(String var1, String var2) throws APIManagementException;

    public void deletePolicy(String var1, String var2, String var3) throws APIManagementException;

    public boolean hasAttachments(String var1, String var2, String var3) throws APIManagementException;

    public List<BlockConditionsDTO> getBlockConditions() throws APIManagementException;

    public BlockConditionsDTO getBlockCondition(int var1) throws APIManagementException;

    public BlockConditionsDTO getBlockConditionByUUID(String var1) throws APIManagementException;

    public boolean updateBlockCondition(int var1, String var2) throws APIManagementException;

    public boolean updateBlockConditionByUUID(String var1, String var2) throws APIManagementException;

    public String addBlockCondition(String var1, String var2) throws APIManagementException;

    public String addBlockCondition(String var1, String var2, boolean var3) throws APIManagementException;

    public boolean deleteBlockCondition(int var1) throws APIManagementException;

    public boolean deleteBlockConditionByUUID(String var1) throws APIManagementException;

    public String getLifecycleConfiguration(String var1) throws APIManagementException;

    public String getExternalWorkflowReferenceId(int var1) throws APIManagementException;

    public int addCertificate(String var1, String var2, String var3, String var4) throws APIManagementException;

    public int addClientCertificate(String var1, APIIdentifier var2, String var3, String var4, String var5) throws APIManagementException;

    public int deleteCertificate(String var1, String var2, String var3) throws APIManagementException;

    public int deleteClientCertificate(String var1, APIIdentifier var2, String var3) throws APIManagementException;

    public boolean isConfigured();

    public List<CertificateMetadataDTO> getCertificates(String var1) throws APIManagementException;

    public List<CertificateMetadataDTO> searchCertificates(int var1, String var2, String var3) throws APIManagementException;

    public List<ClientCertificateDTO> searchClientCertificates(int var1, String var2, APIIdentifier var3) throws APIManagementException;

    public List<ClientCertificateDTO> searchClientCertificates(int var1, String var2, APIProductIdentifier var3) throws APIManagementException;

    public int getCertificateCountPerTenant(int var1) throws APIManagementException;

    public int getClientCertificateCount(int var1) throws APIManagementException;

    public boolean isCertificatePresent(int var1, String var2) throws APIManagementException;

    public ClientCertificateDTO getClientCertificate(int var1, String var2) throws APIManagementException;

    public ClientCertificateDTO getClientCertificate(int var1, String var2, APIIdentifier var3) throws APIManagementException;

    public CertificateInformationDTO getCertificateStatus(String var1) throws APIManagementException;

    public int updateCertificate(String var1, String var2) throws APIManagementException;

    public int updateClientCertificate(String var1, String var2, APIIdentifier var3, String var4, int var5) throws APIManagementException;

    public ByteArrayInputStream getCertificateContent(String var1) throws APIManagementException;

    public String getSequenceFileContent(APIIdentifier var1, String var2, String var3) throws APIManagementException;

    public Map<API, List<APIProductResource>> addAPIProductWithoutPublishingToGateway(APIProduct var1) throws APIManagementException;

    public void saveToGateway(APIProduct var1) throws FaultGatewaysException, APIManagementException;

    public void deleteAPIProduct(APIProductIdentifier var1, String var2) throws APIManagementException;

    public Map<API, List<APIProductResource>> updateAPIProduct(APIProduct var1) throws APIManagementException, FaultGatewaysException;

    public List<ResourcePath> getResourcePathsOfAPI(APIIdentifier var1) throws APIManagementException;

    public void updateDocumentation(APIProductIdentifier var1, Documentation var2) throws APIManagementException;

    public void addFileToProductDocumentation(APIProductIdentifier var1, Documentation var2, String var3, InputStream var4, String var5) throws APIManagementException;

    public void addProductDocumentationContent(APIProduct var1, String var2, String var3) throws APIManagementException;

    public void saveGraphqlSchemaDefinition(API var1, String var2) throws APIManagementException;

    public void deleteWorkflowTask(APIIdentifier var1) throws APIManagementException;

    public JSONObject getSecurityAuditAttributesFromConfig(String var1) throws APIManagementException;

    public List<APIResource> getResourcesToBeRemovedFromAPIProducts(APIIdentifier var1, String var2) throws APIManagementException;

    public List<APIResource> getRemovedProductResources(Set<URITemplate> var1, API var2);

    public boolean isSharedScopeNameExists(String var1, String var2) throws APIManagementException;

    public String addSharedScope(Scope var1, String var2) throws APIManagementException;

    public List<Scope> getAllSharedScopes(String var1) throws APIManagementException;

    public Set<String> getAllSharedScopeKeys(String var1) throws APIManagementException;

    public Scope getSharedScopeByUUID(String var1, String var2) throws APIManagementException;

    public void deleteSharedScope(String var1, String var2) throws APIManagementException;

    public void updateSharedScope(Scope var1, String var2) throws APIManagementException;

    public void validateSharedScopes(Set<Scope> var1, String var2) throws APIManagementException;

    public SharedScopeUsage getSharedScopeUsage(String var1, int var2) throws APIManagementException;

    public List<APIResource> getUsedProductResources(APIIdentifier var1) throws APIManagementException;

    public void deleteAPI(API var1) throws APIManagementException;

    public boolean isDocumentationExist(String var1, String var2, String var3) throws APIManagementException;

    public void addWSDLResource(String var1, ResourceFile var2, String var3, String var4) throws APIManagementException;

    public void setThumbnailToAPI(String var1, ResourceFile var2, String var3) throws APIManagementException;

    public List<Mediation> getAllApiSpecificMediationPolicies(String var1, String var2) throws APIManagementException;

    public Mediation getApiSpecificMediationPolicyByPolicyId(String var1, String var2, String var3) throws APIManagementException;

    public Mediation addApiSpecificMediationPolicy(String var1, Mediation var2, String var3) throws APIManagementException;

    public Mediation updateApiSpecificMediationPolicyContent(String var1, Mediation var2, String var3) throws APIManagementException;

    public void deleteApiSpecificMediationPolicy(String var1, String var2, String var3) throws APIManagementException;

    public void saveGraphqlSchemaDefinition(String var1, String var2, String var3) throws APIManagementException;

    @Override
    public APIProduct getAPIProductbyUUID(String var1, String var2) throws APIManagementException;

    public void deleteAPIProduct(APIProduct var1) throws APIManagementException;

    public String addAPIRevision(APIRevision var1, String var2) throws APIManagementException;

    public APIRevision getAPIRevision(String var1) throws APIManagementException;

    public String getAPIRevisionUUID(String var1, String var2) throws APIManagementException;

    public String getEarliestRevisionUUID(String var1) throws APIManagementException;

    public String getLatestRevisionUUID(String var1) throws APIManagementException;

    public List<APIRevision> getAPIRevisions(String var1) throws APIManagementException;

    public void deployAPIRevision(String var1, String var2, List<APIRevisionDeployment> var3) throws APIManagementException;

    public void updateAPIDisplayOnDevportal(String var1, String var2, APIRevisionDeployment var3) throws APIManagementException;

    public void updateAPIProductDisplayOnDevportal(String var1, String var2, APIRevisionDeployment var3) throws APIManagementException;

    public APIRevisionDeployment getAPIRevisionDeployment(String var1, String var2) throws APIManagementException;

    public List<APIRevisionDeployment> getAPIRevisionDeploymentList(String var1) throws APIManagementException;

    public void undeployAPIRevisionDeployment(String var1, String var2, List<APIRevisionDeployment> var3) throws APIManagementException;

    public void restoreAPIRevision(String var1, String var2, String var3) throws APIManagementException;

    public void deleteAPIRevision(String var1, String var2, String var3) throws APIManagementException;

    public void saveAsyncApiDefinition(API var1, String var2) throws APIManagementException;

    public String addAPIProductRevision(APIRevision var1) throws APIManagementException;

    public void deployAPIProductRevision(String var1, String var2, List<APIRevisionDeployment> var3) throws APIManagementException;

    public void undeployAPIProductRevisionDeployment(String var1, String var2, List<APIRevisionDeployment> var3) throws APIManagementException;

    public void restoreAPIProductRevision(String var1, String var2) throws APIManagementException;

    public void deleteAPIProductRevision(String var1, String var2) throws APIManagementException;

    public String generateApiKey(String var1) throws APIManagementException;
}

