/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.api;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.APIInfo;
import org.wso2.carbon.apimgt.api.model.APIProduct;
import org.wso2.carbon.apimgt.api.model.APIProductIdentifier;
import org.wso2.carbon.apimgt.api.model.APIProductResource;
import org.wso2.carbon.apimgt.api.model.ApiTypeWrapper;
import org.wso2.carbon.apimgt.api.model.Application;
import org.wso2.carbon.apimgt.api.model.Documentation;
import org.wso2.carbon.apimgt.api.model.DocumentationContent;
import org.wso2.carbon.apimgt.api.model.DocumentationType;
import org.wso2.carbon.apimgt.api.model.Identifier;
import org.wso2.carbon.apimgt.api.model.Mediation;
import org.wso2.carbon.apimgt.api.model.ResourceFile;
import org.wso2.carbon.apimgt.api.model.SubscribedAPI;
import org.wso2.carbon.apimgt.api.model.Subscriber;
import org.wso2.carbon.apimgt.api.model.Tier;
import org.wso2.carbon.apimgt.api.model.Wsdl;
import org.wso2.carbon.apimgt.api.model.graphql.queryanalysis.GraphqlComplexityInfo;
import org.wso2.carbon.apimgt.api.model.policy.Policy;
import org.wso2.carbon.registry.api.Resource;

public interface APIManager {
    public List<API> getAllAPIs() throws APIManagementException;

    public API getAPI(String var1) throws APIManagementException;

    public API getAPIbyUUID(String var1, String var2) throws APIManagementException;

    public APIInfo getAPIInfoByUUID(String var1) throws APIManagementException;

    public ApiTypeWrapper getAPIorAPIProductByUUID(String var1, String var2) throws APIManagementException;

    public API getLightweightAPIByUUID(String var1, String var2) throws APIManagementException;

    public API getLightweightAPI(APIIdentifier var1) throws APIManagementException;

    public API getAPI(APIIdentifier var1) throws APIManagementException;

    public boolean isAPIAvailable(APIIdentifier var1) throws APIManagementException;

    public boolean isAPIProductAvailable(APIProductIdentifier var1) throws APIManagementException;

    public boolean isContextExist(String var1) throws APIManagementException;

    public boolean isApiNameExist(String var1) throws APIManagementException;

    public boolean isApiNameWithDifferentCaseExist(String var1) throws APIManagementException;

    public Set<String> getAPIVersions(String var1, String var2) throws APIManagementException;

    public String getGraphqlSchemaDefinition(APIIdentifier var1) throws APIManagementException;

    public String getGraphqlSchemaDefinition(String var1, String var2) throws APIManagementException;

    public String getOpenAPIDefinition(Identifier var1, String var2) throws APIManagementException;

    public String getOpenAPIDefinition(String var1, String var2) throws APIManagementException;

    public String getAsyncAPIDefinition(String var1, String var2) throws APIManagementException;

    public boolean isDocumentationExist(Identifier var1, String var2) throws APIManagementException;

    public List<Documentation> getAllDocumentation(Identifier var1) throws APIManagementException;

    public List<Documentation> getAllDocumentation(APIIdentifier var1, String var2) throws APIManagementException;

    public List<Documentation> getAllDocumentation(String var1, String var2) throws APIManagementException;

    public Documentation getDocumentation(APIIdentifier var1, DocumentationType var2, String var3) throws APIManagementException;

    public Documentation getDocumentation(String var1, String var2, String var3) throws APIManagementException;

    public DocumentationContent getDocumentationContent(String var1, String var2, String var3) throws APIManagementException;

    public String getDocumentationContent(Identifier var1, String var2) throws APIManagementException;

    public GraphqlComplexityInfo getComplexityDetails(APIIdentifier var1) throws APIManagementException;

    public void addOrUpdateComplexityDetails(APIIdentifier var1, GraphqlComplexityInfo var2) throws APIManagementException;

    public Subscriber getSubscriberById(String var1) throws APIManagementException;

    public SubscribedAPI getSubscriptionByUUID(String var1) throws APIManagementException;

    public void addSubscriber(String var1, String var2) throws APIManagementException;

    public void updateSubscriber(Subscriber var1) throws APIManagementException;

    public Subscriber getSubscriber(int var1) throws APIManagementException;

    public Set<API> getSubscriberAPIs(Subscriber var1) throws APIManagementException;

    public String addResourceFile(Identifier var1, String var2, ResourceFile var3) throws APIManagementException;

    public ResourceFile getIcon(APIIdentifier var1) throws APIManagementException;

    public ResourceFile getIcon(String var1, String var2) throws APIManagementException;

    public void cleanup() throws APIManagementException;

    public Application getApplicationByUUID(String var1) throws APIManagementException;

    public Application getApplicationByUUID(String var1, String var2) throws APIManagementException;

    public Application getLightweightApplicationByUUID(String var1) throws APIManagementException;

    public Set<APIIdentifier> getAPIByAccessToken(String var1) throws APIManagementException;

    public Set<Tier> getAllTiers() throws APIManagementException;

    public Set<Tier> getAllTiers(String var1) throws APIManagementException;

    public Set<Tier> getTiers() throws APIManagementException;

    public Set<Tier> getTiers(String var1) throws APIManagementException;

    public Set<Tier> getTiers(int var1, String var2) throws APIManagementException;

    public Map<String, String> getTenantDomainMappings(String var1, String var2) throws APIManagementException;

    public boolean isScopeKeyExist(String var1, int var2) throws APIManagementException;

    public boolean isScopeKeyAssignedToAPI(String var1, String var2) throws APIManagementException;

    public boolean isScopeKeyAssignedLocally(APIIdentifier var1, String var2, int var3) throws APIManagementException;

    public boolean isDuplicateContextTemplate(String var1) throws APIManagementException;

    public List<String> getApiNamesMatchingContext(String var1) throws APIManagementException;

    public Policy[] getPolicies(String var1, String var2) throws APIManagementException;

    public Map<String, Object> searchPaginatedAPIs(String var1, String var2, int var3, int var4, boolean var5) throws APIManagementException;

    public Map<String, Object> searchPaginatedAPIs(String var1, String var2, int var3, int var4, boolean var5, boolean var6) throws APIManagementException;

    public Map<String, String> getSwaggerDefinitionTimeStamps(APIIdentifier var1) throws APIManagementException;

    public String getThumbnailLastUpdatedTime(APIIdentifier var1) throws APIManagementException;

    public List<Mediation> getAllGlobalMediationPolicies() throws APIManagementException;

    public boolean deleteGlobalMediationPolicy(String var1) throws APIManagementException;

    public Mediation getGlobalMediationPolicy(String var1) throws APIManagementException;

    public String getCreatedResourceUuid(String var1);

    public Resource getCustomMediationResourceFromUuid(String var1) throws APIManagementException;

    public Resource getApiSpecificMediationResourceFromUuid(Identifier var1, String var2, String var3) throws APIManagementException;

    public List<Mediation> getAllApiSpecificMediationPolicies(APIIdentifier var1) throws APIManagementException;

    public String getMediationNameFromConfig(String var1);

    public Mediation getApiSpecificMediationPolicy(Identifier var1, String var2, String var3) throws APIManagementException;

    public Boolean deleteApiSpecificMediationPolicy(Identifier var1, String var2, String var3) throws APIManagementException;

    public boolean checkIfResourceExists(String var1) throws APIManagementException;

    public List<String> getApiVersionsMatchingApiName(String var1, String var2) throws APIManagementException;

    @Deprecated
    public List<Wsdl> getAllWsdls() throws APIManagementException;

    @Deprecated
    public Wsdl getWsdlById(String var1) throws APIManagementException;

    @Deprecated
    public Resource getWsdlResourceFromUuid(String var1) throws APIManagementException;

    @Deprecated
    public boolean deleteWsdl(String var1) throws APIManagementException;

    @Deprecated
    public void uploadWsdl(String var1, String var2) throws APIManagementException;

    @Deprecated
    public void updateWsdl(String var1, String var2) throws APIManagementException;

    public ResourceFile getWSDL(APIIdentifier var1) throws APIManagementException;

    public ResourceFile getWSDL(String var1, String var2) throws APIManagementException;

    public String getGraphqlSchema(APIIdentifier var1) throws APIManagementException;

    public Application getApplicationBySubscriberIdAndName(int var1, String var2) throws APIManagementException;

    public APIProduct getAPIProductbyUUID(String var1, String var2) throws APIManagementException;

    public APIProduct getAPIProduct(APIProductIdentifier var1) throws APIManagementException;

    public Map<String, Object> searchPaginatedAPIProducts(String var1, String var2, int var3, int var4) throws APIManagementException;

    public List<APIProductResource> getResourcesOfAPIProduct(APIProductIdentifier var1) throws APIManagementException;

    public ResourceFile getProductIcon(APIProductIdentifier var1) throws APIManagementException;

    public String addProductResourceFile(APIProductIdentifier var1, String var2, ResourceFile var3) throws APIManagementException;

    public Documentation getProductDocumentation(String var1, String var2) throws APIManagementException;

    public String getAPIDefinitionOfAPIProduct(APIProduct var1) throws APIManagementException;

    public Map<String, Object> searchPaginatedAPIs(String var1, String var2, int var3, int var4) throws APIManagementException;

    public Map<String, Object> searchPaginatedContent(String var1, String var2, int var3, int var4) throws APIManagementException;

    public String getAsyncAPIDefinition(Identifier var1) throws APIManagementException;
}

