/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.api;

import org.wso2.carbon.apimgt.api.ErrorHandler;
import org.wso2.carbon.apimgt.api.ExceptionCodes;

public class APIManagementException
extends Exception {
    private ErrorHandler errorHandler;

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public APIManagementException(String msg) {
        super(msg);
        this.errorHandler = ExceptionCodes.INTERNAL_ERROR;
    }

    public APIManagementException(String msg, Throwable e) {
        super(msg, e);
        this.errorHandler = ExceptionCodes.INTERNAL_ERROR;
    }

    public APIManagementException(Throwable throwable) {
        super(throwable);
        this.errorHandler = ExceptionCodes.INTERNAL_ERROR;
    }

    public APIManagementException(String message, ErrorHandler code) {
        super(message);
        this.errorHandler = code;
    }

    public APIManagementException(ErrorHandler code) {
        super(code.getErrorCode() + ":" + code.getErrorMessage() + "::" + code.getErrorDescription());
        this.errorHandler = code;
    }

    public APIManagementException(String message, Throwable cause, ErrorHandler code) {
        super(message, cause);
        this.errorHandler = code;
    }
}

