/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.api;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wso2.carbon.apimgt.api.APIDefinitionValidationResponse;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIProduct;
import org.wso2.carbon.apimgt.api.model.Scope;
import org.wso2.carbon.apimgt.api.model.SwaggerData;
import org.wso2.carbon.apimgt.api.model.URITemplate;

public abstract class APIDefinition {
    private static final Pattern CURLY_BRACES_PATTERN = Pattern.compile("(?<=\\{)(?!\\s*\\{)[^{}]+");

    public abstract Map<String, Object> generateExample(String var1) throws APIManagementException;

    public abstract Set<URITemplate> getURITemplates(String var1) throws APIManagementException;

    public abstract Set<Scope> getScopes(String var1) throws APIManagementException;

    public abstract String generateAPIDefinition(SwaggerData var1) throws APIManagementException;

    public abstract String generateAPIDefinition(SwaggerData var1, String var2) throws APIManagementException;

    public List<String> getPathParamNames(String uriTemplate) {
        ArrayList<String> params = new ArrayList<String>();
        Matcher bracesMatcher = CURLY_BRACES_PATTERN.matcher(uriTemplate);
        while (bracesMatcher.find()) {
            params.add(bracesMatcher.group());
        }
        return params;
    }

    public Map<String, Map<String, SwaggerData.Resource>> getResourceMap(SwaggerData swaggerData) {
        LinkedHashMap<String, Map<String, SwaggerData.Resource>> uriTemplateMap = new LinkedHashMap<String, Map<String, SwaggerData.Resource>>();
        for (SwaggerData.Resource resource : swaggerData.getResources()) {
            LinkedHashMap<String, SwaggerData.Resource> resources = (LinkedHashMap<String, SwaggerData.Resource>)uriTemplateMap.get(resource.getPath());
            if (resources == null) {
                resources = new LinkedHashMap<String, SwaggerData.Resource>();
                uriTemplateMap.put(resource.getPath(), resources);
            }
            resources.put(resource.getVerb().toUpperCase(), resource);
        }
        return uriTemplateMap;
    }

    public abstract APIDefinitionValidationResponse validateAPIDefinition(String var1, boolean var2) throws APIManagementException;

    public abstract String populateCustomManagementInfo(String var1, SwaggerData var2) throws APIManagementException;

    public abstract String getOASDefinitionForStore(API var1, String var2, Map<String, String> var3) throws APIManagementException;

    public abstract String getOASDefinitionForStore(APIProduct var1, String var2, Map<String, String> var3) throws APIManagementException;

    public abstract String getOASDefinitionForPublisher(API var1, String var2) throws APIManagementException;

    public abstract String getOASVersion(String var1) throws APIManagementException;

    public abstract String getOASDefinitionWithTierContentAwareProperty(String var1, List<String> var2, String var3) throws APIManagementException;

    public abstract String processOtherSchemeScopes(String var1) throws APIManagementException;

    public abstract String injectMgwThrottlingExtensionsToDefault(String var1) throws APIManagementException;

    public abstract API setExtensionsToAPI(String var1, API var2) throws APIManagementException;

    public abstract String copyVendorExtensions(String var1, String var2) throws APIManagementException;

    public abstract String processDisableSecurityExtension(String var1) throws APIManagementException;
}

