/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.um.ws.service;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.user.api.Claim;
import org.wso2.carbon.user.api.ClaimMapping;
import org.wso2.carbon.user.core.UserStoreException;

public class Util {
    private static final Log log = LogFactory.getLog(Util.class.getClass());
    private static final String PROTECTED_STRING = "protected";

    private Util() {
    }

    static void checkAccess(String resourceId) throws UserStoreException {
        if (Util.isSuperTenantResource(resourceId) && !Util.isSuperTenant()) {
            StringBuilder stringBuilder = new StringBuilder("Unauthorized attempt to modify super tenant resource by tenant domain - ");
            stringBuilder.append(CarbonContext.getThreadLocalCarbonContext().getTenantDomain()).append(" tenant id - ").append(CarbonContext.getThreadLocalCarbonContext().getTenantId()).append(" user - ").append(CarbonContext.getThreadLocalCarbonContext().getUsername());
            log.warn((Object)stringBuilder.toString());
            throw new UserStoreException("Access Denied");
        }
    }

    private static boolean isSuperTenantResource(String resource) {
        return resource.contains(PROTECTED_STRING);
    }

    static boolean isSuperTenant() {
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        return tenantId == -1234;
    }

    static Claim ensureInstanceType(Claim claim) {
        if (claim == null) {
            return new Claim();
        }
        if (Claim.class.getName().equals(claim.getClass().getName())) {
            return claim;
        }
        Claim apiClaim = new Claim();
        apiClaim.setClaimUri(claim.getClaimUri());
        apiClaim.setReadOnly(claim.isReadOnly());
        apiClaim.setCheckedAttribute(claim.isCheckedAttribute());
        apiClaim.setDisplayTag(claim.getDisplayTag());
        apiClaim.setDescription(claim.getDescription());
        apiClaim.setSupportedByDefault(claim.isSupportedByDefault());
        apiClaim.setRequired(claim.isRequired());
        apiClaim.setRegEx(claim.getRegEx());
        apiClaim.setDialectURI(claim.getDialectURI());
        apiClaim.setValue(claim.getValue());
        apiClaim.setDisplayOrder(claim.getDisplayOrder());
        return apiClaim;
    }

    static ClaimMapping ensureInstanceType(ClaimMapping claimMapping) {
        if (claimMapping == null) {
            return new ClaimMapping();
        }
        if (ClaimMapping.class.getName().equals(claimMapping.getClass().getName())) {
            return claimMapping;
        }
        ClaimMapping apiClaimMapping = new ClaimMapping(Util.ensureInstanceType(claimMapping.getClaim()), claimMapping.getMappedAttribute());
        apiClaimMapping.setMappedAttributes(claimMapping.getMappedAttributes());
        return apiClaimMapping;
    }

    static ClaimMapping[] ensureInstanceType(ClaimMapping[] claimMappings) {
        if (claimMappings == null) {
            return claimMappings;
        }
        ClaimMapping[] apiClaimMappings = new ClaimMapping[claimMappings.length];
        for (int i = 0; i < claimMappings.length; ++i) {
            apiClaimMappings[i] = Util.ensureInstanceType(claimMappings[i]);
        }
        return apiClaimMappings;
    }
}

