/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.um.ws.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.um.ws.service.Util;
import org.wso2.carbon.um.ws.service.dao.ClaimDTO;
import org.wso2.carbon.um.ws.service.dao.PermissionDTO;
import org.wso2.carbon.user.api.Permission;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.claim.Claim;
import org.wso2.carbon.user.core.tenant.Tenant;
import org.wso2.carbon.user.mgt.common.ClaimValue;

public class UserStoreManagerService
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(UserStoreManagerService.class.getClass());
    private static final String AUTH_FAIL = "Unauthorized attempt to execute super tenant operation by tenant domain - ";
    private static final String NULL_REALM_MESSAGE = "UserRealm is null";
    private static final String EMPTY = "";
    private static final String MULTI_ATTRIBUTE_SEPARATOR = "MultiAttributeSeparator";

    public void addUser(String userName, String credential, String[] roleList, ClaimValue[] claims, String profileName, boolean requirePasswordChange) throws UserStoreException {
        this.getUserStoreManager().addUser(userName, (Object)credential, roleList, this.convertClaimValueToMap(claims), profileName, requirePasswordChange);
    }

    public void setUserClaimValues(String userName, ClaimValue[] claims, String profileName) throws UserStoreException {
        this.getUserStoreManager().setUserClaimValues(userName, this.convertClaimValueToMap(claims), profileName);
    }

    public void addUserClaimValues(String userName, ClaimValue[] claims, String profileName) throws UserStoreException {
        String userAttributeSeparator = ",";
        String claimSeparator = super.getUserRealm().getRealmConfiguration().getUserStoreProperty(MULTI_ATTRIBUTE_SEPARATOR);
        if (StringUtils.isNotBlank((String)claimSeparator)) {
            userAttributeSeparator = claimSeparator;
        }
        for (ClaimValue claim : claims) {
            String existingClaimValue = this.getUserStoreManager().getUserClaimValue(userName, claim.getClaimURI(), profileName);
            if (existingClaimValue == null) {
                existingClaimValue = EMPTY;
            }
            if (!StringUtils.isNotBlank((String)claim.getValue())) continue;
            boolean claimValueAlreadyExists = false;
            if (existingClaimValue.contains(userAttributeSeparator)) {
                StringTokenizer st = new StringTokenizer(existingClaimValue, userAttributeSeparator);
                while (st.hasMoreElements()) {
                    String existingValue = st.nextElement().toString();
                    if (!existingValue.equalsIgnoreCase(claim.getValue())) continue;
                    claimValueAlreadyExists = true;
                }
            } else if (existingClaimValue.equalsIgnoreCase(claim.getValue())) {
                claimValueAlreadyExists = true;
            }
            if (claimValueAlreadyExists) continue;
            String claimValue = !EMPTY.equals(existingClaimValue) ? existingClaimValue + userAttributeSeparator + claim.getValue() : claim.getValue();
            this.getUserStoreManager().setUserClaimValue(userName, claim.getClaimURI(), claimValue, profileName);
        }
    }

    public ClaimValue[] getUserClaimValuesForClaims(String userName, String[] claims, String profileName) throws UserStoreException {
        return this.convertMapToClaimValue(this.getUserStoreManager().getUserClaimValues(userName, claims, profileName));
    }

    public void addRole(String roleName, String[] userList, PermissionDTO[] permissions) throws UserStoreException {
        try {
            this.getUserStoreManager().addRole(roleName, userList, this.convertDTOToPermission(permissions), false);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw (UserStoreException)e;
        }
    }

    public ClaimDTO[] getUserClaimValues(String userName, String profileName) throws UserStoreException {
        return this.convertClaimToClaimDTO(this.getUserStoreManager().getUserClaimValues(userName, profileName));
    }

    public boolean authenticate(String userName, String credential) throws UserStoreException {
        return this.getUserStoreManager().authenticate(userName, (Object)credential);
    }

    public void updateCredential(String userName, String newCredential, String oldCredential) throws UserStoreException {
        this.getUserStoreManager().updateCredential(userName, (Object)newCredential, (Object)oldCredential);
    }

    public void updateCredentialByAdmin(String userName, String newCredential) throws UserStoreException {
        this.getUserStoreManager().updateCredentialByAdmin(userName, (Object)newCredential);
    }

    public long getPasswordExpirationTime(String username) throws UserStoreException {
        Date date = this.getUserStoreManager().getPasswordExpirationTime(username);
        if (date != null) {
            return date.getTime();
        }
        return -1L;
    }

    public void deleteRole(String roleName) throws UserStoreException {
        this.getUserStoreManager().deleteRole(roleName);
    }

    public void deleteUser(String userName) throws UserStoreException {
        this.getUserStoreManager().deleteUser(userName);
    }

    public void deleteUserClaimValue(String userName, String claimURI, String profileName) throws UserStoreException {
        this.getUserStoreManager().deleteUserClaimValue(userName, claimURI, profileName);
    }

    public void deleteUserClaimValues(String userName, String[] claims, String profileName) throws UserStoreException {
        this.getUserStoreManager().deleteUserClaimValues(userName, claims, profileName);
    }

    public String[] getAllProfileNames() throws UserStoreException {
        return this.getUserStoreManager().getAllProfileNames();
    }

    public String[] getHybridRoles() throws UserStoreException {
        return this.getUserStoreManager().getHybridRoles();
    }

    public String[] getProfileNames(String userName) throws UserStoreException {
        return this.getUserStoreManager().getProfileNames(userName);
    }

    public String[] getRoleListOfUser(String userName) throws UserStoreException {
        return this.getUserStoreManager().getRoleListOfUser(userName);
    }

    public String[] getRoleNames() throws UserStoreException {
        return this.getUserStoreManager().getRoleNames();
    }

    public int getTenantId() throws UserStoreException {
        return this.getUserStoreManager().getTenantId();
    }

    public String[] getUserList(String claimUri, String claimValue, String profile) throws UserStoreException {
        return this.getUserStoreManager().getUserList(claimUri, claimValue, profile);
    }

    public int getTenantIdofUser(String username) throws UserStoreException {
        if (Util.isSuperTenant()) {
            return this.getUserStoreManager().getTenantId(username);
        }
        StringBuilder stringBuilder = new StringBuilder(AUTH_FAIL);
        stringBuilder.append(CarbonContext.getThreadLocalCarbonContext().getTenantDomain()).append(" tenant id - ").append(CarbonContext.getThreadLocalCarbonContext().getTenantId()).append(" user - ").append(CarbonContext.getThreadLocalCarbonContext().getUsername());
        log.warn((Object)stringBuilder.toString());
        throw new UserStoreException("Access Denied");
    }

    public String getUserClaimValue(String userName, String claim, String profileName) throws UserStoreException {
        return this.getUserStoreManager().getUserClaimValue(userName, claim, profileName);
    }

    public int getUserId(String username) throws UserStoreException {
        return this.getUserStoreManager().getUserId(username);
    }

    public String[] getUserListOfRole(String roleName) throws UserStoreException {
        return this.getUserStoreManager().getUserListOfRole(roleName);
    }

    public boolean isExistingRole(String roleName) throws UserStoreException {
        return this.getUserStoreManager().isExistingRole(roleName);
    }

    public boolean isExistingUser(String userName) throws UserStoreException {
        return this.getUserStoreManager().isExistingUser(userName);
    }

    public boolean isReadOnly() throws UserStoreException {
        return this.getUserStoreManager().isReadOnly();
    }

    public String[] listUsers(String filter, int maxItemLimit) throws UserStoreException {
        return this.getUserStoreManager().listUsers(filter, maxItemLimit);
    }

    public void setUserClaimValue(String userName, String claimURI, String claimValue, String profileName) throws UserStoreException {
        this.getUserStoreManager().setUserClaimValue(userName, claimURI, claimValue, profileName);
    }

    public void addUserClaimValue(String userName, String claimURI, String claimValue, String profileName) throws UserStoreException {
        String existingClaimValue = this.getUserStoreManager().getUserClaimValue(userName, claimURI, profileName);
        if (existingClaimValue == null) {
            existingClaimValue = EMPTY;
        }
        if (claimValue != null && !EMPTY.equals(claimValue) && !EMPTY.equals(existingClaimValue)) {
            claimValue = existingClaimValue + "," + claimValue;
        }
        this.getUserStoreManager().setUserClaimValue(userName, claimURI, claimValue, profileName);
    }

    public void updateRoleListOfUser(String userName, String[] deletedRoles, String[] newRoles) throws UserStoreException {
        this.getUserStoreManager().updateRoleListOfUser(userName, deletedRoles, newRoles);
    }

    public void updateRoleName(String roleName, String newRoleName) throws UserStoreException {
        this.getUserStoreManager().updateRoleName(roleName, newRoleName);
    }

    public void updateUserListOfRole(String roleName, String[] deletedUsers, String[] newUsers) throws UserStoreException {
        this.getUserStoreManager().updateUserListOfRole(roleName, deletedUsers, newUsers);
    }

    private UserStoreManager getUserStoreManager() throws UserStoreException {
        try {
            UserRealm realm = super.getUserRealm();
            if (realm == null) {
                throw new UserStoreException(NULL_REALM_MESSAGE);
            }
            return realm.getUserStoreManager();
        }
        catch (Exception e) {
            throw new UserStoreException((Throwable)e);
        }
    }

    private Map<String, String> convertClaimValueToMap(ClaimValue[] values) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (ClaimValue claimValue : values) {
            map.put(claimValue.getClaimURI(), claimValue.getValue());
        }
        return map;
    }

    private ClaimValue[] convertMapToClaimValue(Map<String, String> map) {
        ClaimValue[] claims = new ClaimValue[map.size()];
        Iterator<Map.Entry<String, String>> ite = map.entrySet().iterator();
        int i = 0;
        while (ite.hasNext()) {
            Map.Entry<String, String> entry = ite.next();
            claims[i] = new ClaimValue();
            claims[i].setClaimURI(entry.getKey());
            claims[i].setValue(entry.getValue());
            ++i;
        }
        return claims;
    }

    private ClaimDTO[] convertClaimToClaimDTO(Claim[] claims) {
        ArrayList<ClaimDTO> ClaimDTOs = new ArrayList<ClaimDTO>();
        for (Claim claim : claims) {
            ClaimDTO claimDTO = new ClaimDTO();
            claimDTO.setClaimUri(claim.getClaimUri());
            claimDTO.setValue(claim.getValue());
            claimDTO.setDescription(claim.getDescription());
            claimDTO.setDialectURI(claim.getDialectURI());
            claimDTO.setDisplayOrder(claim.getDisplayOrder());
            claimDTO.setRegEx(claim.getRegEx());
            claimDTO.setSupportedByDefault(claim.isSupportedByDefault());
            claimDTO.setRequired(claim.isRequired());
            ClaimDTOs.add(claimDTO);
        }
        return ClaimDTOs.toArray(new ClaimDTO[ClaimDTOs.size()]);
    }

    private Permission[] convertDTOToPermission(PermissionDTO[] permissionDTOs) {
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        for (PermissionDTO permissionDTO : permissionDTOs) {
            Permission permission = new Permission(permissionDTO.getResourceId(), permissionDTO.getAction());
            permissions.add(permission);
        }
        return permissions.toArray(new Permission[permissions.size()]);
    }

    public String[][] getProperties(Tenant tenant) throws UserStoreException {
        if (!Util.isSuperTenant()) {
            StringBuilder stringBuilder = new StringBuilder(AUTH_FAIL);
            stringBuilder.append(CarbonContext.getThreadLocalCarbonContext().getTenantDomain()).append(" tenant id - ").append(CarbonContext.getThreadLocalCarbonContext().getTenantId()).append(" user - ").append(CarbonContext.getThreadLocalCarbonContext().getUsername());
            log.warn((Object)stringBuilder.toString());
            throw new UserStoreException("Access Denied");
        }
        return new String[0][0];
    }
}

