/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.um.ws.service;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.um.ws.service.Util;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserRealm;

public class AuthorizationManagerService
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(AuthorizationManagerService.class.getClass());
    private static final String NULL_REALM_MESSAGE = "User realm is null";

    public void authorizeRole(String roleName, String resourceId, String action) throws org.wso2.carbon.user.core.UserStoreException {
        Util.checkAccess(resourceId);
        this.getAuthorizationManager().authorizeRole(roleName, resourceId, action);
    }

    public void authorizeUser(String userName, String resourceId, String action) throws org.wso2.carbon.user.core.UserStoreException {
        Util.checkAccess(resourceId);
        this.getAuthorizationManager().authorizeUser(userName, resourceId, action);
    }

    public void clearResourceAuthorizations(String resourceId) throws org.wso2.carbon.user.core.UserStoreException {
        this.getAuthorizationManager().clearResourceAuthorizations(resourceId);
    }

    public void clearRoleActionOnAllResources(String roleName, String action) throws org.wso2.carbon.user.core.UserStoreException {
        this.getAuthorizationManager().clearRoleActionOnAllResources(roleName, action);
    }

    public void clearRoleAuthorization(String roleName, String resourceId, String action) throws org.wso2.carbon.user.core.UserStoreException {
        this.getAuthorizationManager().clearRoleAuthorization(roleName, resourceId, action);
    }

    public void clearAllRoleAuthorization(String roleName) throws org.wso2.carbon.user.core.UserStoreException {
        this.getAuthorizationManager().clearRoleAuthorization(roleName);
    }

    public void clearUserAuthorization(String userName, String resourceId, String action) throws org.wso2.carbon.user.core.UserStoreException {
        this.getAuthorizationManager().clearUserAuthorization(userName, resourceId, action);
    }

    public void clearAllUserAuthorization(String userName) throws org.wso2.carbon.user.core.UserStoreException {
        this.getAuthorizationManager().clearUserAuthorization(userName);
    }

    public void denyRole(String roleName, String resourceId, String action) throws org.wso2.carbon.user.core.UserStoreException {
        this.getAuthorizationManager().denyRole(roleName, resourceId, action);
    }

    public void denyUser(String userName, String resourceId, String action) throws org.wso2.carbon.user.core.UserStoreException {
        this.getAuthorizationManager().denyUser(userName, resourceId, action);
    }

    public String[] getAllowedRolesForResource(String resourceId, String action) throws org.wso2.carbon.user.core.UserStoreException {
        return this.getAuthorizationManager().getAllowedRolesForResource(resourceId, action);
    }

    public String[] getDeniedRolesForResource(String resourceId, String action) throws org.wso2.carbon.user.core.UserStoreException {
        return this.getAuthorizationManager().getDeniedRolesForResource(resourceId, action);
    }

    public String[] getExplicitlyAllowedUsersForResource(String resourceId, String action) throws org.wso2.carbon.user.core.UserStoreException {
        return this.getAuthorizationManager().getExplicitlyAllowedUsersForResource(resourceId, action);
    }

    public String[] getExplicitlyDeniedUsersForResource(String resourceId, String action) throws org.wso2.carbon.user.core.UserStoreException {
        return this.getAuthorizationManager().getExplicitlyDeniedUsersForResource(resourceId, action);
    }

    public boolean isRoleAuthorized(String roleName, String resourceId, String action) throws org.wso2.carbon.user.core.UserStoreException {
        return this.getAuthorizationManager().isRoleAuthorized(roleName, resourceId, action);
    }

    public boolean isUserAuthorized(String userName, String resourceId, String action) throws org.wso2.carbon.user.core.UserStoreException {
        return this.getAuthorizationManager().isUserAuthorized(userName, resourceId, action);
    }

    public String[] getAllowedUIResourcesForUser(String userName, String permissionRootPath) throws org.wso2.carbon.user.core.UserStoreException {
        return this.getAuthorizationManager().getAllowedUIResourcesForUser(userName, permissionRootPath);
    }

    public String[] getAllowedUIResourcesForRole(String roleName, String permissionRootPath) throws org.wso2.carbon.user.core.UserStoreException {
        return this.getAuthorizationManager().getAllowedUIResourcesForRole(roleName, permissionRootPath);
    }

    public void resetPermissionOnUpdateRole(String roleName, String newRoleName) throws org.wso2.carbon.user.core.UserStoreException {
        this.getAuthorizationManager().resetPermissionOnUpdateRole(roleName, newRoleName);
    }

    public void refreshAllowedRolesForResource(String resourceId) throws org.wso2.carbon.user.core.UserStoreException {
        try {
            this.getAuthorizationManager().refreshAllowedRolesForResource(resourceId);
        }
        catch (UserStoreException e) {
            throw new org.wso2.carbon.user.core.UserStoreException((Throwable)e);
        }
    }

    private AuthorizationManager getAuthorizationManager() throws org.wso2.carbon.user.core.UserStoreException {
        try {
            UserRealm realm = super.getUserRealm();
            if (realm == null) {
                throw new org.wso2.carbon.user.core.UserStoreException(NULL_REALM_MESSAGE);
            }
            return realm.getAuthorizationManager();
        }
        catch (Exception e) {
            throw new org.wso2.carbon.user.core.UserStoreException((Throwable)e);
        }
    }
}

