/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.services.utils;

import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class RenameResourceUtil {
    private static final Log log = LogFactory.getLog(RenameResourceUtil.class);

    public static void renameResource(String parentPath, String oldResourcePath, String newResourceName, UserRegistry registry) throws Exception {
        if (!parentPath.endsWith("/")) {
            parentPath = parentPath + "/";
        }
        String newResourcePath = newResourceName.startsWith("/") ? newResourceName : parentPath + newResourceName;
        try {
            registry.rename(oldResourcePath, newResourcePath);
        }
        catch (RegistryException e) {
            String msg = "Failed to rename the resource: " + oldResourcePath + " to name: " + newResourcePath + ". Caused by: " + (e.getCause() instanceof SQLException ? "" : e.getMessage());
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }
}

