/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.services.utils;

import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class DeleteUtil {
    private static final Log log = LogFactory.getLog(DeleteUtil.class);

    public static void process(String pathToDelete, UserRegistry registry) throws Exception {
        try {
            if ("/".equals(pathToDelete) || "/_system".equals(pathToDelete) || "/_system/governance".equals(pathToDelete) || "/_system/config".equals(pathToDelete) || "/_system/local".equals(pathToDelete)) {
                throw new RegistryException("Unable to delete system collection at " + pathToDelete + ".");
            }
            registry.delete(pathToDelete);
        }
        catch (RegistryException e) {
            String msg = "Failed to delete " + pathToDelete + ". " + (e.getCause() instanceof SQLException ? "" : e.getMessage());
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }
}

